/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.twitch4j.common.exception.NotFoundException;
import com.github.twitch4j.common.exception.UnauthorizedException;
import com.github.twitch4j.helix.domain.TwitchHelixError;
import feign.Request;
import feign.Response;
import feign.RetryableException;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchHelixErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixErrorDecoder.class);
    final Decoder decoder;
    final ErrorDecoder defaultDecoder = new ErrorDecoder.Default();
    final ObjectMapper objectMapper = new ObjectMapper();

    public TwitchHelixErrorDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public Exception decode(String methodKey, Response response) {
        Exception ex = null;
        try {
            String responseBody;
            String string = responseBody = response.body() == null ? "" : IOUtils.toString((InputStream)response.body().asInputStream(), (String)StandardCharsets.UTF_8.name());
            if (response.status() == 401) {
                ex = new UnauthorizedException().addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("requestHeaders", (Object)response.request().headers().entrySet().toString()).addContextValue("responseBody", (Object)responseBody);
            } else if (response.status() == 404) {
                ex = new NotFoundException().addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("requestHeaders", (Object)response.request().headers().entrySet().toString()).addContextValue("responseBody", (Object)responseBody);
            } else if (response.status() == 429) {
                ex = new ContextedRuntimeException("To many requests!").addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("requestHeaders", (Object)response.request().headers().entrySet().toString()).addContextValue("responseBody", (Object)responseBody);
            } else if (response.status() == 503) {
                ex = new RetryableException(response.status(), "getting service unavailable, retrying ...", Request.HttpMethod.GET, null, response.request());
            } else {
                TwitchHelixError error = (TwitchHelixError)this.objectMapper.readValue(responseBody, TwitchHelixError.class);
                ex = new ContextedRuntimeException("Helix API Error").addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("requestHeaders", (Object)response.request().headers().entrySet().toString()).addContextValue("responseBody", (Object)responseBody).addContextValue("errorType", (Object)error.getError()).addContextValue("errorStatus", (Object)error.getStatus()).addContextValue("errorType", (Object)error.getMessage());
            }
        }
        catch (IOException fallbackToDefault) {
            ex = this.defaultDecoder.decode(methodKey, response);
        }
        return ex;
    }
}

