/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.helix;

import com.github.twitch4j.common.feign.ObjectToJsonExpander;
import com.github.twitch4j.helix.domain.AutomodEnforceCheckList;
import com.github.twitch4j.helix.domain.AutomodEnforceStatusList;
import com.github.twitch4j.helix.domain.BannedEventList;
import com.github.twitch4j.helix.domain.BannedUserList;
import com.github.twitch4j.helix.domain.BitsLeaderboard;
import com.github.twitch4j.helix.domain.CategorySearchList;
import com.github.twitch4j.helix.domain.ChannelInformation;
import com.github.twitch4j.helix.domain.ChannelInformationList;
import com.github.twitch4j.helix.domain.ChannelSearchList;
import com.github.twitch4j.helix.domain.CheermoteList;
import com.github.twitch4j.helix.domain.ClipList;
import com.github.twitch4j.helix.domain.CodeStatusList;
import com.github.twitch4j.helix.domain.CommercialList;
import com.github.twitch4j.helix.domain.CreateClipList;
import com.github.twitch4j.helix.domain.DropsEntitlementList;
import com.github.twitch4j.helix.domain.ExtensionActiveList;
import com.github.twitch4j.helix.domain.ExtensionAnalyticsList;
import com.github.twitch4j.helix.domain.ExtensionList;
import com.github.twitch4j.helix.domain.ExtensionTransactionList;
import com.github.twitch4j.helix.domain.FollowList;
import com.github.twitch4j.helix.domain.GameAnalyticsList;
import com.github.twitch4j.helix.domain.GameList;
import com.github.twitch4j.helix.domain.GameTopList;
import com.github.twitch4j.helix.domain.Highlight;
import com.github.twitch4j.helix.domain.HypeTrainEventList;
import com.github.twitch4j.helix.domain.ModeratorEventList;
import com.github.twitch4j.helix.domain.ModeratorList;
import com.github.twitch4j.helix.domain.StreamKeyList;
import com.github.twitch4j.helix.domain.StreamList;
import com.github.twitch4j.helix.domain.StreamMarker;
import com.github.twitch4j.helix.domain.StreamMarkersList;
import com.github.twitch4j.helix.domain.StreamTagList;
import com.github.twitch4j.helix.domain.SubscriptionList;
import com.github.twitch4j.helix.domain.UploadEntitlementUrlList;
import com.github.twitch4j.helix.domain.UserList;
import com.github.twitch4j.helix.domain.VideoList;
import com.github.twitch4j.helix.domain.WebhookSubscriptionList;
import com.github.twitch4j.helix.webhooks.domain.WebhookRequest;
import com.netflix.hystrix.HystrixCommand;
import feign.Body;
import feign.CollectionFormat;
import feign.Headers;
import feign.Param;
import feign.RequestLine;
import feign.Response;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public interface TwitchHelix {
    @RequestLine(value="GET /analytics/extensions?after={after}&ended_at={ended_at}&first={first}&extension_id={extension_id}&started_at={started_at}&type={type}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<ExtensionAnalyticsList> getExtensionAnalyticUrl(@Param(value="token") String var1, @Param(value="after") String var2, @Param(value="first") Integer var3, @Param(value="extension_id") String var4, @Param(value="type") String var5, @Param(value="started_at") String var6, @Param(value="ended_at") String var7);

    @RequestLine(value="GET /analytics/games?after={after}&ended_at={ended_at}&first={first}&game_id={game_id}&started_at={started_at}&type={type}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<GameAnalyticsList> getGameAnalyticUrl(@Param(value="token") String var1, @Param(value="after") String var2, @Param(value="first") Integer var3, @Param(value="game_id") String var4, @Param(value="type") String var5, @Param(value="started_at") String var6, @Param(value="ended_at") String var7);

    @RequestLine(value="GET /bits/cheermotes?broadcaster_id={broadcaster_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<CheermoteList> getCheermotes(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2);

    @RequestLine(value="GET /bits/leaderboard?count={count}&period={period}&started_at={started_at}&user_id={user_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<BitsLeaderboard> getBitsLeaderboard(@Param(value="token") String var1, @Param(value="count") String var2, @Param(value="period") String var3, @Param(value="started_at") String var4, @Param(value="user_id") String var5);

    @RequestLine(value="GET /entitlements/codes?code={code}&user_id={user_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<CodeStatusList> getCodeStatus(@Param(value="token") String var1, @Param(value="code") List<String> var2, @Param(value="user_id") Integer var3);

    @RequestLine(value="POST /entitlements/codes?code={code}&user_id={user_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<CodeStatusList> redeemCode(@Param(value="token") String var1, @Param(value="code") List<String> var2, @Param(value="user_id") Integer var3);

    @RequestLine(value="GET /entitlements/drops?id={id}&user_id={user_id}&game_id={game_id}&after={after}&first={first}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<DropsEntitlementList> getDropsEntitlements(@Param(value="token") String var1, @Param(value="id") String var2, @Param(value="user_id") String var3, @Param(value="game_id") String var4, @Param(value="after") String var5, @Param(value="first") Integer var6);

    @RequestLine(value="GET /extensions/transactions?after={after}&extension_id={extension_id}&first={first}&id={id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<ExtensionTransactionList> getExtensionTransactions(@Param(value="token") String var1, @Param(value="extension_id") String var2, @Param(value="id") List<String> var3, @Param(value="after") String var4, @Param(value="first") Integer var5);

    @RequestLine(value="GET /search/categories?after={after}&first={first}&query={query}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<CategorySearchList> searchCategories(@Param(value="token") String var1, @Param(value="query") String var2, @Param(value="first") Integer var3, @Param(value="after") String var4);

    @RequestLine(value="GET /channels?broadcaster_id={broadcaster_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<ChannelInformationList> getChannelInformation(@Param(value="token") String var1, @Param(value="broadcaster_id") List<String> var2);

    @RequestLine(value="PATCH /channels?broadcaster_id={broadcaster_id}")
    @Headers(value={"Authorization: Bearer {token}", "Content-Type: application/json"})
    public HystrixCommand<Void> updateChannelInformation(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, ChannelInformation var3);

    @RequestLine(value="GET /search/channels?after={after}&first={first}&live_only={live_only}&query={query}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<ChannelSearchList> searchChannels(@Param(value="token") String var1, @Param(value="query") String var2, @Param(value="first") Integer var3, @Param(value="after") String var4, @Param(value="live_only") Boolean var5);

    @RequestLine(value="POST /channels/commercial")
    @Headers(value={"Authorization: Bearer {token}", "Content-Type: application/json"})
    @Body(value="%7B\"broadcaster_id\":\"{broadcaster_id}\",\"length\":{length}%7D")
    public HystrixCommand<CommercialList> startCommercial(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="length") Integer var3);

    @RequestLine(value="POST /clips?broadcaster_id={broadcaster_id}&has_delay={has_delay}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<CreateClipList> createClip(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="has_delay") Boolean var3);

    @RequestLine(value="GET /clips?broadcaster_id={broadcaster_id}&game_id={game_id}&id={id}&after={after}&before={before}&first={first}&started_at={started_at}&ended_at={ended_at}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<ClipList> getClips(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="game_id") String var3, @Param(value="id") String var4, @Param(value="after") String var5, @Param(value="before") String var6, @Param(value="first") Integer var7, @Param(value="started_at") Instant var8, @Param(value="ended_at") Instant var9);

    @RequestLine(value="POST /entitlements/upload?manifest_id={manifest_id}&type={type}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<UploadEntitlementUrlList> createEntitlementUploadUrl(@Param(value="token") String var1, @Param(value="manifest_id") String var2, @Param(value="type") String var3);

    @RequestLine(value="GET /games?id={id}&name={name}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<GameList> getGames(@Param(value="token") String var1, @Param(value="id") List<String> var2, @Param(value="name") List<String> var3);

    @RequestLine(value="GET /hypetrain/events?broadcaster_id={broadcaster_id}&first={first}&id={id}&cursor={cursor}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<HypeTrainEventList> getHypeTrainEvents(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="first") Integer var3, @Param(value="id") String var4, @Param(value="cursor") String var5);

    @RequestLine(value="GET /moderation/banned?broadcaster_id={broadcaster_id}&user_id={user_id}&after={after}&before={before}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<BannedUserList> getBannedUsers(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="user_id") List<String> var3, @Param(value="after") String var4, @Param(value="before") String var5);

    @RequestLine(value="GET /moderation/banned/events?broadcaster_id={broadcaster_id}&user_id={user_id}&after={after}&first={first}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<BannedEventList> getBannedEvents(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="user_id") List<String> var3, @Param(value="after") String var4, @Param(value="first") Integer var5);

    @RequestLine(value="POST /moderation/enforcements/status?broadcaster_id={broadcaster_id}")
    @Headers(value={"Authorization: Bearer {token}", "Content-Type: application/json"})
    public HystrixCommand<AutomodEnforceStatusList> checkAutomodStatus(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, AutomodEnforceCheckList var3);

    @RequestLine(value="GET /moderation/moderators?broadcaster_id={broadcaster_id}&user_id={user_id}&after={after}", collectionFormat=CollectionFormat.CSV)
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<ModeratorList> getModerators(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="user_id") List<String> var3, @Param(value="after") String var4);

    @RequestLine(value="GET /moderation/moderators/events?broadcaster_id={broadcaster_id}&user_id={user_id}&after={after}", collectionFormat=CollectionFormat.CSV)
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<ModeratorEventList> getModeratorEvents(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="user_id") List<String> var3, @Param(value="after") String var4);

    @RequestLine(value="GET /games/top?after={after}&before={before}&first={first}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<GameTopList> getTopGames(@Param(value="token") String var1, @Param(value="after") String var2, @Param(value="before") String var3, @Param(value="first") String var4);

    @RequestLine(value="GET /streams?after={after}&before={before}&first={first}&game_id={game_id}&language={language}&user_id={user_id}&user_login={user_login}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<StreamList> getStreams(@Param(value="token") String var1, @Param(value="after") String var2, @Param(value="before") String var3, @Param(value="first") Integer var4, @Param(value="game_id") List<String> var5, @Param(value="language") List<String> var6, @Param(value="user_id") List<String> var7, @Param(value="user_login") List<String> var8);

    @Deprecated
    default public HystrixCommand<StreamList> getStreams(@Param(value="token") String authToken, @Param(value="after") String after, @Param(value="before") String before, @Param(value="first") Integer limit, @Param(value="community_id") List<UUID> communityId, @Param(value="game_id") List<String> gameIds, @Param(value="language") String language, @Param(value="user_id") List<String> userIds, @Param(value="user_login") List<String> userLogins) {
        return this.getStreams(authToken, after, before, limit, gameIds, Collections.singletonList(language), userIds, userLogins);
    }

    @RequestLine(value="GET /streams/key?broadcaster_id={broadcaster_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<StreamKeyList> getStreamKey(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2);

    @RequestLine(value="GET /tags/streams?after={after}&first={first}&tag_id={tag_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<StreamTagList> getAllStreamTags(@Param(value="token") String var1, @Param(value="after") String var2, @Param(value="first") Integer var3, @Param(value="tag_id") List<UUID> var4);

    @RequestLine(value="GET /streams/tags?broadcaster_id={broadcaster_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<StreamTagList> getStreamTags(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2);

    @RequestLine(value="PUT /streams/tags?broadcaster_id={broadcaster_id}")
    @Headers(value={"Authorization: Bearer {token}", "Content-Type: application/json"})
    @Body(value="%7B\"tag_ids\": [{tag_ids}]%7D")
    public HystrixCommand<Void> replaceStreamTags(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="tag_ids", expander=ObjectToJsonExpander.class) List<UUID> var3);

    @RequestLine(value="POST /streams/markers")
    @Headers(value={"Authorization: Bearer {token}", "Content-Type: application/json"})
    public HystrixCommand<StreamMarker> createStreamMarker(@Param(value="token") String var1, Highlight var2);

    @RequestLine(value="GET /streams/markers?after={after}&before={before}&first={first}&user_id={user_id}&video_id={video_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<StreamMarkersList> getStreamMarkers(@Param(value="token") String var1, @Param(value="after") String var2, @Param(value="before") String var3, @Param(value="first") Integer var4, @Param(value="user_id") String var5, @Param(value="video_id") String var6);

    @RequestLine(value="GET /subscriptions?broadcaster_id={broadcaster_id}&after={after}&before={before}&first={first}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<SubscriptionList> getSubscriptions(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="after") String var3, @Param(value="before") String var4, @Param(value="first") Integer var5);

    @RequestLine(value="GET /subscriptions?broadcaster_id={broadcaster_id}&user_id={user_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<SubscriptionList> getSubscriptionsByUser(@Param(value="token") String var1, @Param(value="broadcaster_id") String var2, @Param(value="user_id") List<String> var3);

    @RequestLine(value="GET /users?id={id}&login={login}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<UserList> getUsers(@Param(value="token") String var1, @Param(value="id") List<String> var2, @Param(value="login") List<String> var3);

    @RequestLine(value="GET /users/follows?from_id={from_id}&to_id={to_id}&after={after}&first={first}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<FollowList> getFollowers(@Param(value="token") String var1, @Param(value="from_id") String var2, @Param(value="to_id") String var3, @Param(value="after") String var4, @Param(value="first") Integer var5);

    @RequestLine(value="POST /users/follows")
    @Headers(value={"Authorization: Bearer {token}", "Content-Type: application/json"})
    @Body(value="%7B\"from_id\":\"{from_id}\",\"to_id\":\"{to_id}\",\"allow_notifications\":{allow_notifications}%7D")
    public HystrixCommand<Void> createFollow(@Param(value="token") String var1, @Param(value="from_id") String var2, @Param(value="to_id") String var3, @Param(value="allow_notifications") boolean var4);

    @RequestLine(value="DELETE /users/follows?from_id={from_id}&to_id={to_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<Void> deleteFollow(@Param(value="token") String var1, @Param(value="from_id") String var2, @Param(value="to_id") String var3);

    @RequestLine(value="PUT /users?description={description}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<UserList> updateUser(@Param(value="token") String var1, @Param(value="description") String var2);

    @RequestLine(value="GET /users/extensions/list")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<ExtensionList> getUserExtensions(@Param(value="token") String var1);

    @RequestLine(value="GET /users/extensions?user_id={user_id}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<ExtensionActiveList> getUserActiveExtensions(@Param(value="token") String var1, @Param(value="user_id") String var2);

    @RequestLine(value="PUT /users/extensions")
    @Headers(value={"Authorization: Bearer {token}", "Content-Type: application/json"})
    public HystrixCommand<ExtensionActiveList> updateUserExtensions(@Param(value="token") String var1, ExtensionActiveList var2);

    @RequestLine(value="GET /videos?id={id}&user_id={user_id}&game_id={game_id}&language={language}&period={period}&sort={sort}&type={type}&after={after}&before={before}&first={first}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<VideoList> getVideos(@Param(value="token") String var1, @Param(value="id") String var2, @Param(value="user_id") String var3, @Param(value="game_id") String var4, @Param(value="language") String var5, @Param(value="period") String var6, @Param(value="sort") String var7, @Param(value="type") String var8, @Param(value="after") String var9, @Param(value="before") String var10, @Param(value="first") Integer var11);

    @RequestLine(value="GET /webhooks/subscriptions?after={after}&first={first}")
    @Headers(value={"Authorization: Bearer {token}"})
    public HystrixCommand<WebhookSubscriptionList> getWebhookSubscriptions(@Param(value="token") String var1, @Param(value="after") String var2, @Param(value="first") Integer var3);

    @RequestLine(value="POST /webhooks/hub")
    @Headers(value={"Authorization: Bearer {token}", "content-type: application/json"})
    public HystrixCommand<Response> requestWebhookSubscription(WebhookRequest var1, @Param(value="token") String var2);
}

