/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.github.twitch4j.graphql.internal.type.CustomType;
import com.github.twitch4j.graphql.internal.type.PollStatus;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchPollQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "df9b86ea8daa191b393a5396a8c085d0a190c1be8a0ff273fcf054cd1de595ad";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query fetchPoll($id: ID!) {\n  poll(id: $id) {\n    __typename\n    id\n    status\n    title\n    ownedBy {\n      __typename\n      id\n      login\n      displayName\n    }\n    durationSeconds\n    endedAt\n    startedAt\n    totalVoters\n    choices {\n      __typename\n      id\n      title\n      votes {\n        __typename\n        id\n        base\n        bits\n        total\n      }\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "fetchPoll";
        }
    };
    private final Variables variables;

    public FetchPollQuery(@NotNull String id) {
        Utils.checkNotNull((Object)id, (Object)"id == null");
        this.variables = new Variables(id);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse((BufferedSource)new Buffer().write(byteString), scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)autoPersistQueries, (boolean)withQueryDocument, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String id;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String id) {
            this.id = id;
            this.valueMap.put("id", id);
        }

        @NotNull
        public String id() {
            return this.id;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeCustom("id", (ScalarType)CustomType.ID, (Object)id);
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"poll", (String)"poll", (Map)new UnmodifiableMapBuilder(1).put((Object)"id", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"id").build()).build(), (boolean)true, Collections.emptyList())};
        @Nullable
        final Poll poll;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable Poll poll) {
            this.poll = poll;
        }

        @Nullable
        public Poll poll() {
            return this.poll;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], poll != null ? poll.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{poll=" + this.poll + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.poll == null ? that.poll == null : this.poll.equals(that.poll);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.poll == null ? 0 : this.poll.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final Poll.Mapper pollFieldMapper = new Poll.Mapper();

            public Data map(ResponseReader reader) {
                Poll poll = (Poll)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Poll>(){

                    public Poll read(ResponseReader reader) {
                        return pollFieldMapper.map(reader);
                    }
                });
                return new Data(poll);
            }
        }
    }

    public static final class Builder {
        @NotNull
        private String id;

        Builder() {
        }

        public Builder id(@NotNull String id) {
            this.id = id;
            return this;
        }

        public FetchPollQuery build() {
            Utils.checkNotNull((Object)this.id, (Object)"id == null");
            return new FetchPollQuery(this.id);
        }
    }

    public static class Votes {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forInt((String)"base", (String)"base", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"bits", (String)"bits", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"total", (String)"total", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        final int base;
        final int bits;
        final int total;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Votes(@NotNull String __typename, @NotNull String id, int base, int bits, int total) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.base = base;
            this.bits = bits;
            this.total = total;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        public int base() {
            return this.base;
        }

        public int bits() {
            return this.bits;
        }

        public int total() {
            return this.total;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeInt($responseFields[2], Integer.valueOf(base));
                    writer.writeInt($responseFields[3], Integer.valueOf(bits));
                    writer.writeInt($responseFields[4], Integer.valueOf(total));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Votes{__typename=" + this.__typename + ", id=" + this.id + ", base=" + this.base + ", bits=" + this.bits + ", total=" + this.total + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Votes) {
                Votes that = (Votes)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.base == that.base && this.bits == that.bits && this.total == that.total;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.base;
                h *= 1000003;
                h ^= this.bits;
                h *= 1000003;
                this.$hashCode = h ^= this.total;
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Votes> {
            public Votes map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                int base = reader.readInt($responseFields[2]);
                int bits = reader.readInt($responseFields[3]);
                int total = reader.readInt($responseFields[4]);
                return new Votes(__typename, id, base, bits, total);
            }
        }
    }

    public static class Choice {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"title", (String)"title", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"votes", (String)"votes", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String title;
        @NotNull
        final Votes votes;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Choice(@NotNull String __typename, @NotNull String id, @NotNull String title, @NotNull Votes votes) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.title = (String)Utils.checkNotNull((Object)title, (Object)"title == null");
            this.votes = (Votes)Utils.checkNotNull((Object)votes, (Object)"votes == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String title() {
            return this.title;
        }

        @NotNull
        public Votes votes() {
            return this.votes;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], title);
                    writer.writeObject($responseFields[3], votes.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Choice{__typename=" + this.__typename + ", id=" + this.id + ", title=" + this.title + ", votes=" + this.votes + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Choice) {
                Choice that = (Choice)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.title.equals(that.title) && this.votes.equals(that.votes);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.title.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.votes.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Choice> {
            final Votes.Mapper votesFieldMapper = new Votes.Mapper();

            public Choice map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String title = reader.readString($responseFields[2]);
                Votes votes = (Votes)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Votes>(){

                    public Votes read(ResponseReader reader) {
                        return votesFieldMapper.map(reader);
                    }
                });
                return new Choice(__typename, id, title, votes);
            }
        }
    }

    public static class OwnedBy {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public OwnedBy(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "OwnedBy{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof OwnedBy) {
                OwnedBy that = (OwnedBy)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.displayName.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<OwnedBy> {
            public OwnedBy map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                return new OwnedBy(__typename, id, login, displayName);
            }
        }
    }

    public static class Poll {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"status", (String)"status", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"title", (String)"title", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"ownedBy", (String)"ownedBy", null, (boolean)true, Collections.emptyList()), ResponseField.forInt((String)"durationSeconds", (String)"durationSeconds", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"endedAt", (String)"endedAt", null, (boolean)true, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forCustomType((String)"startedAt", (String)"startedAt", null, (boolean)false, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forInt((String)"totalVoters", (String)"totalVoters", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"choices", (String)"choices", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final PollStatus status;
        @NotNull
        final String title;
        @Nullable
        final OwnedBy ownedBy;
        final int durationSeconds;
        @Nullable
        final Object endedAt;
        @NotNull
        final Object startedAt;
        final int totalVoters;
        @NotNull
        final List<Choice> choices;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Poll(@NotNull String __typename, @NotNull String id, @NotNull PollStatus status, @NotNull String title, @Nullable OwnedBy ownedBy, int durationSeconds, @Nullable Object endedAt, @NotNull Object startedAt, int totalVoters, @NotNull List<Choice> choices) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.status = (PollStatus)((Object)Utils.checkNotNull((Object)((Object)status), (Object)"status == null"));
            this.title = (String)Utils.checkNotNull((Object)title, (Object)"title == null");
            this.ownedBy = ownedBy;
            this.durationSeconds = durationSeconds;
            this.endedAt = endedAt;
            this.startedAt = Utils.checkNotNull((Object)startedAt, (Object)"startedAt == null");
            this.totalVoters = totalVoters;
            this.choices = (List)Utils.checkNotNull(choices, (Object)"choices == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public PollStatus status() {
            return this.status;
        }

        @NotNull
        public String title() {
            return this.title;
        }

        @Nullable
        public OwnedBy ownedBy() {
            return this.ownedBy;
        }

        public int durationSeconds() {
            return this.durationSeconds;
        }

        @Nullable
        public Object endedAt() {
            return this.endedAt;
        }

        @NotNull
        public Object startedAt() {
            return this.startedAt;
        }

        public int totalVoters() {
            return this.totalVoters;
        }

        @NotNull
        public List<Choice> choices() {
            return this.choices;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], status.rawValue());
                    writer.writeString($responseFields[3], title);
                    writer.writeObject($responseFields[4], ownedBy != null ? ownedBy.marshaller() : null);
                    writer.writeInt($responseFields[5], Integer.valueOf(durationSeconds));
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[6], endedAt);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[7], startedAt);
                    writer.writeInt($responseFields[8], Integer.valueOf(totalVoters));
                    writer.writeList($responseFields[9], choices, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Choice)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Poll{__typename=" + this.__typename + ", id=" + this.id + ", status=" + (Object)((Object)this.status) + ", title=" + this.title + ", ownedBy=" + this.ownedBy + ", durationSeconds=" + this.durationSeconds + ", endedAt=" + this.endedAt + ", startedAt=" + this.startedAt + ", totalVoters=" + this.totalVoters + ", choices=" + this.choices + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Poll) {
                Poll that = (Poll)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.status.equals((Object)that.status) && this.title.equals(that.title) && (this.ownedBy == null ? that.ownedBy == null : this.ownedBy.equals(that.ownedBy)) && this.durationSeconds == that.durationSeconds && (this.endedAt == null ? that.endedAt == null : this.endedAt.equals(that.endedAt)) && this.startedAt.equals(that.startedAt) && this.totalVoters == that.totalVoters && this.choices.equals(that.choices);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.status.hashCode();
                h *= 1000003;
                h ^= this.title.hashCode();
                h *= 1000003;
                h ^= this.ownedBy == null ? 0 : this.ownedBy.hashCode();
                h *= 1000003;
                h ^= this.durationSeconds;
                h *= 1000003;
                h ^= this.endedAt == null ? 0 : this.endedAt.hashCode();
                h *= 1000003;
                h ^= this.startedAt.hashCode();
                h *= 1000003;
                h ^= this.totalVoters;
                h *= 1000003;
                this.$hashCode = h ^= this.choices.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Poll> {
            final OwnedBy.Mapper ownedByFieldMapper = new OwnedBy.Mapper();
            final Choice.Mapper choiceFieldMapper = new Choice.Mapper();

            public Poll map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String statusStr = reader.readString($responseFields[2]);
                PollStatus status = statusStr != null ? PollStatus.safeValueOf(statusStr) : null;
                String title = reader.readString($responseFields[3]);
                OwnedBy ownedBy = (OwnedBy)reader.readObject($responseFields[4], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<OwnedBy>(){

                    public OwnedBy read(ResponseReader reader) {
                        return ownedByFieldMapper.map(reader);
                    }
                });
                int durationSeconds = reader.readInt($responseFields[5]);
                Object endedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[6]);
                Object startedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[7]);
                int totalVoters = reader.readInt($responseFields[8]);
                List choices = reader.readList($responseFields[9], (ResponseReader.ListReader)new ResponseReader.ListReader<Choice>(){

                    public Choice read(ResponseReader.ListItemReader listItemReader) {
                        return (Choice)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Choice>(){

                            public Choice read(ResponseReader reader) {
                                return choiceFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new Poll(__typename, id, status, title, ownedBy, durationSeconds, endedAt, startedAt, totalVoters, choices);
            }
        }
    }
}

