/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.internal;

import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.InputFieldMarshaller;
import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.api.internal.OperationRequestBodyComposer;
import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.ResponseFieldMarshaller;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.api.internal.SimpleOperationResponseParser;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.github.twitch4j.graphql.internal.type.AutoModCaughtMessageCategory;
import com.github.twitch4j.graphql.internal.type.AutoModCaughtMessageStatus;
import com.github.twitch4j.graphql.internal.type.CustomType;
import com.github.twitch4j.graphql.internal.type.ModLogsAction;
import com.github.twitch4j.graphql.internal.type.SortOrder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FetchChatHistoryQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "8940ea9b03c4ac8ca04702f5d440eacd470509b2d26dfca8f50ff42aba9398ff";
    public static final String QUERY_DOCUMENT = QueryDocumentMinifier.minify((String)"query fetchChatHistory($channelID: ID!, $userID: ID!, $after: Cursor, $first: Int = 100, $order: SortOrder = DESC, $includeMessageCount: Boolean = true, $includeTargetedActions: Boolean = true, $includeAutoModCaughtMessages: Boolean = true) {\n  user(id: $channelID) {\n    __typename\n    modLogs {\n      __typename\n      messagesBySender(senderID: $userID, first: $first, after: $after, order: $order, includeMessageCount: $includeMessageCount, includeTargetedActions: $includeTargetedActions, includeAutoModCaughtMessages: $includeAutoModCaughtMessages) {\n        __typename\n        edges {\n          __typename\n          cursor\n          node {\n            __typename\n            ... on AutoModCaughtMessage {\n              category\n              id\n              modLogsMessage {\n                __typename\n                content {\n                  __typename\n                  fragments {\n                    __typename\n                    content {\n                      __typename\n                      ... on AutoMod {\n                        topics {\n                          __typename\n                          type\n                          weight\n                        }\n                      }\n                    }\n                    text\n                  }\n                  text\n                }\n                id\n                sender {\n                  __typename\n                  id\n                  login\n                  displayName\n                }\n                sentAt\n              }\n              resolvedAt\n              resolver {\n                __typename\n                id\n                login\n                displayName\n              }\n              status\n            }\n            ... on ModLogsMessage {\n              content {\n                __typename\n                fragments {\n                  __typename\n                  content {\n                    __typename\n                    ... on AutoMod {\n                      topics {\n                        __typename\n                        type\n                        weight\n                      }\n                    }\n                  }\n                  text\n                }\n                text\n              }\n              id\n              sender {\n                __typename\n                id\n                login\n                displayName\n              }\n              sentAt\n            }\n            ... on ModLogsTargetedModActionsEntry {\n              action\n              channel {\n                __typename\n                id\n                login\n                displayName\n              }\n              details {\n                __typename\n                bannedAt\n                durationSeconds\n                expiresAt\n                reason\n              }\n              id\n              target {\n                __typename\n                id\n                login\n                displayName\n              }\n              timestamp\n              user {\n                __typename\n                id\n                login\n                displayName\n              }\n            }\n          }\n        }\n        messageCount\n        pageInfo {\n          __typename\n          hasNextPage\n        }\n      }\n    }\n  }\n}");
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "fetchChatHistory";
        }
    };
    private final Variables variables;

    public FetchChatHistoryQuery(@NotNull String channelID, @NotNull String userID, @NotNull Input<Object> after, @NotNull Input<Integer> first, @NotNull Input<SortOrder> order, @NotNull Input<Boolean> includeMessageCount, @NotNull Input<Boolean> includeTargetedActions, @NotNull Input<Boolean> includeAutoModCaughtMessages) {
        Utils.checkNotNull((Object)channelID, (Object)"channelID == null");
        Utils.checkNotNull((Object)userID, (Object)"userID == null");
        Utils.checkNotNull(after, (Object)"after == null");
        Utils.checkNotNull(first, (Object)"first == null");
        Utils.checkNotNull(order, (Object)"order == null");
        Utils.checkNotNull(includeMessageCount, (Object)"includeMessageCount == null");
        Utils.checkNotNull(includeTargetedActions, (Object)"includeTargetedActions == null");
        Utils.checkNotNull(includeAutoModCaughtMessages, (Object)"includeAutoModCaughtMessages == null");
        this.variables = new Variables(channelID, userID, after, first, order, includeMessageCount, includeTargetedActions, includeAutoModCaughtMessages);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return SimpleOperationResponseParser.parse((BufferedSource)source, (Operation)this, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString, @NotNull ScalarTypeAdapters scalarTypeAdapters) throws IOException {
        return this.parse((BufferedSource)new Buffer().write(byteString), scalarTypeAdapters);
    }

    @NotNull
    public Response<Data> parse(@NotNull BufferedSource source) throws IOException {
        return this.parse(source, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public Response<Data> parse(@NotNull ByteString byteString) throws IOException {
        return this.parse(byteString, ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(@NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    @NotNull
    public ByteString composeRequestBody() {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)false, (boolean)true, (ScalarTypeAdapters)ScalarTypeAdapters.DEFAULT);
    }

    @NotNull
    public ByteString composeRequestBody(boolean autoPersistQueries, boolean withQueryDocument, @NotNull ScalarTypeAdapters scalarTypeAdapters) {
        return OperationRequestBodyComposer.compose((Operation)this, (boolean)autoPersistQueries, (boolean)withQueryDocument, (ScalarTypeAdapters)scalarTypeAdapters);
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String channelID;
        @NotNull
        private final String userID;
        private final Input<Object> after;
        private final Input<Integer> first;
        private final Input<SortOrder> order;
        private final Input<Boolean> includeMessageCount;
        private final Input<Boolean> includeTargetedActions;
        private final Input<Boolean> includeAutoModCaughtMessages;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String channelID, @NotNull String userID, Input<Object> after, Input<Integer> first, Input<SortOrder> order, Input<Boolean> includeMessageCount, Input<Boolean> includeTargetedActions, Input<Boolean> includeAutoModCaughtMessages) {
            this.channelID = channelID;
            this.userID = userID;
            this.after = after;
            this.first = first;
            this.order = order;
            this.includeMessageCount = includeMessageCount;
            this.includeTargetedActions = includeTargetedActions;
            this.includeAutoModCaughtMessages = includeAutoModCaughtMessages;
            this.valueMap.put("channelID", channelID);
            this.valueMap.put("userID", userID);
            if (after.defined) {
                this.valueMap.put("after", after.value);
            }
            if (first.defined) {
                this.valueMap.put("first", first.value);
            }
            if (order.defined) {
                this.valueMap.put("order", order.value);
            }
            if (includeMessageCount.defined) {
                this.valueMap.put("includeMessageCount", includeMessageCount.value);
            }
            if (includeTargetedActions.defined) {
                this.valueMap.put("includeTargetedActions", includeTargetedActions.value);
            }
            if (includeAutoModCaughtMessages.defined) {
                this.valueMap.put("includeAutoModCaughtMessages", includeAutoModCaughtMessages.value);
            }
        }

        @NotNull
        public String channelID() {
            return this.channelID;
        }

        @NotNull
        public String userID() {
            return this.userID;
        }

        public Input<Object> after() {
            return this.after;
        }

        public Input<Integer> first() {
            return this.first;
        }

        public Input<SortOrder> order() {
            return this.order;
        }

        public Input<Boolean> includeMessageCount() {
            return this.includeMessageCount;
        }

        public Input<Boolean> includeTargetedActions() {
            return this.includeTargetedActions;
        }

        public Input<Boolean> includeAutoModCaughtMessages() {
            return this.includeAutoModCaughtMessages;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeCustom("channelID", (ScalarType)CustomType.ID, (Object)channelID);
                    writer.writeCustom("userID", (ScalarType)CustomType.ID, (Object)userID);
                    if (((Variables)this).after.defined) {
                        writer.writeCustom("after", (ScalarType)CustomType.CURSOR, ((Variables)this).after.value != null ? ((Variables)this).after.value : null);
                    }
                    if (((Variables)this).first.defined) {
                        writer.writeInt("first", (Integer)((Variables)this).first.value);
                    }
                    if (((Variables)this).order.defined) {
                        writer.writeString("order", ((Variables)this).order.value != null ? ((SortOrder)((Object)((Variables)this).order.value)).rawValue() : null);
                    }
                    if (((Variables)this).includeMessageCount.defined) {
                        writer.writeBoolean("includeMessageCount", (Boolean)((Variables)this).includeMessageCount.value);
                    }
                    if (((Variables)this).includeTargetedActions.defined) {
                        writer.writeBoolean("includeTargetedActions", (Boolean)((Variables)this).includeTargetedActions.value);
                    }
                    if (((Variables)this).includeAutoModCaughtMessages.defined) {
                        writer.writeBoolean("includeAutoModCaughtMessages", (Boolean)((Variables)this).includeAutoModCaughtMessages.value);
                    }
                }
            };
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"user", (String)"user", (Map)new UnmodifiableMapBuilder(1).put((Object)"id", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"channelID").build()).build(), (boolean)true, Collections.emptyList())};
        @Nullable
        final User user;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@Nullable User user) {
            this.user = user;
        }

        @Nullable
        public User user() {
            return this.user;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], user != null ? user.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{user=" + this.user + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.user == null ? that.user == null : this.user.equals(that.user);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.user == null ? 0 : this.user.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final User.Mapper userFieldMapper = new User.Mapper();

            public Data map(ResponseReader reader) {
                User user = (User)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<User>(){

                    public User read(ResponseReader reader) {
                        return userFieldMapper.map(reader);
                    }
                });
                return new Data(user);
            }
        }
    }

    public static final class Builder {
        @NotNull
        private String channelID;
        @NotNull
        private String userID;
        private Input<Object> after = Input.absent();
        private Input<Integer> first = Input.absent();
        private Input<SortOrder> order = Input.absent();
        private Input<Boolean> includeMessageCount = Input.absent();
        private Input<Boolean> includeTargetedActions = Input.absent();
        private Input<Boolean> includeAutoModCaughtMessages = Input.absent();

        Builder() {
        }

        public Builder channelID(@NotNull String channelID) {
            this.channelID = channelID;
            return this;
        }

        public Builder userID(@NotNull String userID) {
            this.userID = userID;
            return this;
        }

        public Builder after(@Nullable Object after) {
            this.after = Input.fromNullable((Object)after);
            return this;
        }

        public Builder first(@Nullable Integer first) {
            this.first = Input.fromNullable((Object)first);
            return this;
        }

        public Builder order(@Nullable SortOrder order) {
            this.order = Input.fromNullable((Object)((Object)order));
            return this;
        }

        public Builder includeMessageCount(@Nullable Boolean includeMessageCount) {
            this.includeMessageCount = Input.fromNullable((Object)includeMessageCount);
            return this;
        }

        public Builder includeTargetedActions(@Nullable Boolean includeTargetedActions) {
            this.includeTargetedActions = Input.fromNullable((Object)includeTargetedActions);
            return this;
        }

        public Builder includeAutoModCaughtMessages(@Nullable Boolean includeAutoModCaughtMessages) {
            this.includeAutoModCaughtMessages = Input.fromNullable((Object)includeAutoModCaughtMessages);
            return this;
        }

        public Builder afterInput(@NotNull Input<Object> after) {
            this.after = (Input)Utils.checkNotNull(after, (Object)"after == null");
            return this;
        }

        public Builder firstInput(@NotNull Input<Integer> first) {
            this.first = (Input)Utils.checkNotNull(first, (Object)"first == null");
            return this;
        }

        public Builder orderInput(@NotNull Input<SortOrder> order) {
            this.order = (Input)Utils.checkNotNull(order, (Object)"order == null");
            return this;
        }

        public Builder includeMessageCountInput(@NotNull Input<Boolean> includeMessageCount) {
            this.includeMessageCount = (Input)Utils.checkNotNull(includeMessageCount, (Object)"includeMessageCount == null");
            return this;
        }

        public Builder includeTargetedActionsInput(@NotNull Input<Boolean> includeTargetedActions) {
            this.includeTargetedActions = (Input)Utils.checkNotNull(includeTargetedActions, (Object)"includeTargetedActions == null");
            return this;
        }

        public Builder includeAutoModCaughtMessagesInput(@NotNull Input<Boolean> includeAutoModCaughtMessages) {
            this.includeAutoModCaughtMessages = (Input)Utils.checkNotNull(includeAutoModCaughtMessages, (Object)"includeAutoModCaughtMessages == null");
            return this;
        }

        public FetchChatHistoryQuery build() {
            Utils.checkNotNull((Object)this.channelID, (Object)"channelID == null");
            Utils.checkNotNull((Object)this.userID, (Object)"userID == null");
            return new FetchChatHistoryQuery(this.channelID, this.userID, this.after, this.first, this.order, this.includeMessageCount, this.includeTargetedActions, this.includeAutoModCaughtMessages);
        }
    }

    public static class PageInfo {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forBoolean((String)"hasNextPage", (String)"hasNextPage", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        final boolean hasNextPage;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public PageInfo(@NotNull String __typename, boolean hasNextPage) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.hasNextPage = hasNextPage;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        public boolean hasNextPage() {
            return this.hasNextPage;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeBoolean($responseFields[1], Boolean.valueOf(hasNextPage));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "PageInfo{__typename=" + this.__typename + ", hasNextPage=" + this.hasNextPage + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PageInfo) {
                PageInfo that = (PageInfo)o;
                return this.__typename.equals(that.__typename) && this.hasNextPage == that.hasNextPage;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= Boolean.valueOf(this.hasNextPage).hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<PageInfo> {
            public PageInfo map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                boolean hasNextPage = reader.readBoolean($responseFields[1]);
                return new PageInfo(__typename, hasNextPage);
            }
        }
    }

    public static class AsModLogsMessageResult
    implements Node {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsModLogsMessageResult(@NotNull String __typename) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsModLogsMessageResult{__typename=" + this.__typename + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsModLogsMessageResult) {
                AsModLogsMessageResult that = (AsModLogsMessageResult)o;
                return this.__typename.equals(that.__typename);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.__typename.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsModLogsMessageResult> {
            public AsModLogsMessageResult map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                return new AsModLogsMessageResult(__typename);
            }
        }
    }

    public static class User1 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public User1(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "User1{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof User1) {
                User1 that = (User1)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.displayName.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<User1> {
            public User1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                return new User1(__typename, id, login, displayName);
            }
        }
    }

    public static class Target {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Target(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Target{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Target) {
                Target that = (Target)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.displayName.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Target> {
            public Target map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                return new Target(__typename, id, login, displayName);
            }
        }
    }

    public static class Details {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"bannedAt", (String)"bannedAt", null, (boolean)true, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forInt((String)"durationSeconds", (String)"durationSeconds", null, (boolean)true, Collections.emptyList()), ResponseField.forCustomType((String)"expiresAt", (String)"expiresAt", null, (boolean)true, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forString((String)"reason", (String)"reason", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final Object bannedAt;
        @Nullable
        final Integer durationSeconds;
        @Nullable
        final Object expiresAt;
        @Nullable
        final String reason;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Details(@NotNull String __typename, @Nullable Object bannedAt, @Nullable Integer durationSeconds, @Nullable Object expiresAt, @Nullable String reason) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.bannedAt = bannedAt;
            this.durationSeconds = durationSeconds;
            this.expiresAt = expiresAt;
            this.reason = reason;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public Object bannedAt() {
            return this.bannedAt;
        }

        @Nullable
        public Integer durationSeconds() {
            return this.durationSeconds;
        }

        @Nullable
        public Object expiresAt() {
            return this.expiresAt;
        }

        @Nullable
        public String reason() {
            return this.reason;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], bannedAt);
                    writer.writeInt($responseFields[2], durationSeconds);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[3], expiresAt);
                    writer.writeString($responseFields[4], reason);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Details{__typename=" + this.__typename + ", bannedAt=" + this.bannedAt + ", durationSeconds=" + this.durationSeconds + ", expiresAt=" + this.expiresAt + ", reason=" + this.reason + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Details) {
                Details that = (Details)o;
                return this.__typename.equals(that.__typename) && (this.bannedAt == null ? that.bannedAt == null : this.bannedAt.equals(that.bannedAt)) && (this.durationSeconds == null ? that.durationSeconds == null : this.durationSeconds.equals(that.durationSeconds)) && (this.expiresAt == null ? that.expiresAt == null : this.expiresAt.equals(that.expiresAt)) && (this.reason == null ? that.reason == null : this.reason.equals(that.reason));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.bannedAt == null ? 0 : this.bannedAt.hashCode();
                h *= 1000003;
                h ^= this.durationSeconds == null ? 0 : this.durationSeconds.hashCode();
                h *= 1000003;
                h ^= this.expiresAt == null ? 0 : this.expiresAt.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.reason == null ? 0 : this.reason.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Details> {
            public Details map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object bannedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                Integer durationSeconds = reader.readInt($responseFields[2]);
                Object expiresAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[3]);
                String reason = reader.readString($responseFields[4]);
                return new Details(__typename, bannedAt, durationSeconds, expiresAt, reason);
            }
        }
    }

    public static class Channel {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Channel(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Channel{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Channel) {
                Channel that = (Channel)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.displayName.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Channel> {
            public Channel map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                return new Channel(__typename, id, login, displayName);
            }
        }
    }

    public static class AsModLogsTargetedModActionsEntry
    implements Node {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"action", (String)"action", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"channel", (String)"channel", null, (boolean)true, Collections.emptyList()), ResponseField.forObject((String)"details", (String)"details", null, (boolean)true, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forObject((String)"target", (String)"target", null, (boolean)true, Collections.emptyList()), ResponseField.forCustomType((String)"timestamp", (String)"timestamp", null, (boolean)false, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forObject((String)"user", (String)"user", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final ModLogsAction action;
        @Nullable
        final Channel channel;
        @Nullable
        final Details details;
        @NotNull
        final String id;
        @Nullable
        final Target target;
        @NotNull
        final Object timestamp;
        @Nullable
        final User1 user;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsModLogsTargetedModActionsEntry(@NotNull String __typename, @NotNull ModLogsAction action, @Nullable Channel channel, @Nullable Details details, @NotNull String id, @Nullable Target target, @NotNull Object timestamp, @Nullable User1 user) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.action = (ModLogsAction)((Object)Utils.checkNotNull((Object)((Object)action), (Object)"action == null"));
            this.channel = channel;
            this.details = details;
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.target = target;
            this.timestamp = Utils.checkNotNull((Object)timestamp, (Object)"timestamp == null");
            this.user = user;
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public ModLogsAction action() {
            return this.action;
        }

        @Nullable
        public Channel channel() {
            return this.channel;
        }

        @Nullable
        public Details details() {
            return this.details;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public Target target() {
            return this.target;
        }

        @NotNull
        public Object timestamp() {
            return this.timestamp;
        }

        @Nullable
        public User1 user() {
            return this.user;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], action.rawValue());
                    writer.writeObject($responseFields[2], channel != null ? channel.marshaller() : null);
                    writer.writeObject($responseFields[3], details != null ? details.marshaller() : null);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[4], (Object)id);
                    writer.writeObject($responseFields[5], target != null ? target.marshaller() : null);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[6], timestamp);
                    writer.writeObject($responseFields[7], user != null ? user.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsModLogsTargetedModActionsEntry{__typename=" + this.__typename + ", action=" + (Object)((Object)this.action) + ", channel=" + this.channel + ", details=" + this.details + ", id=" + this.id + ", target=" + this.target + ", timestamp=" + this.timestamp + ", user=" + this.user + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsModLogsTargetedModActionsEntry) {
                AsModLogsTargetedModActionsEntry that = (AsModLogsTargetedModActionsEntry)o;
                return this.__typename.equals(that.__typename) && this.action.equals((Object)that.action) && (this.channel == null ? that.channel == null : this.channel.equals(that.channel)) && (this.details == null ? that.details == null : this.details.equals(that.details)) && this.id.equals(that.id) && (this.target == null ? that.target == null : this.target.equals(that.target)) && this.timestamp.equals(that.timestamp) && (this.user == null ? that.user == null : this.user.equals(that.user));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.action.hashCode();
                h *= 1000003;
                h ^= this.channel == null ? 0 : this.channel.hashCode();
                h *= 1000003;
                h ^= this.details == null ? 0 : this.details.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.target == null ? 0 : this.target.hashCode();
                h *= 1000003;
                h ^= this.timestamp.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.user == null ? 0 : this.user.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsModLogsTargetedModActionsEntry> {
            final Channel.Mapper channelFieldMapper = new Channel.Mapper();
            final Details.Mapper detailsFieldMapper = new Details.Mapper();
            final Target.Mapper targetFieldMapper = new Target.Mapper();
            final User1.Mapper user1FieldMapper = new User1.Mapper();

            public AsModLogsTargetedModActionsEntry map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String actionStr = reader.readString($responseFields[1]);
                ModLogsAction action = actionStr != null ? ModLogsAction.safeValueOf(actionStr) : null;
                Channel channel = (Channel)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Channel>(){

                    public Channel read(ResponseReader reader) {
                        return channelFieldMapper.map(reader);
                    }
                });
                Details details = (Details)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Details>(){

                    public Details read(ResponseReader reader) {
                        return detailsFieldMapper.map(reader);
                    }
                });
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[4]);
                Target target = (Target)reader.readObject($responseFields[5], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Target>(){

                    public Target read(ResponseReader reader) {
                        return targetFieldMapper.map(reader);
                    }
                });
                Object timestamp = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[6]);
                User1 user = (User1)reader.readObject($responseFields[7], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<User1>(){

                    public User1 read(ResponseReader reader) {
                        return user1FieldMapper.map(reader);
                    }
                });
                return new AsModLogsTargetedModActionsEntry(__typename, action, channel, details, id, target, timestamp, user);
            }
        }
    }

    public static class Sender1 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Sender1(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Sender1{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Sender1) {
                Sender1 that = (Sender1)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.displayName.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Sender1> {
            public Sender1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                return new Sender1(__typename, id, login, displayName);
            }
        }
    }

    public static class AsFragmentContent1
    implements Content3 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsFragmentContent1(@NotNull String __typename) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsFragmentContent1{__typename=" + this.__typename + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsFragmentContent1) {
                AsFragmentContent1 that = (AsFragmentContent1)o;
                return this.__typename.equals(that.__typename);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.__typename.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsFragmentContent1> {
            public AsFragmentContent1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                return new AsFragmentContent1(__typename);
            }
        }
    }

    public static class Topic1 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"type", (String)"type", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"weight", (String)"weight", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String type;
        final int weight;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Topic1(@NotNull String __typename, @NotNull String type, int weight) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.type = (String)Utils.checkNotNull((Object)type, (Object)"type == null");
            this.weight = weight;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String type() {
            return this.type;
        }

        public int weight() {
            return this.weight;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], type);
                    writer.writeInt($responseFields[2], Integer.valueOf(weight));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Topic1{__typename=" + this.__typename + ", type=" + this.type + ", weight=" + this.weight + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Topic1) {
                Topic1 that = (Topic1)o;
                return this.__typename.equals(that.__typename) && this.type.equals(that.type) && this.weight == that.weight;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.type.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.weight;
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Topic1> {
            public Topic1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String type = reader.readString($responseFields[1]);
                int weight = reader.readInt($responseFields[2]);
                return new Topic1(__typename, type, weight);
            }
        }
    }

    public static class AsAutoMod1
    implements Content3 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"topics", (String)"topics", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final List<Topic1> topics;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsAutoMod1(@NotNull String __typename, @NotNull List<Topic1> topics) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.topics = (List)Utils.checkNotNull(topics, (Object)"topics == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public List<Topic1> topics() {
            return this.topics;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], topics, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Topic1)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsAutoMod1{__typename=" + this.__typename + ", topics=" + this.topics + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsAutoMod1) {
                AsAutoMod1 that = (AsAutoMod1)o;
                return this.__typename.equals(that.__typename) && this.topics.equals(that.topics);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.topics.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsAutoMod1> {
            final Topic1.Mapper topic1FieldMapper = new Topic1.Mapper();

            public AsAutoMod1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List topics = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Topic1>(){

                    public Topic1 read(ResponseReader.ListItemReader listItemReader) {
                        return (Topic1)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Topic1>(){

                            public Topic1 read(ResponseReader reader) {
                                return topic1FieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new AsAutoMod1(__typename, topics);
            }
        }
    }

    public static interface Content3 {
        @NotNull
        public String __typename();

        public ResponseFieldMarshaller marshaller();

        public static final class Mapper
        implements ResponseFieldMapper<Content3> {
            static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forFragment((String)"__typename", (String)"__typename", Arrays.asList(ResponseField.Condition.typeCondition((String[])new String[]{"AutoMod"})))};
            final AsAutoMod1.Mapper asAutoMod1FieldMapper = new AsAutoMod1.Mapper();
            final AsFragmentContent1.Mapper asFragmentContent1FieldMapper = new AsFragmentContent1.Mapper();

            public Content3 map(ResponseReader reader) {
                AsAutoMod1 asAutoMod = (AsAutoMod1)reader.readFragment($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AsAutoMod1>(){

                    public AsAutoMod1 read(ResponseReader reader) {
                        return asAutoMod1FieldMapper.map(reader);
                    }
                });
                if (asAutoMod != null) {
                    return asAutoMod;
                }
                return this.asFragmentContent1FieldMapper.map(reader);
            }
        }
    }

    public static class Fragment1 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"content", (String)"content", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"text", (String)"text", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final Content3 content;
        @NotNull
        final String text;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Fragment1(@NotNull String __typename, @Nullable Content3 content, @NotNull String text) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.content = content;
            this.text = (String)Utils.checkNotNull((Object)text, (Object)"text == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public Content3 content() {
            return this.content;
        }

        @NotNull
        public String text() {
            return this.text;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], content != null ? content.marshaller() : null);
                    writer.writeString($responseFields[2], text);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Fragment1{__typename=" + this.__typename + ", content=" + this.content + ", text=" + this.text + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Fragment1) {
                Fragment1 that = (Fragment1)o;
                return this.__typename.equals(that.__typename) && (this.content == null ? that.content == null : this.content.equals(that.content)) && this.text.equals(that.text);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.content == null ? 0 : this.content.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.text.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Fragment1> {
            final Content3.Mapper content3FieldMapper = new Content3.Mapper();

            public Fragment1 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Content3 content = (Content3)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Content3>(){

                    public Content3 read(ResponseReader reader) {
                        return content3FieldMapper.map(reader);
                    }
                });
                String text = reader.readString($responseFields[2]);
                return new Fragment1(__typename, content, text);
            }
        }
    }

    public static class Content2 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"fragments", (String)"fragments", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"text", (String)"text", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final List<Fragment1> fragments;
        @NotNull
        final String text;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Content2(@NotNull String __typename, @NotNull List<Fragment1> fragments, @NotNull String text) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.fragments = (List)Utils.checkNotNull(fragments, (Object)"fragments == null");
            this.text = (String)Utils.checkNotNull((Object)text, (Object)"text == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public List<Fragment1> fragments() {
            return this.fragments;
        }

        @NotNull
        public String text() {
            return this.text;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], fragments, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Fragment1)item).marshaller());
                            }
                        }
                    });
                    writer.writeString($responseFields[2], text);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Content2{__typename=" + this.__typename + ", fragments=" + this.fragments + ", text=" + this.text + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Content2) {
                Content2 that = (Content2)o;
                return this.__typename.equals(that.__typename) && this.fragments.equals(that.fragments) && this.text.equals(that.text);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.fragments.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.text.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Content2> {
            final Fragment1.Mapper fragment1FieldMapper = new Fragment1.Mapper();

            public Content2 map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List fragments = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Fragment1>(){

                    public Fragment1 read(ResponseReader.ListItemReader listItemReader) {
                        return (Fragment1)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Fragment1>(){

                            public Fragment1 read(ResponseReader reader) {
                                return fragment1FieldMapper.map(reader);
                            }
                        });
                    }
                });
                String text = reader.readString($responseFields[2]);
                return new Content2(__typename, fragments, text);
            }
        }
    }

    public static class AsModLogsMessage
    implements Node {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"content", (String)"content", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forObject((String)"sender", (String)"sender", null, (boolean)true, Collections.emptyList()), ResponseField.forCustomType((String)"sentAt", (String)"sentAt", null, (boolean)false, (ScalarType)CustomType.TIME, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Content2 content;
        @NotNull
        final String id;
        @Nullable
        final Sender1 sender;
        @NotNull
        final Object sentAt;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsModLogsMessage(@NotNull String __typename, @NotNull Content2 content, @NotNull String id, @Nullable Sender1 sender, @NotNull Object sentAt) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.content = (Content2)Utils.checkNotNull((Object)content, (Object)"content == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.sender = sender;
            this.sentAt = Utils.checkNotNull((Object)sentAt, (Object)"sentAt == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public Content2 content() {
            return this.content;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public Sender1 sender() {
            return this.sender;
        }

        @NotNull
        public Object sentAt() {
            return this.sentAt;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], content.marshaller());
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[2], (Object)id);
                    writer.writeObject($responseFields[3], sender != null ? sender.marshaller() : null);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[4], sentAt);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsModLogsMessage{__typename=" + this.__typename + ", content=" + this.content + ", id=" + this.id + ", sender=" + this.sender + ", sentAt=" + this.sentAt + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsModLogsMessage) {
                AsModLogsMessage that = (AsModLogsMessage)o;
                return this.__typename.equals(that.__typename) && this.content.equals(that.content) && this.id.equals(that.id) && (this.sender == null ? that.sender == null : this.sender.equals(that.sender)) && this.sentAt.equals(that.sentAt);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.content.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.sender == null ? 0 : this.sender.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.sentAt.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsModLogsMessage> {
            final Content2.Mapper content2FieldMapper = new Content2.Mapper();
            final Sender1.Mapper sender1FieldMapper = new Sender1.Mapper();

            public AsModLogsMessage map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Content2 content = (Content2)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Content2>(){

                    public Content2 read(ResponseReader reader) {
                        return content2FieldMapper.map(reader);
                    }
                });
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[2]);
                Sender1 sender = (Sender1)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Sender1>(){

                    public Sender1 read(ResponseReader reader) {
                        return sender1FieldMapper.map(reader);
                    }
                });
                Object sentAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[4]);
                return new AsModLogsMessage(__typename, content, id, sender, sentAt);
            }
        }
    }

    public static class Resolver {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Resolver(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Resolver{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Resolver) {
                Resolver that = (Resolver)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.displayName.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Resolver> {
            public Resolver map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                return new Resolver(__typename, id, login, displayName);
            }
        }
    }

    public static class Sender {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forString((String)"login", (String)"login", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"displayName", (String)"displayName", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String id;
        @NotNull
        final String login;
        @NotNull
        final String displayName;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Sender(@NotNull String __typename, @NotNull String id, @NotNull String login, @NotNull String displayName) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.login = (String)Utils.checkNotNull((Object)login, (Object)"login == null");
            this.displayName = (String)Utils.checkNotNull((Object)displayName, (Object)"displayName == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public String login() {
            return this.login;
        }

        @NotNull
        public String displayName() {
            return this.displayName;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], (Object)id);
                    writer.writeString($responseFields[2], login);
                    writer.writeString($responseFields[3], displayName);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Sender{__typename=" + this.__typename + ", id=" + this.id + ", login=" + this.login + ", displayName=" + this.displayName + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Sender) {
                Sender that = (Sender)o;
                return this.__typename.equals(that.__typename) && this.id.equals(that.id) && this.login.equals(that.login) && this.displayName.equals(that.displayName);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.login.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.displayName.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Sender> {
            public Sender map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                String login = reader.readString($responseFields[2]);
                String displayName = reader.readString($responseFields[3]);
                return new Sender(__typename, id, login, displayName);
            }
        }
    }

    public static class AsFragmentContent
    implements Content1 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsFragmentContent(@NotNull String __typename) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsFragmentContent{__typename=" + this.__typename + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsFragmentContent) {
                AsFragmentContent that = (AsFragmentContent)o;
                return this.__typename.equals(that.__typename);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.__typename.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsFragmentContent> {
            public AsFragmentContent map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                return new AsFragmentContent(__typename);
            }
        }
    }

    public static class Topic {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"type", (String)"type", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"weight", (String)"weight", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String type;
        final int weight;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Topic(@NotNull String __typename, @NotNull String type, int weight) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.type = (String)Utils.checkNotNull((Object)type, (Object)"type == null");
            this.weight = weight;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String type() {
            return this.type;
        }

        public int weight() {
            return this.weight;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], type);
                    writer.writeInt($responseFields[2], Integer.valueOf(weight));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Topic{__typename=" + this.__typename + ", type=" + this.type + ", weight=" + this.weight + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Topic) {
                Topic that = (Topic)o;
                return this.__typename.equals(that.__typename) && this.type.equals(that.type) && this.weight == that.weight;
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.type.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.weight;
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Topic> {
            public Topic map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String type = reader.readString($responseFields[1]);
                int weight = reader.readInt($responseFields[2]);
                return new Topic(__typename, type, weight);
            }
        }
    }

    public static class AsAutoMod
    implements Content1 {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"topics", (String)"topics", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final List<Topic> topics;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsAutoMod(@NotNull String __typename, @NotNull List<Topic> topics) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.topics = (List)Utils.checkNotNull(topics, (Object)"topics == null");
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public List<Topic> topics() {
            return this.topics;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], topics, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Topic)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsAutoMod{__typename=" + this.__typename + ", topics=" + this.topics + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsAutoMod) {
                AsAutoMod that = (AsAutoMod)o;
                return this.__typename.equals(that.__typename) && this.topics.equals(that.topics);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.topics.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsAutoMod> {
            final Topic.Mapper topicFieldMapper = new Topic.Mapper();

            public AsAutoMod map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List topics = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Topic>(){

                    public Topic read(ResponseReader.ListItemReader listItemReader) {
                        return (Topic)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Topic>(){

                            public Topic read(ResponseReader reader) {
                                return topicFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new AsAutoMod(__typename, topics);
            }
        }
    }

    public static interface Content1 {
        @NotNull
        public String __typename();

        public ResponseFieldMarshaller marshaller();

        public static final class Mapper
        implements ResponseFieldMapper<Content1> {
            static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forFragment((String)"__typename", (String)"__typename", Arrays.asList(ResponseField.Condition.typeCondition((String[])new String[]{"AutoMod"})))};
            final AsAutoMod.Mapper asAutoModFieldMapper = new AsAutoMod.Mapper();
            final AsFragmentContent.Mapper asFragmentContentFieldMapper = new AsFragmentContent.Mapper();

            public Content1 map(ResponseReader reader) {
                AsAutoMod asAutoMod = (AsAutoMod)reader.readFragment($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AsAutoMod>(){

                    public AsAutoMod read(ResponseReader reader) {
                        return asAutoModFieldMapper.map(reader);
                    }
                });
                if (asAutoMod != null) {
                    return asAutoMod;
                }
                return this.asFragmentContentFieldMapper.map(reader);
            }
        }
    }

    public static class Fragment {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"content", (String)"content", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"text", (String)"text", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final Content1 content;
        @NotNull
        final String text;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Fragment(@NotNull String __typename, @Nullable Content1 content, @NotNull String text) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.content = content;
            this.text = (String)Utils.checkNotNull((Object)text, (Object)"text == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public Content1 content() {
            return this.content;
        }

        @NotNull
        public String text() {
            return this.text;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], content != null ? content.marshaller() : null);
                    writer.writeString($responseFields[2], text);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Fragment{__typename=" + this.__typename + ", content=" + this.content + ", text=" + this.text + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Fragment) {
                Fragment that = (Fragment)o;
                return this.__typename.equals(that.__typename) && (this.content == null ? that.content == null : this.content.equals(that.content)) && this.text.equals(that.text);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.content == null ? 0 : this.content.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.text.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Fragment> {
            final Content1.Mapper content1FieldMapper = new Content1.Mapper();

            public Fragment map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Content1 content = (Content1)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Content1>(){

                    public Content1 read(ResponseReader reader) {
                        return content1FieldMapper.map(reader);
                    }
                });
                String text = reader.readString($responseFields[2]);
                return new Fragment(__typename, content, text);
            }
        }
    }

    public static class Content {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"fragments", (String)"fragments", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"text", (String)"text", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final List<Fragment> fragments;
        @NotNull
        final String text;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Content(@NotNull String __typename, @NotNull List<Fragment> fragments, @NotNull String text) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.fragments = (List)Utils.checkNotNull(fragments, (Object)"fragments == null");
            this.text = (String)Utils.checkNotNull((Object)text, (Object)"text == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public List<Fragment> fragments() {
            return this.fragments;
        }

        @NotNull
        public String text() {
            return this.text;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], fragments, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Fragment)item).marshaller());
                            }
                        }
                    });
                    writer.writeString($responseFields[2], text);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Content{__typename=" + this.__typename + ", fragments=" + this.fragments + ", text=" + this.text + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Content) {
                Content that = (Content)o;
                return this.__typename.equals(that.__typename) && this.fragments.equals(that.fragments) && this.text.equals(that.text);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.fragments.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.text.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Content> {
            final Fragment.Mapper fragmentFieldMapper = new Fragment.Mapper();

            public Content map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List fragments = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Fragment>(){

                    public Fragment read(ResponseReader.ListItemReader listItemReader) {
                        return (Fragment)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Fragment>(){

                            public Fragment read(ResponseReader reader) {
                                return fragmentFieldMapper.map(reader);
                            }
                        });
                    }
                });
                String text = reader.readString($responseFields[2]);
                return new Content(__typename, fragments, text);
            }
        }
    }

    public static class ModLogsMessage {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"content", (String)"content", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forObject((String)"sender", (String)"sender", null, (boolean)true, Collections.emptyList()), ResponseField.forCustomType((String)"sentAt", (String)"sentAt", null, (boolean)false, (ScalarType)CustomType.TIME, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Content content;
        @NotNull
        final String id;
        @Nullable
        final Sender sender;
        @NotNull
        final Object sentAt;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public ModLogsMessage(@NotNull String __typename, @NotNull Content content, @NotNull String id, @Nullable Sender sender, @NotNull Object sentAt) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.content = (Content)Utils.checkNotNull((Object)content, (Object)"content == null");
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.sender = sender;
            this.sentAt = Utils.checkNotNull((Object)sentAt, (Object)"sentAt == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public Content content() {
            return this.content;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public Sender sender() {
            return this.sender;
        }

        @NotNull
        public Object sentAt() {
            return this.sentAt;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], content.marshaller());
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[2], (Object)id);
                    writer.writeObject($responseFields[3], sender != null ? sender.marshaller() : null);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[4], sentAt);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "ModLogsMessage{__typename=" + this.__typename + ", content=" + this.content + ", id=" + this.id + ", sender=" + this.sender + ", sentAt=" + this.sentAt + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ModLogsMessage) {
                ModLogsMessage that = (ModLogsMessage)o;
                return this.__typename.equals(that.__typename) && this.content.equals(that.content) && this.id.equals(that.id) && (this.sender == null ? that.sender == null : this.sender.equals(that.sender)) && this.sentAt.equals(that.sentAt);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.content.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.sender == null ? 0 : this.sender.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.sentAt.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<ModLogsMessage> {
            final Content.Mapper contentFieldMapper = new Content.Mapper();
            final Sender.Mapper senderFieldMapper = new Sender.Mapper();

            public ModLogsMessage map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Content content = (Content)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Content>(){

                    public Content read(ResponseReader reader) {
                        return contentFieldMapper.map(reader);
                    }
                });
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[2]);
                Sender sender = (Sender)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Sender>(){

                    public Sender read(ResponseReader reader) {
                        return senderFieldMapper.map(reader);
                    }
                });
                Object sentAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[4]);
                return new ModLogsMessage(__typename, content, id, sender, sentAt);
            }
        }
    }

    public static class AsAutoModCaughtMessage
    implements Node {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"category", (String)"category", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"id", (String)"id", null, (boolean)false, (ScalarType)CustomType.ID, Collections.emptyList()), ResponseField.forObject((String)"modLogsMessage", (String)"modLogsMessage", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"resolvedAt", (String)"resolvedAt", null, (boolean)true, (ScalarType)CustomType.TIME, Collections.emptyList()), ResponseField.forObject((String)"resolver", (String)"resolver", null, (boolean)true, Collections.emptyList()), ResponseField.forString((String)"status", (String)"status", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final AutoModCaughtMessageCategory category;
        @NotNull
        final String id;
        @NotNull
        final ModLogsMessage modLogsMessage;
        @Nullable
        final Object resolvedAt;
        @Nullable
        final Resolver resolver;
        @NotNull
        final AutoModCaughtMessageStatus status;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AsAutoModCaughtMessage(@NotNull String __typename, @NotNull AutoModCaughtMessageCategory category, @NotNull String id, @NotNull ModLogsMessage modLogsMessage, @Nullable Object resolvedAt, @Nullable Resolver resolver, @NotNull AutoModCaughtMessageStatus status) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.category = (AutoModCaughtMessageCategory)((Object)Utils.checkNotNull((Object)((Object)category), (Object)"category == null"));
            this.id = (String)Utils.checkNotNull((Object)id, (Object)"id == null");
            this.modLogsMessage = (ModLogsMessage)Utils.checkNotNull((Object)modLogsMessage, (Object)"modLogsMessage == null");
            this.resolvedAt = resolvedAt;
            this.resolver = resolver;
            this.status = (AutoModCaughtMessageStatus)((Object)Utils.checkNotNull((Object)((Object)status), (Object)"status == null"));
        }

        @Override
        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public AutoModCaughtMessageCategory category() {
            return this.category;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @NotNull
        public ModLogsMessage modLogsMessage() {
            return this.modLogsMessage;
        }

        @Nullable
        public Object resolvedAt() {
            return this.resolvedAt;
        }

        @Nullable
        public Resolver resolver() {
            return this.resolver;
        }

        @NotNull
        public AutoModCaughtMessageStatus status() {
            return this.status;
        }

        @Override
        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], category.rawValue());
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[2], (Object)id);
                    writer.writeObject($responseFields[3], modLogsMessage.marshaller());
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[4], resolvedAt);
                    writer.writeObject($responseFields[5], resolver != null ? resolver.marshaller() : null);
                    writer.writeString($responseFields[6], status.rawValue());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AsAutoModCaughtMessage{__typename=" + this.__typename + ", category=" + (Object)((Object)this.category) + ", id=" + this.id + ", modLogsMessage=" + this.modLogsMessage + ", resolvedAt=" + this.resolvedAt + ", resolver=" + this.resolver + ", status=" + (Object)((Object)this.status) + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AsAutoModCaughtMessage) {
                AsAutoModCaughtMessage that = (AsAutoModCaughtMessage)o;
                return this.__typename.equals(that.__typename) && this.category.equals((Object)that.category) && this.id.equals(that.id) && this.modLogsMessage.equals(that.modLogsMessage) && (this.resolvedAt == null ? that.resolvedAt == null : this.resolvedAt.equals(that.resolvedAt)) && (this.resolver == null ? that.resolver == null : this.resolver.equals(that.resolver)) && this.status.equals((Object)that.status);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.category.hashCode();
                h *= 1000003;
                h ^= this.id.hashCode();
                h *= 1000003;
                h ^= this.modLogsMessage.hashCode();
                h *= 1000003;
                h ^= this.resolvedAt == null ? 0 : this.resolvedAt.hashCode();
                h *= 1000003;
                h ^= this.resolver == null ? 0 : this.resolver.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.status.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AsAutoModCaughtMessage> {
            final ModLogsMessage.Mapper modLogsMessageFieldMapper = new ModLogsMessage.Mapper();
            final Resolver.Mapper resolverFieldMapper = new Resolver.Mapper();

            public AsAutoModCaughtMessage map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String categoryStr = reader.readString($responseFields[1]);
                AutoModCaughtMessageCategory category = categoryStr != null ? AutoModCaughtMessageCategory.safeValueOf(categoryStr) : null;
                String id = (String)reader.readCustomType((ResponseField.CustomTypeField)$responseFields[2]);
                ModLogsMessage modLogsMessage = (ModLogsMessage)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<ModLogsMessage>(){

                    public ModLogsMessage read(ResponseReader reader) {
                        return modLogsMessageFieldMapper.map(reader);
                    }
                });
                Object resolvedAt = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[4]);
                Resolver resolver = (Resolver)reader.readObject($responseFields[5], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Resolver>(){

                    public Resolver read(ResponseReader reader) {
                        return resolverFieldMapper.map(reader);
                    }
                });
                String statusStr = reader.readString($responseFields[6]);
                AutoModCaughtMessageStatus status = statusStr != null ? AutoModCaughtMessageStatus.safeValueOf(statusStr) : null;
                return new AsAutoModCaughtMessage(__typename, category, id, modLogsMessage, resolvedAt, resolver, status);
            }
        }
    }

    public static interface Node {
        @NotNull
        public String __typename();

        public ResponseFieldMarshaller marshaller();

        public static final class Mapper
        implements ResponseFieldMapper<Node> {
            static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forFragment((String)"__typename", (String)"__typename", Arrays.asList(ResponseField.Condition.typeCondition((String[])new String[]{"AutoModCaughtMessage"}))), ResponseField.forFragment((String)"__typename", (String)"__typename", Arrays.asList(ResponseField.Condition.typeCondition((String[])new String[]{"ModLogsMessage"}))), ResponseField.forFragment((String)"__typename", (String)"__typename", Arrays.asList(ResponseField.Condition.typeCondition((String[])new String[]{"ModLogsTargetedModActionsEntry"})))};
            final AsAutoModCaughtMessage.Mapper asAutoModCaughtMessageFieldMapper = new AsAutoModCaughtMessage.Mapper();
            final AsModLogsMessage.Mapper asModLogsMessageFieldMapper = new AsModLogsMessage.Mapper();
            final AsModLogsTargetedModActionsEntry.Mapper asModLogsTargetedModActionsEntryFieldMapper = new AsModLogsTargetedModActionsEntry.Mapper();
            final AsModLogsMessageResult.Mapper asModLogsMessageResultFieldMapper = new AsModLogsMessageResult.Mapper();

            public Node map(ResponseReader reader) {
                AsAutoModCaughtMessage asAutoModCaughtMessage = (AsAutoModCaughtMessage)reader.readFragment($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AsAutoModCaughtMessage>(){

                    public AsAutoModCaughtMessage read(ResponseReader reader) {
                        return asAutoModCaughtMessageFieldMapper.map(reader);
                    }
                });
                if (asAutoModCaughtMessage != null) {
                    return asAutoModCaughtMessage;
                }
                AsModLogsMessage asModLogsMessage = (AsModLogsMessage)reader.readFragment($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AsModLogsMessage>(){

                    public AsModLogsMessage read(ResponseReader reader) {
                        return asModLogsMessageFieldMapper.map(reader);
                    }
                });
                if (asModLogsMessage != null) {
                    return asModLogsMessage;
                }
                AsModLogsTargetedModActionsEntry asModLogsTargetedModActionsEntry = (AsModLogsTargetedModActionsEntry)reader.readFragment($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AsModLogsTargetedModActionsEntry>(){

                    public AsModLogsTargetedModActionsEntry read(ResponseReader reader) {
                        return asModLogsTargetedModActionsEntryFieldMapper.map(reader);
                    }
                });
                if (asModLogsTargetedModActionsEntry != null) {
                    return asModLogsTargetedModActionsEntry;
                }
                return this.asModLogsMessageResultFieldMapper.map(reader);
            }
        }
    }

    public static class Edge {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forCustomType((String)"cursor", (String)"cursor", null, (boolean)false, (ScalarType)CustomType.CURSOR, Collections.emptyList()), ResponseField.forObject((String)"node", (String)"node", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final Object cursor;
        @Nullable
        final Node node;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Edge(@NotNull String __typename, @NotNull Object cursor, @Nullable Node node) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.cursor = Utils.checkNotNull((Object)cursor, (Object)"cursor == null");
            this.node = node;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public Object cursor() {
            return this.cursor;
        }

        @Nullable
        public Node node() {
            return this.node;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeCustom((ResponseField.CustomTypeField)$responseFields[1], cursor);
                    writer.writeObject($responseFields[2], node != null ? node.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Edge{__typename=" + this.__typename + ", cursor=" + this.cursor + ", node=" + this.node + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Edge) {
                Edge that = (Edge)o;
                return this.__typename.equals(that.__typename) && this.cursor.equals(that.cursor) && (this.node == null ? that.node == null : this.node.equals(that.node));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.cursor.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.node == null ? 0 : this.node.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Edge> {
            final Node.Mapper nodeFieldMapper = new Node.Mapper();

            public Edge map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                Object cursor = reader.readCustomType((ResponseField.CustomTypeField)$responseFields[1]);
                Node node = (Node)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Node>(){

                    public Node read(ResponseReader reader) {
                        return nodeFieldMapper.map(reader);
                    }
                });
                return new Edge(__typename, cursor, node);
            }
        }
    }

    public static class MessagesBySender {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"edges", (String)"edges", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"messageCount", (String)"messageCount", null, (boolean)true, Collections.emptyList()), ResponseField.forObject((String)"pageInfo", (String)"pageInfo", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final List<Edge> edges;
        @Nullable
        final Integer messageCount;
        @NotNull
        final PageInfo pageInfo;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public MessagesBySender(@NotNull String __typename, @NotNull List<Edge> edges, @Nullable Integer messageCount, @NotNull PageInfo pageInfo) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.edges = (List)Utils.checkNotNull(edges, (Object)"edges == null");
            this.messageCount = messageCount;
            this.pageInfo = (PageInfo)Utils.checkNotNull((Object)pageInfo, (Object)"pageInfo == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public List<Edge> edges() {
            return this.edges;
        }

        @Nullable
        public Integer messageCount() {
            return this.messageCount;
        }

        @NotNull
        public PageInfo pageInfo() {
            return this.pageInfo;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], edges, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Edge)item).marshaller());
                            }
                        }
                    });
                    writer.writeInt($responseFields[2], messageCount);
                    writer.writeObject($responseFields[3], pageInfo.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "MessagesBySender{__typename=" + this.__typename + ", edges=" + this.edges + ", messageCount=" + this.messageCount + ", pageInfo=" + this.pageInfo + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof MessagesBySender) {
                MessagesBySender that = (MessagesBySender)o;
                return this.__typename.equals(that.__typename) && this.edges.equals(that.edges) && (this.messageCount == null ? that.messageCount == null : this.messageCount.equals(that.messageCount)) && this.pageInfo.equals(that.pageInfo);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.edges.hashCode();
                h *= 1000003;
                h ^= this.messageCount == null ? 0 : this.messageCount.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.pageInfo.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<MessagesBySender> {
            final Edge.Mapper edgeFieldMapper = new Edge.Mapper();
            final PageInfo.Mapper pageInfoFieldMapper = new PageInfo.Mapper();

            public MessagesBySender map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List edges = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Edge>(){

                    public Edge read(ResponseReader.ListItemReader listItemReader) {
                        return (Edge)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Edge>(){

                            public Edge read(ResponseReader reader) {
                                return edgeFieldMapper.map(reader);
                            }
                        });
                    }
                });
                Integer messageCount = reader.readInt($responseFields[2]);
                PageInfo pageInfo = (PageInfo)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<PageInfo>(){

                    public PageInfo read(ResponseReader reader) {
                        return pageInfoFieldMapper.map(reader);
                    }
                });
                return new MessagesBySender(__typename, edges, messageCount, pageInfo);
            }
        }
    }

    public static class ModLogs {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"messagesBySender", (String)"messagesBySender", (Map)new UnmodifiableMapBuilder(7).put((Object)"senderID", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"userID").build()).put((Object)"first", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"first").build()).put((Object)"after", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"after").build()).put((Object)"order", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"order").build()).put((Object)"includeMessageCount", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"includeMessageCount").build()).put((Object)"includeTargetedActions", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"includeTargetedActions").build()).put((Object)"includeAutoModCaughtMessages", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"includeAutoModCaughtMessages").build()).build(), (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final MessagesBySender messagesBySender;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public ModLogs(@NotNull String __typename, @Nullable MessagesBySender messagesBySender) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.messagesBySender = messagesBySender;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public MessagesBySender messagesBySender() {
            return this.messagesBySender;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], messagesBySender != null ? messagesBySender.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "ModLogs{__typename=" + this.__typename + ", messagesBySender=" + this.messagesBySender + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ModLogs) {
                ModLogs that = (ModLogs)o;
                return this.__typename.equals(that.__typename) && (this.messagesBySender == null ? that.messagesBySender == null : this.messagesBySender.equals(that.messagesBySender));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.messagesBySender == null ? 0 : this.messagesBySender.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<ModLogs> {
            final MessagesBySender.Mapper messagesBySenderFieldMapper = new MessagesBySender.Mapper();

            public ModLogs map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                MessagesBySender messagesBySender = (MessagesBySender)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<MessagesBySender>(){

                    public MessagesBySender read(ResponseReader reader) {
                        return messagesBySenderFieldMapper.map(reader);
                    }
                });
                return new ModLogs(__typename, messagesBySender);
            }
        }
    }

    public static class User {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"modLogs", (String)"modLogs", null, (boolean)true, Collections.emptyList())};
        @NotNull
        final String __typename;
        @Nullable
        final ModLogs modLogs;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public User(@NotNull String __typename, @Nullable ModLogs modLogs) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.modLogs = modLogs;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @Nullable
        public ModLogs modLogs() {
            return this.modLogs;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], modLogs != null ? modLogs.marshaller() : null);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "User{__typename=" + this.__typename + ", modLogs=" + this.modLogs + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof User) {
                User that = (User)o;
                return this.__typename.equals(that.__typename) && (this.modLogs == null ? that.modLogs == null : this.modLogs.equals(that.modLogs));
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.modLogs == null ? 0 : this.modLogs.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<User> {
            final ModLogs.Mapper modLogsFieldMapper = new ModLogs.Mapper();

            public User map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                ModLogs modLogs = (ModLogs)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<ModLogs>(){

                    public ModLogs read(ResponseReader reader) {
                        return modLogsFieldMapper.map(reader);
                    }
                });
                return new User(__typename, modLogs);
            }
        }
    }
}

