/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql;

import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.graphql.TwitchGraphQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchGraphQLBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitchGraphQLBuilder.class);
    private EventManager eventManager = new EventManager();
    private Class<? extends IEventHandler> defaultEventHandler = SimpleEventHandler.class;
    private ProxyConfig proxyConfig = null;
    private String clientId = "kimne78kx3ncx6brgo4mv6wki5h1ko";
    private String clientSecret = "**SECRET**";
    private String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36";
    private String baseUrl = "https://api.twitch.tv/gql";

    public static TwitchGraphQLBuilder builder() {
        return new TwitchGraphQLBuilder();
    }

    public TwitchGraphQL build() {
        log.debug("GraphQL: Initializing Module ...");
        log.warn("GraphQL: GraphQL is a experimental module, please take care as some features might break unannounced.");
        TwitchGraphQL client = new TwitchGraphQL(this.eventManager, this.clientId, this.clientSecret, this.proxyConfig);
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager((EventManager)this.eventManager, this.defaultEventHandler);
        this.eventManager.getServiceMediator().addService("twitch4j-graphql", (Object)client);
        return client;
    }

    private TwitchGraphQLBuilder() {
    }

    private TwitchGraphQLBuilder(EventManager eventManager, Class<? extends IEventHandler> defaultEventHandler, ProxyConfig proxyConfig, String clientId, String clientSecret, String userAgent, String baseUrl) {
        this.eventManager = eventManager;
        this.defaultEventHandler = defaultEventHandler;
        this.proxyConfig = proxyConfig;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userAgent = userAgent;
        this.baseUrl = baseUrl;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Class<? extends IEventHandler> getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public TwitchGraphQLBuilder withEventManager(EventManager eventManager) {
        return this.eventManager == eventManager ? this : new TwitchGraphQLBuilder(eventManager, this.defaultEventHandler, this.proxyConfig, this.clientId, this.clientSecret, this.userAgent, this.baseUrl);
    }

    public TwitchGraphQLBuilder withDefaultEventHandler(Class<? extends IEventHandler> defaultEventHandler) {
        return this.defaultEventHandler == defaultEventHandler ? this : new TwitchGraphQLBuilder(this.eventManager, defaultEventHandler, this.proxyConfig, this.clientId, this.clientSecret, this.userAgent, this.baseUrl);
    }

    public TwitchGraphQLBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, proxyConfig, this.clientId, this.clientSecret, this.userAgent, this.baseUrl);
    }

    public TwitchGraphQLBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, this.proxyConfig, clientId, this.clientSecret, this.userAgent, this.baseUrl);
    }

    public TwitchGraphQLBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, this.proxyConfig, this.clientId, clientSecret, this.userAgent, this.baseUrl);
    }
}

