/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql;

import com.apollographql.apollo.ApolloClient;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.graphql.command.CommandFollowUser;
import com.github.twitch4j.graphql.command.CommandUnfollowUser;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchGraphQL {
    private static final Logger log = LoggerFactory.getLogger(TwitchGraphQL.class);
    private final EventManager eventManager;
    private String clientId;
    private String clientSecret;
    private final ProxyConfig proxyConfig;

    public TwitchGraphQL(EventManager eventManager, String clientId, String clientSecret, ProxyConfig proxyConfig) {
        this.eventManager = eventManager;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.proxyConfig = proxyConfig;
    }

    private ApolloClient getApolloClient(OAuth2Credential credential) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder requestBuilder = original.newBuilder().header("Client-Id", this.clientId);
            if (credential != null) {
                requestBuilder.header("Authorization", "OAuth " + credential.getAccessToken());
            }
            Request request = requestBuilder.build();
            return chain.proceed(request);
        });
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(clientBuilder);
        }
        return ApolloClient.builder().serverUrl("https://api.twitch.tv/gql").okHttpClient(clientBuilder.build()).build();
    }

    public CommandFollowUser followUser(OAuth2Credential auth, Long targetUserId, Boolean goLiveNotification) {
        return new CommandFollowUser(this.getApolloClient(auth), targetUserId, goLiveNotification);
    }

    public CommandUnfollowUser unfollowUser(OAuth2Credential auth, Long targetUserId) {
        return new CommandUnfollowUser(this.getApolloClient(auth), targetUserId);
    }
}

