/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql.command;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloException;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCommand<T extends Operation.Data>
extends HystrixCommand<T> {
    protected final ApolloClient apolloClient;
    private volatile T resultData;

    public BaseCommand(ApolloClient apolloClient) {
        super(HystrixCommandGroupKey.Factory.asKey((String)"GraphQL"));
        this.apolloClient = apolloClient;
    }

    protected abstract ApolloCall<T> getGraphQLCall();

    protected T run() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.getGraphQLCall().enqueue(new ApolloCall.Callback<T>(){

            public void onResponse(@NotNull Response<T> response) {
                List errors = response.getErrors();
                if (errors != null && errors.size() > 0) {
                    try {
                        throw new RuntimeException("GraphQL API: " + errors);
                    }
                    catch (Throwable throwable) {
                        latch.countDown();
                        throw throwable;
                    }
                }
                BaseCommand.this.resultData = (Operation.Data)response.getData();
                latch.countDown();
            }

            public void onFailure(@NotNull ApolloException e) {
                try {
                    throw new RuntimeException((Throwable)e);
                }
                catch (Throwable throwable) {
                    latch.countDown();
                    throw throwable;
                }
            }
        });
        try {
            latch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.resultData;
    }
}

