/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.graphql;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.graphql.TwitchGraphQL;
import com.netflix.config.ConfigurationManager;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchGraphQLBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitchGraphQLBuilder.class);
    private EventManager eventManager = null;
    private Class<? extends IEventHandler> defaultEventHandler = SimpleEventHandler.class;
    private ProxyConfig proxyConfig = null;
    private String clientId = "kimne78kx3ncx6brgo4mv6wki5h1ko";
    private String clientSecret = "**SECRET**";
    private OAuth2Credential defaultFirstPartyToken = null;
    private boolean enableBatching = false;
    private Integer timeout = 5000;
    private String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36";
    private Map<String, String> headers = new HashMap<String, String>();
    private String baseUrl = "https://gql.twitch.tv/gql";

    public static TwitchGraphQLBuilder builder() {
        return new TwitchGraphQLBuilder();
    }

    public TwitchGraphQL build() {
        log.debug("GraphQL: Initializing Module ...");
        log.warn("GraphQL: GraphQL is a experimental module not intended for third-party use, please take care as some features might break unannounced.");
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds", (Object)this.timeout);
        TwitchGraphQL client = new TwitchGraphQL(this.baseUrl, this.userAgent, this.eventManager, this.clientId, this.defaultFirstPartyToken, this.proxyConfig, this.enableBatching, this.timeout, this.headers);
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager((EventManager)this.eventManager, this.defaultEventHandler);
        this.eventManager.getServiceMediator().addService("twitch4j-graphql", (Object)client);
        return client;
    }

    private TwitchGraphQLBuilder() {
    }

    private TwitchGraphQLBuilder(EventManager eventManager, Class<? extends IEventHandler> defaultEventHandler, ProxyConfig proxyConfig, String clientId, String clientSecret, OAuth2Credential defaultFirstPartyToken, boolean enableBatching, Integer timeout, String userAgent, Map<String, String> headers, String baseUrl) {
        this.eventManager = eventManager;
        this.defaultEventHandler = defaultEventHandler;
        this.proxyConfig = proxyConfig;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.defaultFirstPartyToken = defaultFirstPartyToken;
        this.enableBatching = enableBatching;
        this.timeout = timeout;
        this.userAgent = userAgent;
        this.headers = headers;
        this.baseUrl = baseUrl;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Class<? extends IEventHandler> getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public OAuth2Credential getDefaultFirstPartyToken() {
        return this.defaultFirstPartyToken;
    }

    public boolean isEnableBatching() {
        return this.enableBatching;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public TwitchGraphQLBuilder withEventManager(EventManager eventManager) {
        return this.eventManager == eventManager ? this : new TwitchGraphQLBuilder(eventManager, this.defaultEventHandler, this.proxyConfig, this.clientId, this.clientSecret, this.defaultFirstPartyToken, this.enableBatching, this.timeout, this.userAgent, this.headers, this.baseUrl);
    }

    public TwitchGraphQLBuilder withDefaultEventHandler(Class<? extends IEventHandler> defaultEventHandler) {
        return this.defaultEventHandler == defaultEventHandler ? this : new TwitchGraphQLBuilder(this.eventManager, defaultEventHandler, this.proxyConfig, this.clientId, this.clientSecret, this.defaultFirstPartyToken, this.enableBatching, this.timeout, this.userAgent, this.headers, this.baseUrl);
    }

    public TwitchGraphQLBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, proxyConfig, this.clientId, this.clientSecret, this.defaultFirstPartyToken, this.enableBatching, this.timeout, this.userAgent, this.headers, this.baseUrl);
    }

    public TwitchGraphQLBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, this.proxyConfig, clientId, this.clientSecret, this.defaultFirstPartyToken, this.enableBatching, this.timeout, this.userAgent, this.headers, this.baseUrl);
    }

    @Deprecated
    public TwitchGraphQLBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, this.proxyConfig, this.clientId, clientSecret, this.defaultFirstPartyToken, this.enableBatching, this.timeout, this.userAgent, this.headers, this.baseUrl);
    }

    public TwitchGraphQLBuilder withDefaultFirstPartyToken(OAuth2Credential defaultFirstPartyToken) {
        return this.defaultFirstPartyToken == defaultFirstPartyToken ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, this.proxyConfig, this.clientId, this.clientSecret, defaultFirstPartyToken, this.enableBatching, this.timeout, this.userAgent, this.headers, this.baseUrl);
    }

    public TwitchGraphQLBuilder withEnableBatching(boolean enableBatching) {
        return this.enableBatching == enableBatching ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, this.proxyConfig, this.clientId, this.clientSecret, this.defaultFirstPartyToken, enableBatching, this.timeout, this.userAgent, this.headers, this.baseUrl);
    }

    public TwitchGraphQLBuilder withTimeout(Integer timeout) {
        return this.timeout == timeout ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, this.proxyConfig, this.clientId, this.clientSecret, this.defaultFirstPartyToken, this.enableBatching, timeout, this.userAgent, this.headers, this.baseUrl);
    }

    public TwitchGraphQLBuilder withUserAgent(String userAgent) {
        return this.userAgent == userAgent ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, this.proxyConfig, this.clientId, this.clientSecret, this.defaultFirstPartyToken, this.enableBatching, this.timeout, userAgent, this.headers, this.baseUrl);
    }

    public TwitchGraphQLBuilder withHeaders(Map<String, String> headers) {
        return this.headers == headers ? this : new TwitchGraphQLBuilder(this.eventManager, this.defaultEventHandler, this.proxyConfig, this.clientId, this.clientSecret, this.defaultFirstPartyToken, this.enableBatching, this.timeout, this.userAgent, headers, this.baseUrl);
    }
}

