/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub.socket;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.client.websocket.WebsocketConnection;
import com.github.twitch4j.client.websocket.domain.WebsocketConnectionState;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.eventsub.EventSubSubscription;
import com.github.twitch4j.eventsub.EventSubSubscriptionStatus;
import com.github.twitch4j.eventsub.EventSubTransport;
import com.github.twitch4j.eventsub.EventSubTransportMethod;
import com.github.twitch4j.eventsub.events.EventSubEvent;
import com.github.twitch4j.eventsub.socket.IEventSubSocket;
import com.github.twitch4j.eventsub.socket.SubscriptionWrapper;
import com.github.twitch4j.eventsub.socket.domain.EventSubSocketInformation;
import com.github.twitch4j.eventsub.socket.domain.EventSubSocketMessage;
import com.github.twitch4j.eventsub.socket.domain.SocketCloseReason;
import com.github.twitch4j.eventsub.socket.domain.SocketMessageMetadata;
import com.github.twitch4j.eventsub.socket.domain.SocketPayload;
import com.github.twitch4j.eventsub.socket.enums.SocketMessageType;
import com.github.twitch4j.eventsub.socket.events.EventSocketClosedByTwitchEvent;
import com.github.twitch4j.eventsub.socket.events.EventSocketConnectionStateEvent;
import com.github.twitch4j.eventsub.socket.events.EventSocketDeleteSubscriptionFailureEvent;
import com.github.twitch4j.eventsub.socket.events.EventSocketDeleteSubscriptionSuccessEvent;
import com.github.twitch4j.eventsub.socket.events.EventSocketSubscriptionFailureEvent;
import com.github.twitch4j.eventsub.socket.events.EventSocketSubscriptionSuccessEvent;
import com.github.twitch4j.eventsub.util.EventSubVerifier;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.TwitchHelixBuilder;
import com.github.twitch4j.helix.domain.EventSubSubscriptionList;
import com.github.twitch4j.util.IBackoffStrategy;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.core.CacheApi;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwitchEventSocket
implements IEventSubSocket {
    private static final Logger log = LoggerFactory.getLogger(TwitchEventSocket.class);
    private final Object $lock = new Object[0];
    public static final int REQUIRED_THREAD_COUNT = 1;
    public static final int MAX_SUBSCRIPTIONS_PER_SOCKET = 100;
    public static final String WEB_SOCKET_SERVER = "wss://eventsub.wss.twitch.tv/ws";
    @NotNull
    private final TwitchHelix api;
    @Nullable
    private final OAuth2Credential defaultToken;
    @NotNull
    private final EventManager eventManager;
    @NotNull
    private final ScheduledExecutorService executor;
    @Nullable
    private final ProxyConfig proxyConfig;
    @Nullable
    private final IBackoffStrategy backoffStrategy;
    private final boolean avoidRetryFailedSubscription;
    @NotNull
    private final AtomicReference<WebsocketConnection> connection;
    private final @NotNull AtomicReference<@Nullable WebsocketConnection> expiringConnection = new AtomicReference();
    @NotNull
    private final Map<SubscriptionWrapper, EventSubSubscription> subscriptions = new ConcurrentHashMap<SubscriptionWrapper, EventSubSubscription>();
    @NotNull
    private final String baseUrl;
    @NotNull
    private volatile String url;
    @Nullable
    private volatile String websocketId = null;
    private final Cache<SubscriptionWrapper, OAuth2Credential> tokenByTopic;

    TwitchEventSocket(@Nullable String baseUrl, @Nullable String url, @Nullable String clientId, @Nullable String clientSecret, @Nullable EventManager eventManager, @Nullable ScheduledExecutorService taskExecutor, @Nullable ProxyConfig proxyConfig, @Nullable WebsocketConnection connection, @Nullable TwitchHelix api, @Nullable OAuth2Credential defaultToken, @Nullable IBackoffStrategy backoffStrategy, @Nullable Boolean avoidRetryFailedSubscription) {
        this.baseUrl = baseUrl != null ? baseUrl : WEB_SOCKET_SERVER;
        this.url = url != null ? url : this.baseUrl;
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager((EventManager)eventManager, SimpleEventHandler.class);
        this.executor = taskExecutor != null ? taskExecutor : Executors.newScheduledThreadPool(1);
        this.proxyConfig = proxyConfig;
        this.defaultToken = defaultToken;
        this.backoffStrategy = backoffStrategy;
        this.avoidRetryFailedSubscription = avoidRetryFailedSubscription != null ? avoidRetryFailedSubscription : true;
        this.tokenByTopic = CacheApi.create(spec -> {
            spec.executor(this.executor);
            spec.maxSize(Long.valueOf(400L));
        });
        this.connection = connection == null ? new AtomicReference<WebsocketConnection>(this.buildConnection()) : new AtomicReference<WebsocketConnection>(connection);
        if (api == null) {
            if (defaultToken == null || StringUtils.isBlank((CharSequence)defaultToken.getAccessToken())) {
                log.warn("EventSub Websockets currently requires a user access token, which has not been passed!");
            }
            this.api = TwitchHelixBuilder.builder().withClientId(clientId).withClientSecret(clientSecret).withDefaultAuthToken(defaultToken).build();
        } else {
            this.api = api;
        }
        this.eventManager.getServiceMediator().addService("twitch4j-eventsub-websocket", (Object)this);
        this.connect();
    }

    @Override
    public void connect() {
        WebsocketConnection socket = this.connection.updateAndGet(conn -> {
            if (conn == null) {
                return this.buildConnection();
            }
            if (!StringUtils.equals((CharSequence)this.url, (CharSequence)conn.getConfig().baseUrl())) {
                this.executor.execute(() -> TwitchEventSocket.attemptClose(conn));
                return this.buildConnection();
            }
            if (conn == this.expiringConnection.get()) {
                return this.buildConnection();
            }
            return conn;
        });
        socket.connect();
    }

    @Override
    public void disconnect() {
        this.websocketId = null;
        this.url = this.baseUrl;
        WebsocketConnection socket = this.connection.get();
        if (socket != null) {
            socket.disconnect();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            WebsocketConnection expiring;
            this.websocketId = null;
            WebsocketConnection current = this.connection.getAndSet(null);
            if (current != null) {
                current.close();
            }
            if ((expiring = (WebsocketConnection)this.expiringConnection.getAndSet(null)) != null) {
                expiring.close();
            }
            ArrayDeque futures = new ArrayDeque(this.subscriptions.size());
            this.subscriptions.keySet().removeIf(sub -> futures.add(this.executor.submit(() -> {
                if (StringUtils.isNotBlank((CharSequence)sub.getId())) {
                    try {
                        this.api.deleteEventSubSubscription(this.getAssociatedToken((EventSubSubscription)sub), sub.getId()).execute();
                        this.eventManager.publish((Object)new EventSocketDeleteSubscriptionSuccessEvent((EventSubSubscription)sub, this));
                    }
                    catch (Exception e) {
                        log.debug("Failed to delete event socket subscription on close: " + (Object)sub, (Throwable)e);
                        this.eventManager.publish((Object)new EventSocketDeleteSubscriptionFailureEvent((EventSubSubscription)sub, this, e));
                    }
                }
            })));
            for (Future future : futures) {
                future.get();
            }
            this.tokenByTopic.clear();
            futures.clear();
            this.subscriptions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(OAuth2Credential token, EventSubSubscription sub) {
        Object object = this.$lock;
        synchronized (object) {
            boolean alreadyEnabled;
            SubscriptionWrapper wrapped = SubscriptionWrapper.wrap(sub);
            if (this.subscriptions.containsKey((Object)wrapped)) {
                return false;
            }
            if (sub.getTransport() == null || sub.getTransport().getMethod() != EventSubTransportMethod.WEBSOCKET) {
                sub.setTransport(EventSubTransport.builder().method(EventSubTransportMethod.WEBSOCKET).build());
            }
            if (token != null) {
                this.tokenByTopic.putIfAbsent((Object)wrapped, (Object)token);
            }
            boolean bl = alreadyEnabled = StringUtils.isNotBlank((CharSequence)sub.getId()) && sub.getStatus() == EventSubSubscriptionStatus.ENABLED && StringUtils.equals((CharSequence)sub.getTransport().getSessionId(), (CharSequence)this.websocketId);
            if (alreadyEnabled) {
                return this.subscriptions.putIfAbsent(wrapped, wrapped) == null;
            }
            if (this.websocketId != null && this.getConnection().getConnectionState() == WebsocketConnectionState.CONNECTED) {
                return this.createSub(token, sub, TwitchEventSocket.augmentSub(sub, this.websocketId));
            }
            return this.subscriptions.putIfAbsent(wrapped, wrapped) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(EventSubSubscription subscription) {
        Object object = this.$lock;
        synchronized (object) {
            EventSubSubscription sub = this.unsubscribeNoHelix(subscription);
            if (sub != null) {
                if (StringUtils.isNotBlank((CharSequence)sub.getId())) {
                    this.executor.execute(() -> {
                        try {
                            this.api.deleteEventSubSubscription(this.getAssociatedToken(sub), sub.getId()).execute();
                            this.eventManager.publish((Object)new EventSocketDeleteSubscriptionSuccessEvent(sub, this));
                        }
                        catch (Exception e) {
                            log.warn("Failed to delete EventSub-WS subscription via Twitch API {}", (Object)sub, (Object)e);
                            this.eventManager.publish((Object)new EventSocketDeleteSubscriptionFailureEvent(sub, this, e));
                        }
                    });
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public Collection<EventSubSubscription> getSubscriptions() {
        return Collections.unmodifiableSet(this.subscriptions.keySet());
    }

    public WebsocketConnectionState getState() {
        WebsocketConnection ws = this.connection.get();
        return ws != null ? ws.getConnectionState() : WebsocketConnectionState.DISCONNECTED;
    }

    @Nullable
    private EventSubSubscription unsubscribeNoHelix(@NotNull EventSubSubscription remove) {
        return this.subscriptions.remove((Object)SubscriptionWrapper.wrap(remove));
    }

    private void onInitialConnection(String websocketId) {
        ArrayDeque oldSubs = new ArrayDeque(this.subscriptions.size());
        this.subscriptions.keySet().removeIf(oldSubs::add);
        for (EventSubSubscription old : oldSubs) {
            if (StringUtils.equals((CharSequence)old.getTransport().getSessionId(), (CharSequence)websocketId)) {
                this.subscriptions.putIfAbsent(SubscriptionWrapper.wrap(old), old);
                continue;
            }
            this.executor.execute(() -> {
                OAuth2Credential credential = this.getAssociatedCredential(old);
                EventSubSubscription newSub = TwitchEventSocket.augmentSub(old, websocketId);
                if (StringUtils.isNotEmpty((CharSequence)old.getId())) {
                    try {
                        this.api.deleteEventSubSubscription(TwitchEventSocket.getAuthToken(credential), old.getId()).execute();
                        log.trace("EventSub-WS deleted subscription {}", (Object)old);
                        this.eventManager.publish((Object)new EventSocketDeleteSubscriptionSuccessEvent(old, this));
                    }
                    catch (Exception e) {
                        log.debug("Could not delete old EventSub-WS subscription {}", (Object)old, (Object)e);
                        this.eventManager.publish((Object)new EventSocketDeleteSubscriptionFailureEvent(old, this, e));
                    }
                }
                this.createSub(credential, old, newSub);
            });
        }
    }

    private void onTextMessage(String jsonMessage) {
        SocketPayload payload;
        SocketMessageType messageType;
        SocketMessageMetadata metadata;
        EventSubSocketMessage message;
        log.trace("Received EventSub-WS message: {}", (Object)jsonMessage);
        try {
            message = (EventSubSocketMessage)TypeConvert.jsonToObject((String)jsonMessage, EventSubSocketMessage.class);
            metadata = Objects.requireNonNull(message.getMetadata());
            messageType = Objects.requireNonNull(metadata.getMessageType());
            payload = message.getPayload();
            if (messageType == SocketMessageType.SESSION_WELCOME) {
                Objects.requireNonNull(payload);
                Objects.requireNonNull(payload.getSession());
                Objects.requireNonNull(payload.getSession().getId());
            } else if (messageType == SocketMessageType.SESSION_RECONNECT) {
                Objects.requireNonNull(payload.getSession());
            } else if (messageType == SocketMessageType.NOTIFICATION) {
                Objects.requireNonNull(metadata.getSubscriptionType());
                Objects.requireNonNull(metadata.getSubscriptionVersion());
            } else if (messageType == SocketMessageType.REVOCATION) {
                Objects.requireNonNull(payload.getSubscription());
            }
        }
        catch (Exception e) {
            log.error("Failed to parse EventSub-WS message", (Throwable)e);
            return;
        }
        if (!EventSubVerifier.verifyMessageId((String)metadata.getMessageId())) {
            log.debug("EventSub-WS received (and ignored) duplicate message {}", (Object)message);
            return;
        }
        switch (messageType) {
            case SESSION_WELCOME: {
                EventSubSocketInformation socket = payload.getSession();
                this.websocketId = socket.getId();
                log.debug("EventSub-WS connection was welcomed at {}", (Object)socket.getConnectedAt());
                if (this.baseUrl.equals(this.url)) {
                    this.onInitialConnection(socket.getId());
                } else {
                    this.subscriptions.values().forEach(sub -> sub.getTransport().setSessionId(this.websocketId));
                }
                WebsocketConnection expired = this.expiringConnection.getAndSet(null);
                TwitchEventSocket.attemptClose(expired);
                this.url = this.baseUrl;
                break;
            }
            case SESSION_KEEPALIVE: {
                log.trace("EventSub-WS connection received keep alive message");
                break;
            }
            case SESSION_RECONNECT: {
                String reconnectUrl = payload.getSession().getReconnectUrl();
                if (StringUtils.isBlank((CharSequence)reconnectUrl)) {
                    log.warn("EventSub-WS was unable to parse url in reconnect message: {}", (Object)jsonMessage);
                    this.reconnect();
                    return;
                }
                WebsocketConnection old = this.getConnection();
                this.expiringConnection.set(old);
                this.executor.schedule(() -> {
                    if (this.expiringConnection.compareAndSet(old, null)) {
                        TwitchEventSocket.attemptClose(old);
                    }
                }, 30L, TimeUnit.SECONDS);
                this.url = reconnectUrl;
                this.connect();
                break;
            }
            case NOTIFICATION: {
                EventSubEvent event;
                try {
                    event = Objects.requireNonNull(payload.getParsedEvent());
                }
                catch (Exception e) {
                    log.error("EventSub-WS failed to parse notification event data: " + payload.getEventData(), (Throwable)e);
                    return;
                }
                try {
                    this.eventManager.publish((Object)event);
                }
                catch (Exception e) {
                    log.error("Non-T4J event consumer threw exception while handling EventSocket notification: " + event, (Throwable)e);
                }
                break;
            }
            case REVOCATION: {
                EventSubSubscription revoked = payload.getSubscription();
                if (this.unsubscribeNoHelix(revoked) != null) {
                    log.debug("Removed revoked EventSub-WS subscription {}", (Object)revoked);
                    try {
                        this.eventManager.publish((Object)payload.getSubscription());
                    }
                    catch (Exception e) {
                        log.error("Non-T4J event consumer threw exception while handling revoked EventSocket subscription", (Throwable)e);
                    }
                    break;
                }
                log.warn("Failed to identify revoked EventSub-WS subscription {}", (Object)revoked);
            }
        }
    }

    private boolean createSub(OAuth2Credential credential, EventSubSubscription oldSub, EventSubSubscription newSub) {
        OAuth2Credential token = credential != null ? credential : this.defaultToken;
        try {
            SubscriptionWrapper sub = SubscriptionWrapper.wrap((EventSubSubscription)((EventSubSubscriptionList)this.api.createEventSubSubscription(TwitchEventSocket.getAuthToken(token), newSub).execute()).getSubscriptions().get(0));
            this.subscriptions.put(sub, sub);
            log.debug("EventSub-WS successfully created subscription {}", (Object)sub);
            if (token != null) {
                this.tokenByTopic.put((Object)sub, (Object)token);
            }
            this.eventManager.publish((Object)new EventSocketSubscriptionSuccessEvent(sub, this));
            return true;
        }
        catch (Exception e) {
            log.error("Failed to create EventSub-WS subscription {}", (Object)newSub, (Object)e);
            boolean retry = true;
            if (this.avoidRetryFailedSubscription && e instanceof HystrixRuntimeException && e.getCause() instanceof ContextedRuntimeException) {
                ContextedRuntimeException cause = (ContextedRuntimeException)e.getCause();
                String status = String.valueOf(cause.getFirstContextValue("errorStatus"));
                try {
                    int code = Integer.parseInt(status);
                    if (code >= 400 && code < 500 && code != 429) {
                        retry = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (retry) {
                SubscriptionWrapper later = SubscriptionWrapper.wrap(oldSub.toBuilder().status(null).createdAt(null).transport(oldSub.getTransport().withSessionId(null)).build());
                this.subscriptions.putIfAbsent(later, later);
            } else {
                log.warn("Will not retry subscription due to creation failure: {}", (Object)newSub);
            }
            this.eventManager.publish((Object)new EventSocketSubscriptionFailureEvent(newSub, this, e, retry));
            return false;
        }
    }

    private WebsocketConnection getConnection() {
        return this.connection.updateAndGet(conn -> conn != null ? conn : this.buildConnection());
    }

    private WebsocketConnection buildConnection() {
        AtomicReference<WebsocketConnection> wsRef = new AtomicReference<WebsocketConnection>();
        WebsocketConnection ws = new WebsocketConnection(spec -> {
            spec.baseUrl(this.url);
            spec.taskExecutor(this.executor);
            spec.onTextMessage(this::onTextMessage);
            spec.onStateChanged((oldState, newState) -> {
                WebsocketConnection thisSocket = (WebsocketConnection)wsRef.get();
                if (thisSocket != null && thisSocket == this.connection.get()) {
                    boolean lost;
                    boolean bl = lost = newState == WebsocketConnectionState.LOST;
                    if (lost) {
                        this.websocketId = null;
                        this.subscriptions.values().forEach(sub -> sub.setStatus(EventSubSubscriptionStatus.WEBSOCKET_NETWORK_TIMEOUT));
                    }
                    this.eventManager.publish((Object)new EventSocketConnectionStateEvent((WebsocketConnectionState)oldState, (WebsocketConnectionState)newState, this));
                    if (lost && !spec.baseUrl().equals(this.getUrl())) {
                        wsRef.lazySet(null);
                        this.executor.execute(this::reconnect);
                        thisSocket.disconnect();
                    }
                }
            });
            spec.onCloseFrame((code, payload) -> {
                SocketCloseReason reason = SocketCloseReason.MAPPINGS.get(code);
                if (reason == null) {
                    log.warn("Failed to parse eventsub websocket close frame payload: {} = {}", code, payload);
                } else {
                    log.debug("Twitch disconnected the EventSub-WS connection {} because {}", (Object)this.websocketId, (Object)reason);
                }
                if (reason == SocketCloseReason.RECONNECT_GRACE_TIME_EXPIRED) {
                    return;
                }
                if (reason == SocketCloseReason.INVALID_RECONNECT) {
                    this.url = this.baseUrl;
                }
                if (reason == SocketCloseReason.CONNECTION_UNUSED && this.subscriptions.isEmpty()) {
                    this.executor.execute(this::disconnect);
                } else {
                    this.executor.execute(this::connect);
                }
                if (wsRef.get() == this.connection.get()) {
                    this.eventManager.publish((Object)new EventSocketClosedByTwitchEvent(reason, this));
                }
            });
            if (this.proxyConfig != null) {
                spec.proxyConfig(this.proxyConfig);
            }
            if (this.backoffStrategy != null) {
                spec.backoffStrategy(this.backoffStrategy);
            }
        });
        wsRef.set(ws);
        return ws;
    }

    private OAuth2Credential getAssociatedCredential(EventSubSubscription sub) {
        OAuth2Credential associated = (OAuth2Credential)this.tokenByTopic.get((Object)SubscriptionWrapper.wrap(sub));
        return associated != null ? associated : this.defaultToken;
    }

    private String getAssociatedToken(EventSubSubscription sub) {
        return TwitchEventSocket.getAuthToken(this.getAssociatedCredential(sub));
    }

    static String getAuthToken(OAuth2Credential token) {
        return token != null ? token.getAccessToken() : null;
    }

    private static EventSubSubscription augmentSub(EventSubSubscription old, String newWebSocketId) {
        assert (old.getTransport() != null);
        return EventSubSubscription.builder().type(old.getType()).condition(old.getCondition()).transport(old.getTransport().withSessionId(newWebSocketId)).isBatchingEnabled(old.isBatchingEnabled()).rawType(old.getRawType()).rawVersion(old.getRawVersion()).build();
    }

    private static void attemptClose(WebsocketConnection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (Exception e) {
            log.warn("Failed to close old EventSub-WS connection", (Throwable)e);
            try {
                connection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static TwitchEventSocketBuilder builder() {
        return new TwitchEventSocketBuilder();
    }

    @Override
    @Nullable
    public OAuth2Credential getDefaultToken() {
        return this.defaultToken;
    }

    @NotNull
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @NotNull
    private String getUrl() {
        return this.url;
    }

    @Nullable
    public String getWebsocketId() {
        return this.websocketId;
    }

    public static class TwitchEventSocketBuilder {
        private String baseUrl;
        private String url;
        private String clientId;
        private String clientSecret;
        private EventManager eventManager;
        private ScheduledExecutorService taskExecutor;
        private ProxyConfig proxyConfig;
        private WebsocketConnection connection;
        private TwitchHelix api;
        private OAuth2Credential defaultToken;
        private IBackoffStrategy backoffStrategy;
        private Boolean avoidRetryFailedSubscription;

        TwitchEventSocketBuilder() {
        }

        public TwitchEventSocketBuilder baseUrl(@Nullable String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public TwitchEventSocketBuilder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public TwitchEventSocketBuilder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        public TwitchEventSocketBuilder clientSecret(@Nullable String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public TwitchEventSocketBuilder eventManager(@Nullable EventManager eventManager) {
            this.eventManager = eventManager;
            return this;
        }

        public TwitchEventSocketBuilder taskExecutor(@Nullable ScheduledExecutorService taskExecutor) {
            this.taskExecutor = taskExecutor;
            return this;
        }

        public TwitchEventSocketBuilder proxyConfig(@Nullable ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public TwitchEventSocketBuilder connection(@Nullable WebsocketConnection connection) {
            this.connection = connection;
            return this;
        }

        public TwitchEventSocketBuilder api(@Nullable TwitchHelix api) {
            this.api = api;
            return this;
        }

        public TwitchEventSocketBuilder defaultToken(@Nullable OAuth2Credential defaultToken) {
            this.defaultToken = defaultToken;
            return this;
        }

        public TwitchEventSocketBuilder backoffStrategy(@Nullable IBackoffStrategy backoffStrategy) {
            this.backoffStrategy = backoffStrategy;
            return this;
        }

        public TwitchEventSocketBuilder avoidRetryFailedSubscription(@Nullable Boolean avoidRetryFailedSubscription) {
            this.avoidRetryFailedSubscription = avoidRetryFailedSubscription;
            return this;
        }

        public TwitchEventSocket build() {
            return new TwitchEventSocket(this.baseUrl, this.url, this.clientId, this.clientSecret, this.eventManager, this.taskExecutor, this.proxyConfig, this.connection, this.api, this.defaultToken, this.backoffStrategy, this.avoidRetryFailedSubscription);
        }

        public String toString() {
            return "TwitchEventSocket.TwitchEventSocketBuilder(baseUrl=" + this.baseUrl + ", url=" + this.url + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", eventManager=" + this.eventManager + ", taskExecutor=" + this.taskExecutor + ", proxyConfig=" + this.proxyConfig + ", connection=" + this.connection + ", api=" + this.api + ", defaultToken=" + this.defaultToken + ", backoffStrategy=" + this.backoffStrategy + ", avoidRetryFailedSubscription=" + this.avoidRetryFailedSubscription + ")";
        }
    }
}

