/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.enums;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum SubscriptionType {
    SUB,
    RESUB,
    SUB_GIFT,
    ANON_SUB_GIFT,
    RESUB_GIFT,
    ANON_RESUB_GIFT,
    EXTEND_SUB;

    private final String ordinalName = this.name().toLowerCase().replace("_", "");
    private static final SubscriptionType[] VALUES;

    @JsonCreator
    public static SubscriptionType fromString(String type) {
        if (type != null) {
            for (SubscriptionType subType : VALUES) {
                if (!type.equalsIgnoreCase(subType.ordinalName)) continue;
                return subType;
            }
        }
        return null;
    }

    public String toString() {
        return this.ordinalName;
    }

    public String ordinalName() {
        return this.ordinalName;
    }

    static {
        VALUES = SubscriptionType.values();
    }
}

