/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.concurrent.atomic.AtomicReference;

public class DonationAmount {
    @JsonAlias(value={"amount", "donation_amount"})
    private Long value;
    @JsonAlias(value={"exponent"})
    private Integer decimalPlaces;
    @JsonAlias(value={"campaign_currency", "donation_currency"})
    private String currency;
    @JsonIgnore
    private final AtomicReference<Object> parsedCurrency = new AtomicReference();
    @JsonIgnore
    private final AtomicReference<Object> parsedValue = new AtomicReference();

    public Long getValue() {
        return this.value;
    }

    public Integer getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public String getCurrency() {
        return this.currency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DonationAmount)) {
            return false;
        }
        DonationAmount other = (DonationAmount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$value = this.getValue();
        Long other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Integer this$decimalPlaces = this.getDecimalPlaces();
        Integer other$decimalPlaces = other.getDecimalPlaces();
        if (this$decimalPlaces == null ? other$decimalPlaces != null : !((Object)this$decimalPlaces).equals(other$decimalPlaces)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DonationAmount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Integer $decimalPlaces = this.getDecimalPlaces();
        result = result * 59 + ($decimalPlaces == null ? 43 : ((Object)$decimalPlaces).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        return result;
    }

    public String toString() {
        return "DonationAmount(value=" + this.getValue() + ", decimalPlaces=" + this.getDecimalPlaces() + ", currency=" + this.getCurrency() + ", parsedCurrency=" + this.getParsedCurrency() + ", parsedValue=" + this.getParsedValue() + ")";
    }

    @JsonAlias(value={"amount", "donation_amount"})
    private void setValue(Long value) {
        this.value = value;
    }

    @JsonAlias(value={"exponent"})
    private void setDecimalPlaces(Integer decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    @JsonAlias(value={"campaign_currency", "donation_currency"})
    private void setCurrency(String currency) {
        this.currency = currency;
    }

    public DonationAmount() {
    }

    public DonationAmount(Long value, Integer decimalPlaces, String currency) {
        this.value = value;
        this.decimalPlaces = decimalPlaces;
        this.currency = currency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Currency getParsedCurrency() {
        Object value = this.parsedCurrency.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.parsedCurrency;
            synchronized (atomicReference) {
                value = this.parsedCurrency.get();
                if (value == null) {
                    Currency actualValue = Currency.getInstance(this.getCurrency());
                    value = actualValue == null ? this.parsedCurrency : actualValue;
                    this.parsedCurrency.set(value);
                }
            }
        }
        return (Currency)(value == this.parsedCurrency ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getParsedValue() {
        Object value = this.parsedValue.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.parsedValue;
            synchronized (atomicReference) {
                value = this.parsedValue.get();
                if (value == null) {
                    BigDecimal actualValue = BigDecimal.valueOf(this.getValue(), this.getDecimalPlaces());
                    value = actualValue == null ? this.parsedValue : actualValue;
                    this.parsedValue.set(value);
                }
            }
        }
        return (BigDecimal)(value == this.parsedValue ? null : value);
    }
}

