/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.flag;

import com.github.twitch4j.chat.flag.FlagType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class AutoModFlag {
    private final int startIndex;
    private final int endIndex;
    @NotNull
    private final Map<FlagType, Integer> scores;

    AutoModFlag(int startIndex, int endIndex, @NotNull Map<FlagType, Integer> scores) {
        if (scores == null) {
            throw new NullPointerException("scores is marked non-null but is null");
        }
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.scores = scores;
    }

    public static AutoModFlagBuilder builder() {
        return new AutoModFlagBuilder();
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    @NotNull
    public Map<FlagType, Integer> getScores() {
        return this.scores;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoModFlag)) {
            return false;
        }
        AutoModFlag other = (AutoModFlag)o;
        if (this.getStartIndex() != other.getStartIndex()) {
            return false;
        }
        if (this.getEndIndex() != other.getEndIndex()) {
            return false;
        }
        Map<FlagType, Integer> this$scores = this.getScores();
        Map<FlagType, Integer> other$scores = other.getScores();
        return !(this$scores == null ? other$scores != null : !((Object)this$scores).equals(other$scores));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStartIndex();
        result = result * 59 + this.getEndIndex();
        Map<FlagType, Integer> $scores = this.getScores();
        result = result * 59 + ($scores == null ? 43 : ((Object)$scores).hashCode());
        return result;
    }

    public String toString() {
        return "AutoModFlag(startIndex=" + this.getStartIndex() + ", endIndex=" + this.getEndIndex() + ", scores=" + this.getScores() + ")";
    }

    public static class AutoModFlagBuilder {
        private int startIndex;
        private int endIndex;
        private ArrayList<FlagType> scores$key;
        private ArrayList<Integer> scores$value;

        AutoModFlagBuilder() {
        }

        public AutoModFlagBuilder startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public AutoModFlagBuilder endIndex(int endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public AutoModFlagBuilder score(FlagType scoreKey, Integer scoreValue) {
            if (this.scores$key == null) {
                this.scores$key = new ArrayList();
                this.scores$value = new ArrayList();
            }
            this.scores$key.add(scoreKey);
            this.scores$value.add(scoreValue);
            return this;
        }

        public AutoModFlagBuilder scores(Map<? extends FlagType, ? extends Integer> scores) {
            if (scores == null) {
                throw new NullPointerException("scores cannot be null");
            }
            if (this.scores$key == null) {
                this.scores$key = new ArrayList();
                this.scores$value = new ArrayList();
            }
            for (Map.Entry<? extends FlagType, ? extends Integer> $lombokEntry : scores.entrySet()) {
                this.scores$key.add($lombokEntry.getKey());
                this.scores$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public AutoModFlagBuilder clearScores() {
            if (this.scores$key != null) {
                this.scores$key.clear();
                this.scores$value.clear();
            }
            return this;
        }

        public AutoModFlag build() {
            Map<FlagType, Integer> scores;
            switch (this.scores$key == null ? 0 : this.scores$key.size()) {
                case 0: {
                    scores = Collections.emptyMap();
                    break;
                }
                case 1: {
                    scores = Collections.singletonMap(this.scores$key.get(0), this.scores$value.get(0));
                    break;
                }
                default: {
                    scores = new LinkedHashMap(this.scores$key.size() < 0x40000000 ? 1 + this.scores$key.size() + (this.scores$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.scores$key.size(); ++$i) {
                        scores.put(this.scores$key.get($i), this.scores$value.get($i));
                    }
                    scores = Collections.unmodifiableMap(scores);
                }
            }
            return new AutoModFlag(this.startIndex, this.endIndex, scores);
        }

        public String toString() {
            return "AutoModFlag.AutoModFlagBuilder(startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", scores$key=" + this.scores$key + ", scores$value=" + this.scores$value + ")";
        }
    }
}

