/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.AbstractChannelEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.common.enums.CommandPermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public final class UserStateEvent
extends AbstractChannelEvent {
    private final IRCMessageEvent messageEvent;
    private final List<String> emoteSets;

    public UserStateEvent(IRCMessageEvent messageEvent) {
        super(messageEvent.getChannel());
        this.messageEvent = messageEvent;
        String[] emoteSets = messageEvent.getTagValue("emote-sets").map(emoteSetsStr -> emoteSetsStr.split(",")).orElse(new String[0]);
        this.emoteSets = Collections.unmodifiableList(Arrays.asList(emoteSets));
    }

    public Optional<String> getColor() {
        return this.messageEvent.getTagValue("color");
    }

    public Optional<String> getDisplayName() {
        return this.messageEvent.getTagValue("display-name");
    }

    public boolean isSubscriber() {
        return this.messageEvent.getClientPermissions().contains(CommandPermission.SUBSCRIBER);
    }

    public OptionalInt getSubscriberMonth() {
        return this.messageEvent.getSubscriberMonths();
    }

    public boolean isBroadcaster() {
        return this.messageEvent.getClientPermissions().contains(CommandPermission.BROADCASTER);
    }

    public boolean isModerator() {
        return this.messageEvent.getClientPermissions().contains(CommandPermission.MODERATOR);
    }

    public boolean isStaff() {
        return this.messageEvent.getClientPermissions().contains(CommandPermission.TWITCHSTAFF);
    }

    public boolean isPrimeOrTurbo() {
        return this.messageEvent.getClientPermissions().contains(CommandPermission.PRIME_TURBO);
    }

    @Override
    public String toString() {
        return "UserStateEvent(messageEvent=" + (Object)((Object)this.getMessageEvent()) + ", emoteSets=" + this.getEmoteSets() + ")";
    }

    public IRCMessageEvent getMessageEvent() {
        return this.messageEvent;
    }

    public List<String> getEmoteSets() {
        return this.emoteSets;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserStateEvent)) {
            return false;
        }
        UserStateEvent other = (UserStateEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IRCMessageEvent this$messageEvent = this.getMessageEvent();
        IRCMessageEvent other$messageEvent = other.getMessageEvent();
        if (this$messageEvent == null ? other$messageEvent != null : !((Object)((Object)this$messageEvent)).equals((Object)other$messageEvent)) {
            return false;
        }
        List<String> this$emoteSets = this.getEmoteSets();
        List<String> other$emoteSets = other.getEmoteSets();
        return !(this$emoteSets == null ? other$emoteSets != null : !((Object)this$emoteSets).equals(other$emoteSets));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserStateEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IRCMessageEvent $messageEvent = this.getMessageEvent();
        result = result * 59 + ($messageEvent == null ? 43 : ((Object)((Object)$messageEvent)).hashCode());
        List<String> $emoteSets = this.getEmoteSets();
        result = result * 59 + ($emoteSets == null ? 43 : ((Object)$emoteSets).hashCode());
        return result;
    }
}

