/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.AbstractChannelEvent;
import com.github.twitch4j.common.events.domain.EventChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ChannelStateEvent
extends AbstractChannelEvent {
    private final Map<ChannelState, Object> states;

    public ChannelStateEvent(EventChannel channel, ChannelState state, Object value) {
        super(channel);
        HashMap<ChannelState, Object> states = new HashMap<ChannelState, Object>();
        states.put(state, value);
        this.states = Collections.unmodifiableMap(states);
    }

    public ChannelStateEvent(EventChannel channel, Map<ChannelState, Object> state) {
        super(channel);
        HashMap<ChannelState, Object> states = new HashMap<ChannelState, Object>();
        states.putAll(state);
        this.states = Collections.unmodifiableMap(states);
    }

    public Object getState(ChannelState state) {
        return this.states.getOrDefault((Object)state, null);
    }

    @Override
    public String toString() {
        return "ChannelStateEvent(states=" + this.getStates() + ")";
    }

    public Map<ChannelState, Object> getStates() {
        return this.states;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelStateEvent)) {
            return false;
        }
        ChannelStateEvent other = (ChannelStateEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map<ChannelState, Object> this$states = this.getStates();
        Map<ChannelState, Object> other$states = other.getStates();
        return !(this$states == null ? other$states != null : !((Object)this$states).equals(other$states));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChannelStateEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<ChannelState, Object> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        return result;
    }

    public static enum ChannelState {
        BROADCAST_LANG,
        EMOTE,
        FOLLOWERS,
        R9K,
        SLOW,
        SUBSCRIBERS;

    }
}

