/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.CredentialManagerBuilder;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.chat.TwitchChat;
import com.github.twitch4j.chat.util.TwitchChatLimitHelper;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.config.Twitch4JGlobal;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.common.util.ThreadUtils;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchChatBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitchChatBuilder.class);
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private Integer requestQueueSize = -1;
    private EventManager eventManager;
    private Class<? extends IEventHandler> defaultEventHandler = SimpleEventHandler.class;
    private CredentialManager credentialManager = CredentialManagerBuilder.builder().build();
    private OAuth2Credential chatAccount;
    private String baseUrl = "wss://irc-ws.chat.twitch.tv:443";
    private boolean sendCredentialToThirdPartyHost = false;
    protected Collection<String> botOwnerIds = new HashSet<String>();
    protected final List<String> commandPrefixes = new ArrayList<String>();
    protected Integer chatQueueSize = 200;
    protected Bandwidth chatRateLimit = TwitchChatLimitHelper.USER_MESSAGE_LIMIT;
    protected Bandwidth[] whisperRateLimit = TwitchChatLimitHelper.USER_WHISPER_LIMIT.toArray(new Bandwidth[2]);
    protected Bandwidth joinRateLimit = TwitchChatLimitHelper.USER_JOIN_LIMIT;
    protected Bucket ircMessageBucket = null;
    protected Bucket ircWhisperBucket = null;
    protected Bucket ircJoinBucket = null;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
    private long chatQueueTimeout = 1000L;
    private ProxyConfig proxyConfig = null;
    private boolean autoJoinOwnChannel = true;
    private boolean enableMembershipEvents = true;

    public static TwitchChatBuilder builder() {
        return new TwitchChatBuilder();
    }

    public TwitchChat build() {
        log.debug("TwitchChat: Initializing ErrorTracking ...");
        if (this.scheduledThreadPoolExecutor == null) {
            this.scheduledThreadPoolExecutor = ThreadUtils.getDefaultScheduledThreadPoolExecutor((String)("twitch4j-chat-" + RandomStringUtils.random((int)4, (boolean)true, (boolean)true)), (Integer)2);
        }
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager((EventManager)this.eventManager, this.defaultEventHandler);
        if (this.ircMessageBucket == null) {
            this.ircMessageBucket = TwitchChatLimitHelper.createBucket(this.chatRateLimit);
        }
        if (this.ircWhisperBucket == null) {
            this.ircWhisperBucket = TwitchChatLimitHelper.createBucket(this.whisperRateLimit);
        }
        if (this.ircJoinBucket == null) {
            this.ircJoinBucket = TwitchChatLimitHelper.createBucket(this.joinRateLimit);
        }
        log.debug("TwitchChat: Initializing Module ...");
        return new TwitchChat(this.eventManager, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.commandPrefixes, this.chatQueueSize, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.botOwnerIds);
    }

    public TwitchChatBuilder withCommandTrigger(String commandTrigger) {
        this.commandPrefixes.add(commandTrigger);
        return this;
    }

    public TwitchChatBuilder withCommandTriggers(Collection<String> commandTrigger) {
        this.commandPrefixes.addAll(commandTrigger);
        return this;
    }

    public TwitchChatBuilder withBotOwnerId(String userId) {
        this.botOwnerIds.add(userId);
        return this;
    }

    public TwitchChatBuilder withBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds.addAll(botOwnerIds);
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Class<? extends IEventHandler> getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public CredentialManager getCredentialManager() {
        return this.credentialManager;
    }

    public OAuth2Credential getChatAccount() {
        return this.chatAccount;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isSendCredentialToThirdPartyHost() {
        return this.sendCredentialToThirdPartyHost;
    }

    public Collection<String> getBotOwnerIds() {
        return this.botOwnerIds;
    }

    public List<String> getCommandPrefixes() {
        return this.commandPrefixes;
    }

    public Integer getChatQueueSize() {
        return this.chatQueueSize;
    }

    public Bandwidth getChatRateLimit() {
        return this.chatRateLimit;
    }

    public Bandwidth[] getWhisperRateLimit() {
        return this.whisperRateLimit;
    }

    public Bandwidth getJoinRateLimit() {
        return this.joinRateLimit;
    }

    public Bucket getIrcMessageBucket() {
        return this.ircMessageBucket;
    }

    public Bucket getIrcWhisperBucket() {
        return this.ircWhisperBucket;
    }

    public Bucket getIrcJoinBucket() {
        return this.ircJoinBucket;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public long getChatQueueTimeout() {
        return this.chatQueueTimeout;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public boolean isAutoJoinOwnChannel() {
        return this.autoJoinOwnChannel;
    }

    public boolean isEnableMembershipEvents() {
        return this.enableMembershipEvents;
    }

    private TwitchChatBuilder() {
    }

    private TwitchChatBuilder(String clientId, String clientSecret, Integer requestQueueSize, EventManager eventManager, Class<? extends IEventHandler> defaultEventHandler, CredentialManager credentialManager, OAuth2Credential chatAccount, String baseUrl, boolean sendCredentialToThirdPartyHost, Collection<String> botOwnerIds, Integer chatQueueSize, Bandwidth chatRateLimit, Bandwidth[] whisperRateLimit, Bandwidth joinRateLimit, Bucket ircMessageBucket, Bucket ircWhisperBucket, Bucket ircJoinBucket, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long chatQueueTimeout, ProxyConfig proxyConfig, boolean autoJoinOwnChannel, boolean enableMembershipEvents) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.requestQueueSize = requestQueueSize;
        this.eventManager = eventManager;
        this.defaultEventHandler = defaultEventHandler;
        this.credentialManager = credentialManager;
        this.chatAccount = chatAccount;
        this.baseUrl = baseUrl;
        this.sendCredentialToThirdPartyHost = sendCredentialToThirdPartyHost;
        this.botOwnerIds = botOwnerIds;
        this.chatQueueSize = chatQueueSize;
        this.chatRateLimit = chatRateLimit;
        this.whisperRateLimit = whisperRateLimit;
        this.joinRateLimit = joinRateLimit;
        this.ircMessageBucket = ircMessageBucket;
        this.ircWhisperBucket = ircWhisperBucket;
        this.ircJoinBucket = ircJoinBucket;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.chatQueueTimeout = chatQueueTimeout;
        this.proxyConfig = proxyConfig;
        this.autoJoinOwnChannel = autoJoinOwnChannel;
        this.enableMembershipEvents = enableMembershipEvents;
    }

    public TwitchChatBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchChatBuilder(clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchChatBuilder(this.clientId, clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withEventManager(EventManager eventManager) {
        return this.eventManager == eventManager ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withDefaultEventHandler(Class<? extends IEventHandler> defaultEventHandler) {
        return this.defaultEventHandler == defaultEventHandler ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withCredentialManager(CredentialManager credentialManager) {
        return this.credentialManager == credentialManager ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withChatAccount(OAuth2Credential chatAccount) {
        return this.chatAccount == chatAccount ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withBaseUrl(String baseUrl) {
        return this.baseUrl == baseUrl ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withSendCredentialToThirdPartyHost(boolean sendCredentialToThirdPartyHost) {
        return this.sendCredentialToThirdPartyHost == sendCredentialToThirdPartyHost ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder setBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds = botOwnerIds;
        return this;
    }

    public TwitchChatBuilder withChatQueueSize(Integer chatQueueSize) {
        return this.chatQueueSize == chatQueueSize ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withChatRateLimit(Bandwidth chatRateLimit) {
        return this.chatRateLimit == chatRateLimit ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withWhisperRateLimit(Bandwidth[] whisperRateLimit) {
        return this.whisperRateLimit == whisperRateLimit ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withJoinRateLimit(Bandwidth joinRateLimit) {
        return this.joinRateLimit == joinRateLimit ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withIrcMessageBucket(Bucket ircMessageBucket) {
        return this.ircMessageBucket == ircMessageBucket ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withIrcWhisperBucket(Bucket ircWhisperBucket) {
        return this.ircWhisperBucket == ircWhisperBucket ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withIrcJoinBucket(Bucket ircJoinBucket) {
        return this.ircJoinBucket == ircJoinBucket ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return this.scheduledThreadPoolExecutor == scheduledThreadPoolExecutor ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withChatQueueTimeout(long chatQueueTimeout) {
        return this.chatQueueTimeout == chatQueueTimeout ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withAutoJoinOwnChannel(boolean autoJoinOwnChannel) {
        return this.autoJoinOwnChannel == autoJoinOwnChannel ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, autoJoinOwnChannel, this.enableMembershipEvents);
    }

    public TwitchChatBuilder withEnableMembershipEvents(boolean enableMembershipEvents) {
        return this.enableMembershipEvents == enableMembershipEvents ? this : new TwitchChatBuilder(this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, enableMembershipEvents);
    }
}

