/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.AbstractChannelEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.common.events.domain.EventUser;
import java.util.OptionalInt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class ViewerMilestoneEvent
extends AbstractChannelEvent {
    public static final String USERNOTICE_ID = "viewermilestone";
    private final IRCMessageEvent messageEvent;
    private final EventUser user;
    private final String systemMessage;
    private final String milestoneUniqueId;
    private final String milestoneCategory;
    private final String milestoneValue;

    @ApiStatus.Internal
    public ViewerMilestoneEvent(@NotNull IRCMessageEvent messageEvent) {
        super(messageEvent.getChannel());
        this.messageEvent = messageEvent;
        this.user = messageEvent.getUser();
        this.systemMessage = messageEvent.getTagValue("system-msg").orElse(null);
        this.milestoneUniqueId = messageEvent.getTagValue("msg-param-id").orElse(null);
        this.milestoneCategory = messageEvent.getTagValue("msg-param-category").orElse(null);
        this.milestoneValue = messageEvent.getTagValue("msg-param-value").orElse(null);
    }

    public boolean isWatchStreak() {
        return "watch-streak".equalsIgnoreCase(this.milestoneCategory);
    }

    public OptionalInt parseValue() {
        try {
            return OptionalInt.of(Integer.parseInt(this.milestoneValue));
        }
        catch (Exception e) {
            return OptionalInt.empty();
        }
    }

    public IRCMessageEvent getMessageEvent() {
        return this.messageEvent;
    }

    public EventUser getUser() {
        return this.user;
    }

    public String getSystemMessage() {
        return this.systemMessage;
    }

    public String getMilestoneUniqueId() {
        return this.milestoneUniqueId;
    }

    public String getMilestoneCategory() {
        return this.milestoneCategory;
    }

    public String getMilestoneValue() {
        return this.milestoneValue;
    }

    @Override
    public String toString() {
        return "ViewerMilestoneEvent(super=" + super.toString() + ", user=" + this.getUser() + ", systemMessage=" + this.getSystemMessage() + ", milestoneUniqueId=" + this.getMilestoneUniqueId() + ", milestoneCategory=" + this.getMilestoneCategory() + ", milestoneValue=" + this.getMilestoneValue() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewerMilestoneEvent)) {
            return false;
        }
        ViewerMilestoneEvent other = (ViewerMilestoneEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventUser this$user = this.getUser();
        EventUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$systemMessage = this.getSystemMessage();
        String other$systemMessage = other.getSystemMessage();
        if (this$systemMessage == null ? other$systemMessage != null : !this$systemMessage.equals(other$systemMessage)) {
            return false;
        }
        String this$milestoneUniqueId = this.getMilestoneUniqueId();
        String other$milestoneUniqueId = other.getMilestoneUniqueId();
        if (this$milestoneUniqueId == null ? other$milestoneUniqueId != null : !this$milestoneUniqueId.equals(other$milestoneUniqueId)) {
            return false;
        }
        String this$milestoneCategory = this.getMilestoneCategory();
        String other$milestoneCategory = other.getMilestoneCategory();
        if (this$milestoneCategory == null ? other$milestoneCategory != null : !this$milestoneCategory.equals(other$milestoneCategory)) {
            return false;
        }
        String this$milestoneValue = this.getMilestoneValue();
        String other$milestoneValue = other.getMilestoneValue();
        return !(this$milestoneValue == null ? other$milestoneValue != null : !this$milestoneValue.equals(other$milestoneValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ViewerMilestoneEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EventUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $systemMessage = this.getSystemMessage();
        result = result * 59 + ($systemMessage == null ? 43 : $systemMessage.hashCode());
        String $milestoneUniqueId = this.getMilestoneUniqueId();
        result = result * 59 + ($milestoneUniqueId == null ? 43 : $milestoneUniqueId.hashCode());
        String $milestoneCategory = this.getMilestoneCategory();
        result = result * 59 + ($milestoneCategory == null ? 43 : $milestoneCategory.hashCode());
        String $milestoneValue = this.getMilestoneValue();
        result = result * 59 + ($milestoneValue == null ? 43 : $milestoneValue.hashCode());
        return result;
    }
}

