/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events;

import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.chat.TwitchChat;
import com.github.twitch4j.chat.enums.NoticeTag;
import com.github.twitch4j.chat.events.channel.BitsBadgeEarnedEvent;
import com.github.twitch4j.chat.events.channel.ChannelJoinEvent;
import com.github.twitch4j.chat.events.channel.ChannelLeaveEvent;
import com.github.twitch4j.chat.events.channel.ChannelMessageActionEvent;
import com.github.twitch4j.chat.events.channel.ChannelMessageEvent;
import com.github.twitch4j.chat.events.channel.ChannelModEvent;
import com.github.twitch4j.chat.events.channel.ChannelNoticeEvent;
import com.github.twitch4j.chat.events.channel.ChannelStateEvent;
import com.github.twitch4j.chat.events.channel.CharityDonationEvent;
import com.github.twitch4j.chat.events.channel.CheerEvent;
import com.github.twitch4j.chat.events.channel.ClearChatEvent;
import com.github.twitch4j.chat.events.channel.DeleteMessageEvent;
import com.github.twitch4j.chat.events.channel.DirectCheerEvent;
import com.github.twitch4j.chat.events.channel.ExtendSubscriptionEvent;
import com.github.twitch4j.chat.events.channel.GiftSubUpgradeEvent;
import com.github.twitch4j.chat.events.channel.GiftSubscriptionsEvent;
import com.github.twitch4j.chat.events.channel.GiftedMultiMonthSubCourtesyEvent;
import com.github.twitch4j.chat.events.channel.GlobalUserStateEvent;
import com.github.twitch4j.chat.events.channel.HostOffEvent;
import com.github.twitch4j.chat.events.channel.HostOnEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.chat.events.channel.InboundHostEvent;
import com.github.twitch4j.chat.events.channel.ListModsEvent;
import com.github.twitch4j.chat.events.channel.ListVipsEvent;
import com.github.twitch4j.chat.events.channel.MessageDeleteError;
import com.github.twitch4j.chat.events.channel.MessageDeleteSuccess;
import com.github.twitch4j.chat.events.channel.ModAnnouncementEvent;
import com.github.twitch4j.chat.events.channel.PayForwardEvent;
import com.github.twitch4j.chat.events.channel.PrimeGiftReceivedEvent;
import com.github.twitch4j.chat.events.channel.PrimeSubUpgradeEvent;
import com.github.twitch4j.chat.events.channel.RaidCancellationEvent;
import com.github.twitch4j.chat.events.channel.RaidEvent;
import com.github.twitch4j.chat.events.channel.RewardGiftEvent;
import com.github.twitch4j.chat.events.channel.RitualEvent;
import com.github.twitch4j.chat.events.channel.SubscriptionEvent;
import com.github.twitch4j.chat.events.channel.UserBanEvent;
import com.github.twitch4j.chat.events.channel.UserStateEvent;
import com.github.twitch4j.chat.events.channel.UserTimeoutEvent;
import com.github.twitch4j.chat.events.channel.ViewerMilestoneEvent;
import com.github.twitch4j.chat.events.roomstate.BroadcasterLanguageEvent;
import com.github.twitch4j.chat.events.roomstate.EmoteOnlyEvent;
import com.github.twitch4j.chat.events.roomstate.FollowersOnlyEvent;
import com.github.twitch4j.chat.events.roomstate.Robot9000Event;
import com.github.twitch4j.chat.events.roomstate.SlowModeEvent;
import com.github.twitch4j.chat.events.roomstate.SubscribersOnlyEvent;
import com.github.twitch4j.common.enums.AnnouncementColor;
import com.github.twitch4j.common.enums.SubscriptionPlan;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.events.user.PrivateMessageEvent;
import com.github.twitch4j.common.util.TwitchUtils;
import java.time.Month;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class IRCEventHandler {
    private static final Logger log = LoggerFactory.getLogger(IRCEventHandler.class);
    private final TwitchChat twitchChat;
    private final EventManager eventManager;

    @ApiStatus.Internal
    public IRCEventHandler(TwitchChat twitchChat) {
        this.twitchChat = twitchChat;
        this.eventManager = twitchChat.getEventManager();
        this.eventManager.onEvent("twitch4j-chat-event-trigger", IRCMessageEvent.class, this::handle);
    }

    private void handle(IRCMessageEvent e) {
        if (this.onChannelMessage(e)) {
            return;
        }
        if (this.onChannelCheer(e)) {
            return;
        }
        if (this.onChannelSubscription(e)) {
            return;
        }
        if (this.onWhisper(e)) {
            return;
        }
        if (this.onUserState(e)) {
            return;
        }
        if (this.onChannnelClientJoinEvent(e)) {
            return;
        }
        if (this.onChannnelClientLeaveEvent(e)) {
            return;
        }
        if (this.onClearChat(e)) {
            return;
        }
        if (this.onChannelState(e)) {
            return;
        }
        if (this.onClearMsg(e)) {
            return;
        }
        if (this.onAnnouncement(e)) {
            return;
        }
        if (this.onCharityDonation(e)) {
            return;
        }
        if (this.onGlobalUserState(e)) {
            return;
        }
        if (this.onNoticeEvent(e)) {
            return;
        }
        if (this.onViewerMilestone(e)) {
            return;
        }
        if (this.onRaid(e)) {
            return;
        }
        if (this.onNames(e)) {
            return;
        }
        if (this.onPayForward(e)) {
            return;
        }
        if (this.onBitsBadgeTier(e)) {
            return;
        }
        if (this.onRewardGift(e)) {
            return;
        }
        if (this.onChannelModChange(e)) {
            return;
        }
        if (this.onUnraid(e)) {
            return;
        }
        if (this.onGiftReceived(e)) {
            return;
        }
    }

    public boolean onAnnouncement(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && StringUtils.equalsIgnoreCase((CharSequence)"announcement", (CharSequence)event.getRawTag("msg-id"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String message = event.getMessage().orElse("");
            String color = event.getTagValue("msg-param-color").orElse(AnnouncementColor.PRIMARY.toString());
            this.eventManager.publish((Object)new ModAnnouncementEvent(event, channel, user, message, AnnouncementColor.parseColor((String)color)));
            return true;
        }
        return false;
    }

    public boolean onChannelMessage(IRCMessageEvent event) {
        if (event.getCommandType().equals("PRIVMSG") && event.getRawTag("bits") == null && event.getMessage().isPresent()) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String message = event.getMessage().get();
            if (message.startsWith("\u0001ACTION ") && message.endsWith("\u0001")) {
                this.eventManager.publish((Object)new ChannelMessageActionEvent(channel, event, user, message.substring(8, message.length() - 1)));
                return true;
            }
            this.eventManager.publish((Object)new ChannelMessageEvent(channel, event, user, message));
            return true;
        }
        return false;
    }

    public boolean onWhisper(IRCMessageEvent event) {
        if (event.getCommandType().equals("WHISPER")) {
            EventUser user = event.getUser();
            this.eventManager.publish((Object)new PrivateMessageEvent(user, event.getMessage().get(), event.getClientPermissions()));
            return true;
        }
        return false;
    }

    public boolean onBitsBadgeTier(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && StringUtils.equalsIgnoreCase((CharSequence)"bitsbadgetier", (CharSequence)event.getRawTag("msg-id"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String thresholdParam = event.getRawTagString("msg-param-threshold");
            int bitsThreshold = thresholdParam != null ? Integer.parseInt(thresholdParam) : -1;
            this.eventManager.publish((Object)new BitsBadgeEarnedEvent(channel, user, bitsThreshold));
            return true;
        }
        return false;
    }

    public boolean onChannelCheer(IRCMessageEvent event) {
        String rawBits;
        if (event.getCommandType().equals("PRIVMSG") && (rawBits = event.getRawTagString("bits")) != null) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String message = event.getMessage().orElse("");
            Integer bits = Integer.parseInt(rawBits);
            int subMonths = event.getSubscriberMonths().orElse(0);
            int subTier = event.getSubscriptionTier().orElse(0);
            this.eventManager.publish((Object)new CheerEvent(event, channel, user != null ? user : TwitchUtils.ANONYMOUS_CHEERER, message, bits, subMonths, subTier, event.getFlags()));
            return true;
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.17.0")
    public void onDirectCheer(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && StringUtils.equals((CharSequence)"midnightsquid", (CharSequence)event.getRawTag("msg-id"))) {
            this.eventManager.publish((Object)new DirectCheerEvent(event));
        }
    }

    public boolean onChannelSubscription(IRCMessageEvent event) {
        String msgId;
        if (event.getCommandType().equals("USERNOTICE") && (msgId = Objects.toString(event.getRawTag("msg-id"), null)) != null) {
            EventChannel channel = event.getChannel();
            if (msgId.equalsIgnoreCase("resub") && StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)event.getRawTag("msg-param-was-gifted"))) {
                this.eventManager.publish((Object)new GiftedMultiMonthSubCourtesyEvent(event));
                return true;
            }
            if (msgId.equalsIgnoreCase("sub") || msgId.equalsIgnoreCase("resub")) {
                EventUser user = event.getUser();
                String subPlan = event.getTagValue("msg-param-sub-plan").get();
                int cumulativeMonths = event.getTagValue("msg-param-cumulative-months").map(Integer::parseInt).orElse(0);
                if (cumulativeMonths == 0) {
                    cumulativeMonths = 1;
                }
                Integer streak = event.getTagValue("msg-param-streak-months").map(Integer::parseInt).orElse(0);
                Integer multiMonthDuration = Math.max(Integer.parseInt(event.getTagValue("msg-param-multimonth-duration").orElse("1")), 1);
                Integer multiMonthTenure = Integer.parseInt(event.getTagValue("msg-param-multimonth-tenure").orElse("0"));
                this.eventManager.publish((Object)new SubscriptionEvent(event, channel, user, subPlan, event.getMessage(), cumulativeMonths, false, null, streak, null, multiMonthDuration, multiMonthTenure, event.getFlags()));
                return true;
            }
            if (msgId.equalsIgnoreCase("subgift") || msgId.equalsIgnoreCase("anonsubgift")) {
                String giftMonthsParam;
                EventUser user = new EventUser(event.getTagValue("msg-param-recipient-id").get(), event.getTagValue("msg-param-recipient-user-name").get());
                EventUser giftedBy = event.getUser();
                String subPlan = event.getTagValue("msg-param-sub-plan").get();
                int subStreak = event.getTagValue("msg-param-months").map(Integer::parseInt).orElse(1);
                if (subStreak == 0) {
                    subStreak = 1;
                }
                int giftMonths = (giftMonthsParam = event.getRawTagString("msg-param-gift-months")) != null ? Integer.parseInt(giftMonthsParam) : 1;
                String multiTenureParam = event.getRawTagString("msg-param-multimonth-tenure");
                Integer multiMonthTenure = StringUtils.isEmpty((CharSequence)multiTenureParam) ? null : Integer.valueOf(Integer.parseInt(multiTenureParam));
                this.eventManager.publish((Object)new SubscriptionEvent(event, channel, user, subPlan, event.getMessage(), subStreak, true, giftedBy != null ? giftedBy : TwitchUtils.ANONYMOUS_GIFTER, 0, giftMonths, giftMonths, multiMonthTenure, event.getFlags()));
                return true;
            }
            if (msgId.equalsIgnoreCase("submysterygift") || msgId.equalsIgnoreCase("anonsubmysterygift")) {
                EventUser user = event.getUser();
                String subPlan = event.getTagValue("msg-param-sub-plan").get();
                Integer subsGifted = event.getTagValue("msg-param-mass-gift-count").map(Integer::parseInt).orElse(0);
                Integer subsGiftedTotal = event.getTagValue("msg-param-sender-count").map(Integer::parseInt).orElse(0);
                this.eventManager.publish((Object)new GiftSubscriptionsEvent(channel, user != null ? user : TwitchUtils.ANONYMOUS_GIFTER, subPlan, subsGifted, subsGiftedTotal));
                return true;
            }
            if (msgId.equalsIgnoreCase("giftpaidupgrade") || msgId.equalsIgnoreCase("anongiftpaidupgrade")) {
                EventUser user = event.getUser();
                String promoName = event.getTagValue("msg-param-promo-name").orElse(null);
                String giftTotalParam = event.getRawTagString("msg-param-promo-gift-total");
                Integer giftTotal = giftTotalParam != null ? Integer.valueOf(Integer.parseInt(giftTotalParam)) : null;
                String senderLogin = event.getTagValue("msg-param-sender-login").orElse(null);
                String senderName = event.getTagValue("msg-param-sender-name").orElse(null);
                this.eventManager.publish((Object)new GiftSubUpgradeEvent(channel, user, promoName, giftTotal, senderLogin, senderName));
                return true;
            }
            if (msgId.equalsIgnoreCase("primepaidupgrade")) {
                EventUser user = event.getUser();
                SubscriptionPlan subPlan = event.getTagValue("msg-param-sub-plan").map(SubscriptionPlan::fromString).orElse(null);
                this.eventManager.publish((Object)new PrimeSubUpgradeEvent(channel, user, subPlan));
                return true;
            }
            if (msgId.equalsIgnoreCase("extendsub")) {
                EventUser user = event.getUser();
                SubscriptionPlan subPlan = event.getTagValue("msg-param-sub-plan").map(SubscriptionPlan::fromString).orElse(null);
                String cumMonthsParam = event.getRawTagString("msg-param-cumulative-months");
                int cumulativeMonths = cumMonthsParam != null ? Math.max(Integer.parseInt(cumMonthsParam), 1) : 1;
                String endMonthParam = event.getRawTagString("msg-param-sub-benefit-end-month");
                Month endMonth = endMonthParam != null ? Month.of(Integer.parseInt(endMonthParam)) : null;
                this.eventManager.publish((Object)new ExtendSubscriptionEvent(channel, user, subPlan, cumulativeMonths, endMonth));
                return true;
            }
        }
        return false;
    }

    public boolean onGiftReceived(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && StringUtils.equalsIgnoreCase((CharSequence)"primecommunitygiftreceived", (CharSequence)event.getRawTag("msg-id"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String giftName = event.getTagValue("msg-param-gift-name").orElse(null);
            String recipientName = event.getTagValue("msg-param-recipient").orElse(null);
            this.eventManager.publish((Object)new PrimeGiftReceivedEvent(channel, user, giftName, recipientName));
            return true;
        }
        return false;
    }

    public boolean onPayForward(IRCMessageEvent event) {
        CharSequence msgId;
        if ("USERNOTICE".equals(event.getCommandType()) && (msgId = event.getRawTag("msg-id")) != null && (StringUtils.equalsIgnoreCase((CharSequence)msgId, (CharSequence)"standardpayforward") || StringUtils.equalsIgnoreCase((CharSequence)msgId, (CharSequence)"communitypayforward"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String gifterId = event.getTagValue("msg-param-prior-gifter-id").orElse(null);
            String gifterName = gifterId != null ? event.getTagValue("msg-param-prior-gifter-user-name").orElseGet(() -> event.getTagValue("msg-param-prior-gifter-display-name").orElse(null)) : null;
            EventUser gifter = gifterId != null ? new EventUser(gifterId, gifterName) : null;
            String recipientId = msgId.charAt(0) == 's' ? (String)event.getTagValue("msg-param-recipient-id").orElse(null) : null;
            String recipientName = recipientId != null ? event.getTagValue("msg-param-recipient-user-name").orElseGet(() -> event.getTagValue("msg-param-recipient-display-name").orElse(null)) : null;
            EventUser recipient = recipientId != null ? new EventUser(recipientId, recipientName) : null;
            this.eventManager.publish((Object)new PayForwardEvent(channel, user, gifter, recipient));
            return true;
        }
        return false;
    }

    public boolean onCharityDonation(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && StringUtils.equalsIgnoreCase((CharSequence)"charitydonation", (CharSequence)event.getRawTag("msg-id"))) {
            this.eventManager.publish((Object)new CharityDonationEvent(event));
            return true;
        }
        return false;
    }

    public boolean onRaid(IRCMessageEvent event) {
        if (event.getCommandType().equals("USERNOTICE") && StringUtils.equalsIgnoreCase((CharSequence)"raid", (CharSequence)event.getRawTag("msg-id"))) {
            Integer viewers;
            EventChannel channel = event.getChannel();
            EventUser raider = event.getUser();
            try {
                viewers = Integer.parseInt(event.getTagValue("msg-param-viewerCount").orElse("0"));
            }
            catch (NumberFormatException ex) {
                viewers = 0;
            }
            this.eventManager.publish((Object)new RaidEvent(channel, raider, viewers));
            return true;
        }
        return false;
    }

    public boolean onUnraid(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && StringUtils.equalsIgnoreCase((CharSequence)"unraid", (CharSequence)event.getRawTag("msg-id"))) {
            this.eventManager.publish((Object)new RaidCancellationEvent(event.getChannel()));
            return true;
        }
        return false;
    }

    public boolean onRewardGift(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && StringUtils.equalsIgnoreCase((CharSequence)"rewardgift", (CharSequence)event.getRawTag("msg-id"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String domain = event.getTagValue("msg-param-domain").orElse(null);
            String triggerType = event.getTagValue("msg-param-trigger-type").orElse(null);
            String selectedCountParam = event.getRawTagString("msg-param-selected-count");
            Integer selectedCount = selectedCountParam != null ? Integer.valueOf(Integer.parseInt(selectedCountParam)) : null;
            String totalRewardCountParam = event.getRawTagString("msg-param-total-reward-count");
            Integer totalRewardCount = totalRewardCountParam != null ? Integer.valueOf(Integer.parseInt(totalRewardCountParam)) : null;
            String triggerAmountParam = event.getRawTagString("msg-param-trigger-amount");
            Integer triggerAmount = triggerAmountParam != null ? Integer.valueOf(Integer.parseInt(triggerAmountParam)) : null;
            this.eventManager.publish((Object)new RewardGiftEvent(channel, user, domain, triggerType, selectedCount, totalRewardCount, triggerAmount));
            return true;
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.17.0")
    public void onRitual(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && StringUtils.equalsIgnoreCase((CharSequence)"ritual", (CharSequence)event.getRawTag("msg-id"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String ritualName = event.getTagValue("msg-param-ritual-name").orElse(null);
            this.eventManager.publish((Object)new RitualEvent(channel, user, ritualName));
        }
    }

    public boolean onClearChat(IRCMessageEvent event) {
        if (event.getCommandType().equals("CLEARCHAT")) {
            EventChannel channel = event.getChannel();
            if (event.getRawTag("target-user-id") != null) {
                if (event.getRawTag("ban-duration") != null) {
                    EventUser user = event.getTargetUser();
                    Integer duration = Integer.parseInt(event.getTagValue("ban-duration").get());
                    String banReason = event.getTagValue("ban-reason").orElse("");
                    banReason = banReason.replaceAll("\\\\s", " ");
                    UserTimeoutEvent timeoutEvent = new UserTimeoutEvent(channel, user, duration, banReason);
                    this.eventManager.publish((Object)timeoutEvent);
                    return true;
                }
                EventUser user = event.getTargetUser();
                String banReason = event.getTagValue("ban-reason").orElse("");
                banReason = banReason.replaceAll("\\\\s", " ");
                UserBanEvent banEvent = new UserBanEvent(channel, user, banReason);
                this.eventManager.publish((Object)banEvent);
                return true;
            }
            this.eventManager.publish((Object)new ClearChatEvent(channel));
            return true;
        }
        return false;
    }

    public boolean onClearMsg(IRCMessageEvent event) {
        if ("CLEARMSG".equals(event.getCommandType())) {
            EventChannel channel = event.getChannel();
            String userName = event.getUserName();
            String msgId = event.getTagValue("target-msg-id").orElse(null);
            String message = event.getMessage().orElse("");
            boolean wasActionMessage = message.startsWith("\u0001ACTION ") && message.endsWith("\u0001");
            String trimmedMsg = wasActionMessage ? message.substring("\u0001ACTION ".length(), message.length() - "\u0001".length()) : message;
            this.eventManager.publish((Object)new DeleteMessageEvent(channel, userName, msgId, trimmedMsg, wasActionMessage));
            return true;
        }
        return false;
    }

    public boolean onNames(IRCMessageEvent event) {
        if ("353".equals(event.getCommandType()) && event.getChannelName().isPresent() && event.getClientName().isPresent()) {
            EventChannel channel = event.getChannel();
            event.getMessage().map(String::trim).map(names -> StringUtils.split((String)names, (char)' ')).ifPresent(names -> Arrays.stream(names).map(String::trim).filter(StringUtils::isNotEmpty).map(login -> new EventUser(null, login)).forEach(user -> this.eventManager.publish((Object)new ChannelJoinEvent(channel, (EventUser)user))));
            return true;
        }
        return false;
    }

    public boolean onChannnelClientJoinEvent(IRCMessageEvent event) {
        if (event.getCommandType().equals("JOIN") && event.getChannelName().isPresent() && event.getClientName().isPresent()) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            if (channel != null && user != null) {
                this.eventManager.publish((Object)new ChannelJoinEvent(channel, user));
                return true;
            }
        }
        return false;
    }

    public boolean onChannnelClientLeaveEvent(IRCMessageEvent event) {
        if (event.getCommandType().equals("PART") && event.getChannelName().isPresent() && event.getClientName().isPresent()) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            if (channel != null && user != null) {
                this.eventManager.publish((Object)new ChannelLeaveEvent(channel, user));
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.17.0")
    public boolean onChannelModChange(IRCMessageEvent event) {
        if (event.getCommandType().equals("MODE") && event.getPayload().isPresent() && event.getPayload().get().substring(1).startsWith("o")) {
            EventChannel channel = event.getChannel();
            EventUser user = new EventUser(null, event.getPayload().get().substring(3));
            this.eventManager.publish((Object)new ChannelModEvent(channel, user, event.getPayload().get().startsWith("+")));
            return true;
        }
        return false;
    }

    public boolean onNoticeEvent(IRCMessageEvent event) {
        if (event.getCommandType().equals("NOTICE")) {
            EventChannel channel = event.getChannel();
            String messageId = event.getTagValue("msg-id").get();
            String message = event.getMessage().orElse(null);
            this.eventManager.publish((Object)new ChannelNoticeEvent(channel, messageId, message));
            return true;
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.17.0")
    public void onHostOnEvent(IRCMessageEvent event) {
        if (event.getCommandType().equals("NOTICE")) {
            EventChannel channel = event.getChannel();
            String messageId = event.getTagValue("msg-id").get();
            if (messageId.equals(NoticeTag.HOST_ON.toString())) {
                String message = event.getMessage().get();
                String targetChannelName = message.substring(12, message.length() - 1);
                EventChannel targetChannel = new EventChannel(null, targetChannelName);
                this.eventManager.publish((Object)new HostOnEvent(channel, targetChannel));
            }
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.17.0")
    public void onHostOffEvent(IRCMessageEvent event) {
        if (event.getCommandType().equals("NOTICE")) {
            EventChannel channel = event.getChannel();
            String messageId = event.getTagValue("msg-id").get();
            if (messageId.equals(NoticeTag.HOST_OFF.toString())) {
                this.eventManager.publish((Object)new HostOffEvent(channel));
            }
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.17.0")
    public void onInboundHostEvent(IRCMessageEvent event) {
        if ("PRIVMSG".equals(event.getCommandType()) && "jtv".equals(event.getClientName().orElse(null)) && event.getChannelName().isPresent() && event.getRawTags().isEmpty()) {
            String hostMessage = " is now hosting you";
            event.getMessage().map(msg -> msg.indexOf(" is now hosting you")).filter(index -> index > 0).map(index -> event.getMessage().get().substring(0, (int)index)).map(String::trim).ifPresent(hostName -> this.eventManager.publish((Object)new InboundHostEvent(event.getChannelName().get(), (String)hostName)));
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.17.0")
    public void onListModsEvent(IRCMessageEvent event) {
        if ("NOTICE".equals(event.getCommandType()) && event.getTagValue("msg-id").filter(s -> s.equals(NoticeTag.ROOM_MODS.toString()) || s.equals(NoticeTag.NO_MODS.toString())).isPresent()) {
            List<String> names = IRCEventHandler.extractItemsFromDelimitedList(event.getMessage(), "The moderators of this channel are: ", ", ");
            this.eventManager.publish((Object)new ListModsEvent(event.getChannel(), names));
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.17.0")
    public void onListVipsEvent(IRCMessageEvent event) {
        if ("NOTICE".equals(event.getCommandType()) && event.getTagValue("msg-id").filter(s -> s.equals(NoticeTag.VIPS_SUCCESS.toString()) || s.equals(NoticeTag.NO_VIPS.toString())).isPresent()) {
            List<String> names = IRCEventHandler.extractItemsFromDelimitedList(event.getMessage(), "The VIPs of this channel are: ", ", ");
            this.eventManager.publish((Object)new ListVipsEvent(event.getChannel(), names));
        }
    }

    public boolean onChannelState(IRCMessageEvent event) {
        if (event.getCommandType().equals("ROOMSTATE")) {
            EventChannel channel = event.getChannel();
            HashMap<ChannelStateEvent.ChannelState, Object> states = new HashMap<ChannelStateEvent.ChannelState, Object>();
            if (event.getEscapedTags().size() > 2) {
                event.getEscapedTags().forEach((k, v) -> {
                    switch (k) {
                        case "broadcaster-lang": {
                            Locale locale = v != null ? Locale.forLanguageTag(v.toString()) : null;
                            states.put(ChannelStateEvent.ChannelState.BROADCAST_LANG, locale);
                            this.eventManager.publish((Object)new BroadcasterLanguageEvent(channel, locale));
                            break;
                        }
                        case "emote-only": {
                            boolean eoActive = StringUtils.equals((CharSequence)"1", (CharSequence)v);
                            states.put(ChannelStateEvent.ChannelState.EMOTE, eoActive);
                            this.eventManager.publish((Object)new EmoteOnlyEvent(channel, eoActive));
                            break;
                        }
                        case "followers-only": {
                            long followDelay = Long.parseLong(v.toString());
                            states.put(ChannelStateEvent.ChannelState.FOLLOWERS, followDelay);
                            this.eventManager.publish((Object)new FollowersOnlyEvent(channel, followDelay));
                            break;
                        }
                        case "r9k": {
                            boolean uniqActive = StringUtils.equals((CharSequence)"1", (CharSequence)v);
                            states.put(ChannelStateEvent.ChannelState.R9K, uniqActive);
                            this.eventManager.publish((Object)new Robot9000Event(channel, uniqActive));
                            break;
                        }
                        case "rituals": {
                            boolean ritualsActive = StringUtils.equals((CharSequence)"1", (CharSequence)v);
                            states.put(ChannelStateEvent.ChannelState.RITUALS, ritualsActive);
                            break;
                        }
                        case "slow": {
                            long slowDelay = Long.parseLong(v.toString());
                            states.put(ChannelStateEvent.ChannelState.SLOW, slowDelay);
                            this.eventManager.publish((Object)new SlowModeEvent(channel, slowDelay));
                            break;
                        }
                        case "subs-only": {
                            boolean subActive = StringUtils.equals((CharSequence)"1", (CharSequence)v);
                            states.put(ChannelStateEvent.ChannelState.SUBSCRIBERS, subActive);
                            this.eventManager.publish((Object)new SubscribersOnlyEvent(channel, subActive));
                            break;
                        }
                    }
                });
            }
            this.eventManager.publish((Object)new ChannelStateEvent(channel, states));
            return true;
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.17.0")
    public void onMessageDeleteResponse(IRCMessageEvent event) {
        if (event.getCommandType().equals("NOTICE")) {
            EventChannel channel = event.getChannel();
            String messageId = event.getTagValue("msg-id").orElse(null);
            NoticeTag tag = NoticeTag.parse(messageId);
            if (tag == NoticeTag.DELETE_MESSAGE_SUCCESS) {
                this.eventManager.publish((Object)new MessageDeleteSuccess(channel));
            } else if (tag == NoticeTag.BAD_DELETE_MESSAGE_ERROR || tag == NoticeTag.BAD_DELETE_MESSAGE_BROADCASTER || tag == NoticeTag.BAD_DELETE_MESSAGE_MOD) {
                this.eventManager.publish((Object)new MessageDeleteError(channel));
                log.warn("Failed to delete a message in {}!", (Object)channel.getName());
            }
        }
    }

    public boolean onUserState(IRCMessageEvent event) {
        if (event.getCommandType().equals("USERSTATE")) {
            this.eventManager.publish((Object)new UserStateEvent(event));
            return true;
        }
        return false;
    }

    public boolean onGlobalUserState(IRCMessageEvent event) {
        if ("GLOBALUSERSTATE".equals(event.getCommandType())) {
            this.eventManager.publish((Object)new GlobalUserStateEvent(event));
            return true;
        }
        return false;
    }

    private boolean onViewerMilestone(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && StringUtils.equals((CharSequence)"viewermilestone", (CharSequence)event.getRawTag("msg-id"))) {
            this.eventManager.publish((Object)new ViewerMilestoneEvent(event));
            return true;
        }
        return false;
    }

    @NonNull
    private static List<String> extractItemsFromDelimitedList(@NonNull Optional<String> message, @NonNull String prefix, @NonNull String delim) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (delim == null) {
            throw new NullPointerException("delim is marked non-null but is null");
        }
        return message.filter(s -> s.startsWith(prefix)).map(s -> s.substring(prefix.length())).map(s -> s.charAt(s.length() - 1) == '.' ? s.substring(0, s.length() - 1) : s).map(s -> StringUtils.split((String)s, (String)delim)).map(Arrays::asList).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    public TwitchChat getTwitchChat() {
        return this.twitchChat;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }
}

