/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.AbstractChannelEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.common.enums.SubscriptionPlan;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.util.TwitchUtils;

public final class GiftedMultiMonthSubCourtesyEvent
extends AbstractChannelEvent {
    private final IRCMessageEvent messageEvent;
    private final EventUser user;
    private final String message;
    private final SubscriptionPlan subscriptionPlan;
    private final boolean wasAnonymous;
    private final EventUser gifter;
    private final Integer giftMonths;
    private final Integer redeemedMonth;
    private final Integer cumulativeMonths;

    public GiftedMultiMonthSubCourtesyEvent(IRCMessageEvent event) {
        super(event.getChannel());
        this.messageEvent = event;
        this.user = event.getUser();
        this.message = event.getMessage().orElse(null);
        this.subscriptionPlan = SubscriptionPlan.fromString((String)event.getTags().getOrDefault("msg-param-sub-plan", "1000"));
        this.wasAnonymous = "true".equalsIgnoreCase(event.getTags().get("msg-param-anon-gift"));
        this.gifter = this.wasAnonymous ? TwitchUtils.ANONYMOUS_GIFTER : new EventUser(event.getTags().get("msg-param-gifter-id"), event.getTagValue("msg-param-gifter-login").orElse(event.getTagValue("msg-param-gifter-name").orElse(null)));
        this.giftMonths = Integer.parseInt(event.getTags().getOrDefault("msg-param-gift-months", "0"));
        this.redeemedMonth = Integer.parseInt(event.getTags().getOrDefault("msg-param-gift-month-being-redeemed", "0"));
        this.cumulativeMonths = Integer.parseInt(event.getTags().getOrDefault("msg-param-cumulative-months", "0"));
    }

    public IRCMessageEvent getMessageEvent() {
        return this.messageEvent;
    }

    public EventUser getUser() {
        return this.user;
    }

    public String getMessage() {
        return this.message;
    }

    public SubscriptionPlan getSubscriptionPlan() {
        return this.subscriptionPlan;
    }

    public boolean isWasAnonymous() {
        return this.wasAnonymous;
    }

    public EventUser getGifter() {
        return this.gifter;
    }

    public Integer getGiftMonths() {
        return this.giftMonths;
    }

    public Integer getRedeemedMonth() {
        return this.redeemedMonth;
    }

    public Integer getCumulativeMonths() {
        return this.cumulativeMonths;
    }

    @Override
    public String toString() {
        return "GiftedMultiMonthSubCourtesyEvent(messageEvent=" + (Object)((Object)this.getMessageEvent()) + ", user=" + this.getUser() + ", message=" + this.getMessage() + ", subscriptionPlan=" + this.getSubscriptionPlan() + ", wasAnonymous=" + this.isWasAnonymous() + ", gifter=" + this.getGifter() + ", giftMonths=" + this.getGiftMonths() + ", redeemedMonth=" + this.getRedeemedMonth() + ", cumulativeMonths=" + this.getCumulativeMonths() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GiftedMultiMonthSubCourtesyEvent)) {
            return false;
        }
        GiftedMultiMonthSubCourtesyEvent other = (GiftedMultiMonthSubCourtesyEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isWasAnonymous() != other.isWasAnonymous()) {
            return false;
        }
        Integer this$giftMonths = this.getGiftMonths();
        Integer other$giftMonths = other.getGiftMonths();
        if (this$giftMonths == null ? other$giftMonths != null : !((Object)this$giftMonths).equals(other$giftMonths)) {
            return false;
        }
        Integer this$redeemedMonth = this.getRedeemedMonth();
        Integer other$redeemedMonth = other.getRedeemedMonth();
        if (this$redeemedMonth == null ? other$redeemedMonth != null : !((Object)this$redeemedMonth).equals(other$redeemedMonth)) {
            return false;
        }
        Integer this$cumulativeMonths = this.getCumulativeMonths();
        Integer other$cumulativeMonths = other.getCumulativeMonths();
        if (this$cumulativeMonths == null ? other$cumulativeMonths != null : !((Object)this$cumulativeMonths).equals(other$cumulativeMonths)) {
            return false;
        }
        IRCMessageEvent this$messageEvent = this.getMessageEvent();
        IRCMessageEvent other$messageEvent = other.getMessageEvent();
        if (this$messageEvent == null ? other$messageEvent != null : !((Object)((Object)this$messageEvent)).equals((Object)other$messageEvent)) {
            return false;
        }
        EventUser this$user = this.getUser();
        EventUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        SubscriptionPlan this$subscriptionPlan = this.getSubscriptionPlan();
        SubscriptionPlan other$subscriptionPlan = other.getSubscriptionPlan();
        if (this$subscriptionPlan == null ? other$subscriptionPlan != null : !this$subscriptionPlan.equals(other$subscriptionPlan)) {
            return false;
        }
        EventUser this$gifter = this.getGifter();
        EventUser other$gifter = other.getGifter();
        return !(this$gifter == null ? other$gifter != null : !this$gifter.equals(other$gifter));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GiftedMultiMonthSubCourtesyEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWasAnonymous() ? 79 : 97);
        Integer $giftMonths = this.getGiftMonths();
        result = result * 59 + ($giftMonths == null ? 43 : ((Object)$giftMonths).hashCode());
        Integer $redeemedMonth = this.getRedeemedMonth();
        result = result * 59 + ($redeemedMonth == null ? 43 : ((Object)$redeemedMonth).hashCode());
        Integer $cumulativeMonths = this.getCumulativeMonths();
        result = result * 59 + ($cumulativeMonths == null ? 43 : ((Object)$cumulativeMonths).hashCode());
        IRCMessageEvent $messageEvent = this.getMessageEvent();
        result = result * 59 + ($messageEvent == null ? 43 : ((Object)((Object)$messageEvent)).hashCode());
        EventUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        SubscriptionPlan $subscriptionPlan = this.getSubscriptionPlan();
        result = result * 59 + ($subscriptionPlan == null ? 43 : $subscriptionPlan.hashCode());
        EventUser $gifter = this.getGifter();
        result = result * 59 + ($gifter == null ? 43 : $gifter.hashCode());
        return result;
    }
}

