/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.channel.CheerEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.common.util.DonationAmount;
import java.math.BigDecimal;
import java.util.Currency;

public final class DirectCheerEvent
extends CheerEvent {
    private static final float CREATOR_REVENUE_SPLIT = 0.8f;
    private final DonationAmount cheer;

    public DirectCheerEvent(IRCMessageEvent event) {
        this(event, event.getTagValue("msg-param-amount").map(Long::parseLong).orElse(0L), event.getTagValue("msg-param-exponent").map(Integer::parseInt).orElse(2), event.getTagValue("msg-param-currency").orElse("USD"));
    }

    DirectCheerEvent(IRCMessageEvent event, long amount, int exponent, String currency) {
        super(event, event.getChannel(), event.getUser(), event.getMessage().orElse(""), "USD".equalsIgnoreCase(currency) ? Math.round((float)amount * 0.8f) : 0, event.getSubscriberMonths().orElse(0), event.getSubscriptionTier().orElse(0), event.getFlags());
        this.cheer = new DonationAmount(Long.valueOf(amount), Integer.valueOf(exponent), currency);
    }

    public Integer getAmount() {
        return this.cheer.getValue().intValue();
    }

    public Currency getCurrency() {
        return this.cheer.getParsedCurrency();
    }

    public BigDecimal getMonetaryValue() {
        return this.cheer.getParsedValue();
    }

    public String getSystemMessage() {
        return this.messageEvent.getTagValue("system-msg").map(String::trim).orElse("");
    }

    @Override
    @Deprecated
    public Integer getBits() {
        return super.getBits();
    }

    public DonationAmount getCheer() {
        return this.cheer;
    }

    @Override
    public String toString() {
        return "DirectCheerEvent(cheer=" + this.getCheer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DirectCheerEvent)) {
            return false;
        }
        DirectCheerEvent other = (DirectCheerEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DonationAmount this$cheer = this.getCheer();
        DonationAmount other$cheer = other.getCheer();
        return !(this$cheer == null ? other$cheer != null : !this$cheer.equals(other$cheer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DirectCheerEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DonationAmount $cheer = this.getCheer();
        result = result * 59 + ($cheer == null ? 43 : $cheer.hashCode());
        return result;
    }
}

