/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events;

import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.chat.TwitchChat;
import com.github.twitch4j.chat.enums.AnnouncementColor;
import com.github.twitch4j.chat.enums.NoticeTag;
import com.github.twitch4j.chat.events.channel.BitsBadgeEarnedEvent;
import com.github.twitch4j.chat.events.channel.ChannelJoinEvent;
import com.github.twitch4j.chat.events.channel.ChannelLeaveEvent;
import com.github.twitch4j.chat.events.channel.ChannelMessageActionEvent;
import com.github.twitch4j.chat.events.channel.ChannelMessageEvent;
import com.github.twitch4j.chat.events.channel.ChannelModEvent;
import com.github.twitch4j.chat.events.channel.ChannelNoticeEvent;
import com.github.twitch4j.chat.events.channel.ChannelStateEvent;
import com.github.twitch4j.chat.events.channel.CharityDonationEvent;
import com.github.twitch4j.chat.events.channel.CheerEvent;
import com.github.twitch4j.chat.events.channel.ClearChatEvent;
import com.github.twitch4j.chat.events.channel.DeleteMessageEvent;
import com.github.twitch4j.chat.events.channel.DirectCheerEvent;
import com.github.twitch4j.chat.events.channel.ExtendSubscriptionEvent;
import com.github.twitch4j.chat.events.channel.GiftSubUpgradeEvent;
import com.github.twitch4j.chat.events.channel.GiftSubscriptionsEvent;
import com.github.twitch4j.chat.events.channel.GiftedMultiMonthSubCourtesyEvent;
import com.github.twitch4j.chat.events.channel.GlobalUserStateEvent;
import com.github.twitch4j.chat.events.channel.HostOffEvent;
import com.github.twitch4j.chat.events.channel.HostOnEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.chat.events.channel.InboundHostEvent;
import com.github.twitch4j.chat.events.channel.ListModsEvent;
import com.github.twitch4j.chat.events.channel.ListVipsEvent;
import com.github.twitch4j.chat.events.channel.MessageDeleteError;
import com.github.twitch4j.chat.events.channel.MessageDeleteSuccess;
import com.github.twitch4j.chat.events.channel.ModAnnouncementEvent;
import com.github.twitch4j.chat.events.channel.PayForwardEvent;
import com.github.twitch4j.chat.events.channel.PrimeGiftReceivedEvent;
import com.github.twitch4j.chat.events.channel.PrimeSubUpgradeEvent;
import com.github.twitch4j.chat.events.channel.RaidCancellationEvent;
import com.github.twitch4j.chat.events.channel.RaidEvent;
import com.github.twitch4j.chat.events.channel.RewardGiftEvent;
import com.github.twitch4j.chat.events.channel.RitualEvent;
import com.github.twitch4j.chat.events.channel.SubscriptionEvent;
import com.github.twitch4j.chat.events.channel.UserBanEvent;
import com.github.twitch4j.chat.events.channel.UserStateEvent;
import com.github.twitch4j.chat.events.channel.UserTimeoutEvent;
import com.github.twitch4j.chat.events.roomstate.BroadcasterLanguageEvent;
import com.github.twitch4j.chat.events.roomstate.EmoteOnlyEvent;
import com.github.twitch4j.chat.events.roomstate.FollowersOnlyEvent;
import com.github.twitch4j.chat.events.roomstate.Robot9000Event;
import com.github.twitch4j.chat.events.roomstate.SlowModeEvent;
import com.github.twitch4j.chat.events.roomstate.SubscribersOnlyEvent;
import com.github.twitch4j.common.enums.SubscriptionPlan;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.events.user.PrivateMessageEvent;
import com.github.twitch4j.common.util.TwitchUtils;
import java.time.Month;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRCEventHandler {
    private static final Logger log = LoggerFactory.getLogger(IRCEventHandler.class);
    private final TwitchChat twitchChat;
    private final EventManager eventManager;

    public IRCEventHandler(TwitchChat twitchChat) {
        this.twitchChat = twitchChat;
        this.eventManager = twitchChat.getEventManager();
        this.eventManager.onEvent("twitch4j-chat-message-trigger", IRCMessageEvent.class, this::onChannelMessage);
        this.eventManager.onEvent("twitch4j-chat-whisper-trigger", IRCMessageEvent.class, this::onWhisper);
        this.eventManager.onEvent("twitch4j-chat-announcement-trigger", IRCMessageEvent.class, this::onAnnouncement);
        this.eventManager.onEvent("twitch4j-chat-bits-badge-trigger", IRCMessageEvent.class, this::onBitsBadgeTier);
        this.eventManager.onEvent("twitch4j-chat-cheer-trigger", IRCMessageEvent.class, this::onChannelCheer);
        this.eventManager.onEvent("twitch4j-chat-direct-cheer-trigger", IRCMessageEvent.class, this::onDirectCheer);
        this.eventManager.onEvent("twitch4j-chat-sub-trigger", IRCMessageEvent.class, this::onChannelSubscription);
        this.eventManager.onEvent("twitch4j-chat-clearchat-trigger", IRCMessageEvent.class, this::onClearChat);
        this.eventManager.onEvent("twitch4j-chat-clearmsg-trigger", IRCMessageEvent.class, this::onClearMsg);
        this.eventManager.onEvent("twitch4j-chat-join-trigger", IRCMessageEvent.class, this::onChannnelClientJoinEvent);
        this.eventManager.onEvent("twitch4j-chat-leave-trigger", IRCMessageEvent.class, this::onChannnelClientLeaveEvent);
        this.eventManager.onEvent("twitch4j-chat-mod-trigger", IRCMessageEvent.class, this::onChannelModChange);
        this.eventManager.onEvent("twitch4j-chat-notice-trigger", IRCMessageEvent.class, this::onNoticeEvent);
        this.eventManager.onEvent("twitch4j-chat-host-on-trigger", IRCMessageEvent.class, this::onHostOnEvent);
        this.eventManager.onEvent("twitch4j-chat-host-off-trigger", IRCMessageEvent.class, this::onHostOffEvent);
        this.eventManager.onEvent("twitch4j-chat-inbound-host-trigger", IRCMessageEvent.class, this::onInboundHostEvent);
        this.eventManager.onEvent("twitch4j-chat-list-mods-trigger", IRCMessageEvent.class, this::onListModsEvent);
        this.eventManager.onEvent("twitch4j-chat-list-vips-trigger", IRCMessageEvent.class, this::onListVipsEvent);
        this.eventManager.onEvent("twitch4j-chat-roomstate-trigger", IRCMessageEvent.class, this::onChannelState);
        this.eventManager.onEvent("twitch4j-chat-gift-trigger", IRCMessageEvent.class, this::onGiftReceived);
        this.eventManager.onEvent("twitch4j-chat-payforward-trigger", IRCMessageEvent.class, this::onPayForward);
        this.eventManager.onEvent("twitch4j-chat-charity-trigger", IRCMessageEvent.class, this::onCharityDonation);
        this.eventManager.onEvent("twitch4j-chat-raid-trigger", IRCMessageEvent.class, this::onRaid);
        this.eventManager.onEvent("twitch4j-chat-unraid-trigger", IRCMessageEvent.class, this::onUnraid);
        this.eventManager.onEvent("twitch4j-chat-rewardgift-trigger", IRCMessageEvent.class, this::onRewardGift);
        this.eventManager.onEvent("twitch4j-chat-delete-trigger", IRCMessageEvent.class, this::onMessageDeleteResponse);
        this.eventManager.onEvent("twitch4j-chat-userstate-trigger", IRCMessageEvent.class, this::onUserState);
        this.eventManager.onEvent("twitch4j-chat-globaluserstate-trigger", IRCMessageEvent.class, this::onGlobalUserState);
    }

    public void onAnnouncement(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && "announcement".equalsIgnoreCase(event.getTags().get("msg-id"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String message = event.getMessage().orElse("");
            String color = event.getTagValue("msg-param-color").orElse(AnnouncementColor.PRIMARY.toString());
            this.eventManager.publish((Object)new ModAnnouncementEvent(event, channel, user, message, AnnouncementColor.parseColor(color)));
        }
    }

    public void onChannelMessage(IRCMessageEvent event) {
        if (event.getCommandType().equals("PRIVMSG") && !event.getTags().containsKey("bits") && event.getMessage().isPresent()) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String message = event.getMessage().get();
            if (message.startsWith("\u0001ACTION ") && message.endsWith("\u0001")) {
                this.eventManager.publish((Object)new ChannelMessageActionEvent(channel, event, user, message.substring(8, message.length() - 1), event.getClientPermissions()));
            } else {
                this.eventManager.publish((Object)new ChannelMessageEvent(channel, event, user, message, event.getClientPermissions()));
            }
        }
    }

    public void onWhisper(IRCMessageEvent event) {
        if (event.getCommandType().equals("WHISPER")) {
            EventUser user = event.getUser();
            this.eventManager.publish((Object)new PrivateMessageEvent(user, event.getMessage().get(), event.getClientPermissions()));
        }
    }

    public void onBitsBadgeTier(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && "bitsbadgetier".equalsIgnoreCase(event.getTags().get("msg-id"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String thresholdParam = event.getTags().get("msg-param-threshold");
            int bitsThreshold = thresholdParam != null ? Integer.parseInt(thresholdParam) : -1;
            this.eventManager.publish((Object)new BitsBadgeEarnedEvent(channel, user, bitsThreshold));
        }
    }

    public void onChannelCheer(IRCMessageEvent event) {
        if (event.getCommandType().equals("PRIVMSG") && event.getTags().containsKey("bits")) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String message = event.getMessage().orElse("");
            Integer bits = Integer.parseInt(event.getTags().get("bits"));
            int subMonths = event.getSubscriberMonths().orElse(0);
            int subTier = event.getSubscriptionTier().orElse(0);
            this.eventManager.publish((Object)new CheerEvent(event, channel, user != null ? user : TwitchUtils.ANONYMOUS_CHEERER, message, bits, subMonths, subTier, event.getFlags()));
        }
    }

    public void onDirectCheer(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && "midnightsquid".equals(event.getTags().get("msg-id"))) {
            this.eventManager.publish((Object)new DirectCheerEvent(event));
        }
    }

    public void onChannelSubscription(IRCMessageEvent event) {
        String msgId;
        if (event.getCommandType().equals("USERNOTICE") && (msgId = event.getTags().get("msg-id")) != null) {
            EventChannel channel = event.getChannel();
            if (msgId.equalsIgnoreCase("resub") && "true".equalsIgnoreCase(event.getTags().get("msg-param-was-gifted"))) {
                this.eventManager.publish((Object)new GiftedMultiMonthSubCourtesyEvent(event));
            } else if (msgId.equalsIgnoreCase("sub") || msgId.equalsIgnoreCase("resub")) {
                int cumulativeMonths;
                EventUser user = event.getUser();
                String subPlan = event.getTagValue("msg-param-sub-plan").get();
                int n = cumulativeMonths = event.getTags().containsKey("msg-param-cumulative-months") ? Integer.parseInt(event.getTags().get("msg-param-cumulative-months")) : 0;
                if (cumulativeMonths == 0) {
                    cumulativeMonths = 1;
                }
                Integer streak = event.getTags().containsKey("msg-param-streak-months") ? Integer.parseInt(event.getTags().get("msg-param-streak-months")) : 0;
                Integer multiMonthDuration = Math.max(Integer.parseInt(event.getTags().getOrDefault("msg-param-multimonth-duration", "1")), 1);
                Integer multiMonthTenure = Integer.parseInt(event.getTags().getOrDefault("msg-param-multimonth-tenure", "0"));
                this.eventManager.publish((Object)new SubscriptionEvent(event, channel, user, subPlan, event.getMessage(), cumulativeMonths, false, null, streak, null, multiMonthDuration, multiMonthTenure, event.getFlags()));
            } else if (msgId.equalsIgnoreCase("subgift") || msgId.equalsIgnoreCase("anonsubgift")) {
                String giftMonthsParam;
                int subStreak;
                EventUser user = new EventUser(event.getTagValue("msg-param-recipient-id").get(), event.getTagValue("msg-param-recipient-user-name").get());
                EventUser giftedBy = event.getUser();
                String subPlan = event.getTagValue("msg-param-sub-plan").get();
                int n = subStreak = event.getTags().containsKey("msg-param-months") ? Integer.parseInt(event.getTags().get("msg-param-months")) : 1;
                if (subStreak == 0) {
                    subStreak = 1;
                }
                int giftMonths = (giftMonthsParam = event.getTags().get("msg-param-gift-months")) != null ? Integer.parseInt(giftMonthsParam) : 1;
                String multiTenureParam = event.getTags().get("msg-param-multimonth-tenure");
                Integer multiMonthTenure = StringUtils.isEmpty((CharSequence)multiTenureParam) ? null : Integer.valueOf(Integer.parseInt(multiTenureParam));
                this.eventManager.publish((Object)new SubscriptionEvent(event, channel, user, subPlan, event.getMessage(), subStreak, true, giftedBy != null ? giftedBy : TwitchUtils.ANONYMOUS_GIFTER, 0, giftMonths, giftMonths, multiMonthTenure, event.getFlags()));
            } else if (msgId.equalsIgnoreCase("submysterygift") || msgId.equalsIgnoreCase("anonsubmysterygift")) {
                EventUser user = event.getUser();
                String subPlan = event.getTagValue("msg-param-sub-plan").get();
                Integer subsGifted = event.getTags().containsKey("msg-param-mass-gift-count") ? Integer.parseInt(event.getTags().get("msg-param-mass-gift-count")) : 0;
                Integer subsGiftedTotal = event.getTags().containsKey("msg-param-sender-count") ? Integer.parseInt(event.getTags().get("msg-param-sender-count")) : 0;
                this.eventManager.publish((Object)new GiftSubscriptionsEvent(channel, user != null ? user : TwitchUtils.ANONYMOUS_GIFTER, subPlan, subsGifted, subsGiftedTotal));
            } else if (msgId.equalsIgnoreCase("giftpaidupgrade") || msgId.equalsIgnoreCase("anongiftpaidupgrade")) {
                EventUser user = event.getUser();
                String promoName = event.getTagValue("msg-param-promo-name").orElse(null);
                String giftTotalParam = event.getTags().get("msg-param-promo-gift-total");
                Integer giftTotal = giftTotalParam != null ? Integer.valueOf(Integer.parseInt(giftTotalParam)) : null;
                String senderLogin = event.getTagValue("msg-param-sender-login").orElse(null);
                String senderName = event.getTagValue("msg-param-sender-name").orElse(null);
                this.eventManager.publish((Object)new GiftSubUpgradeEvent(channel, user, promoName, giftTotal, senderLogin, senderName));
            } else if (msgId.equalsIgnoreCase("primepaidupgrade")) {
                EventUser user = event.getUser();
                SubscriptionPlan subPlan = event.getTagValue("msg-param-sub-plan").map(SubscriptionPlan::fromString).orElse(null);
                this.eventManager.publish((Object)new PrimeSubUpgradeEvent(channel, user, subPlan));
            } else if (msgId.equalsIgnoreCase("extendsub")) {
                EventUser user = event.getUser();
                SubscriptionPlan subPlan = event.getTagValue("msg-param-sub-plan").map(SubscriptionPlan::fromString).orElse(null);
                String cumMonthsParam = event.getTags().get("msg-param-cumulative-months");
                int cumulativeMonths = cumMonthsParam != null ? Math.max(Integer.parseInt(cumMonthsParam), 1) : 1;
                String endMonthParam = event.getTags().get("msg-param-sub-benefit-end-month");
                Month endMonth = endMonthParam != null ? Month.of(Integer.parseInt(endMonthParam)) : null;
                this.eventManager.publish((Object)new ExtendSubscriptionEvent(channel, user, subPlan, cumulativeMonths, endMonth));
            }
        }
    }

    public void onGiftReceived(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && "primecommunitygiftreceived".equalsIgnoreCase(event.getTags().get("msg-id"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String giftName = event.getTagValue("msg-param-gift-name").orElse(null);
            String recipientName = event.getTagValue("msg-param-recipient").orElse(null);
            this.eventManager.publish((Object)new PrimeGiftReceivedEvent(channel, user, giftName, recipientName));
        }
    }

    public void onPayForward(IRCMessageEvent event) {
        String msgId;
        if ("USERNOTICE".equals(event.getCommandType()) && (msgId = event.getTags().get("msg-id")) != null && (msgId.equalsIgnoreCase("standardpayforward") || msgId.equalsIgnoreCase("communitypayforward"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String gifterId = event.getTagValue("msg-param-prior-gifter-id").orElse(null);
            String gifterName = gifterId != null ? event.getTagValue("msg-param-prior-gifter-user-name").orElseGet(() -> event.getTagValue("msg-param-prior-gifter-display-name").orElse(null)) : null;
            EventUser gifter = gifterId != null ? new EventUser(gifterId, gifterName) : null;
            String recipientId = msgId.charAt(0) == 's' ? (String)event.getTagValue("msg-param-recipient-id").orElse(null) : null;
            String recipientName = recipientId != null ? event.getTagValue("msg-param-recipient-user-name").orElseGet(() -> event.getTagValue("msg-param-recipient-display-name").orElse(null)) : null;
            EventUser recipient = recipientId != null ? new EventUser(recipientId, recipientName) : null;
            this.eventManager.publish((Object)new PayForwardEvent(channel, user, gifter, recipient));
        }
    }

    public void onCharityDonation(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && "charitydonation".equalsIgnoreCase(event.getTags().get("msg-id"))) {
            this.eventManager.publish((Object)new CharityDonationEvent(event));
        }
    }

    public void onRaid(IRCMessageEvent event) {
        if (event.getCommandType().equals("USERNOTICE") && event.getTags().containsKey("msg-id") && event.getTags().get("msg-id").equalsIgnoreCase("raid")) {
            Integer viewers;
            EventChannel channel = event.getChannel();
            EventUser raider = event.getUser();
            try {
                viewers = Integer.parseInt(event.getTags().get("msg-param-viewerCount"));
            }
            catch (NumberFormatException ex) {
                viewers = 0;
            }
            this.eventManager.publish((Object)new RaidEvent(channel, raider, viewers));
        }
    }

    public void onUnraid(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && "unraid".equalsIgnoreCase(event.getTags().get("msg-id"))) {
            this.eventManager.publish((Object)new RaidCancellationEvent(event.getChannel()));
        }
    }

    public void onRewardGift(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && "rewardgift".equalsIgnoreCase(event.getTags().get("msg-id"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String domain = event.getTagValue("msg-param-domain").orElse(null);
            String triggerType = event.getTagValue("msg-param-trigger-type").orElse(null);
            String selectedCountParam = event.getTags().get("msg-param-selected-count");
            Integer selectedCount = selectedCountParam != null ? Integer.valueOf(Integer.parseInt(selectedCountParam)) : null;
            String totalRewardCountParam = event.getTags().get("msg-param-total-reward-count");
            Integer totalRewardCount = totalRewardCountParam != null ? Integer.valueOf(Integer.parseInt(totalRewardCountParam)) : null;
            String triggerAmountParam = event.getTags().get("msg-param-trigger-amount");
            Integer triggerAmount = triggerAmountParam != null ? Integer.valueOf(Integer.parseInt(triggerAmountParam)) : null;
            this.eventManager.publish((Object)new RewardGiftEvent(channel, user, domain, triggerType, selectedCount, totalRewardCount, triggerAmount));
        }
    }

    @Deprecated
    public void onRitual(IRCMessageEvent event) {
        if ("USERNOTICE".equals(event.getCommandType()) && "ritual".equalsIgnoreCase(event.getTags().get("msg-id"))) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            String ritualName = event.getTagValue("msg-param-ritual-name").orElse(null);
            this.eventManager.publish((Object)new RitualEvent(channel, user, ritualName));
        }
    }

    public void onClearChat(IRCMessageEvent event) {
        if (event.getCommandType().equals("CLEARCHAT")) {
            EventChannel channel = event.getChannel();
            if (event.getTags().containsKey("target-user-id")) {
                if (event.getTags().containsKey("ban-duration")) {
                    EventUser user = event.getTargetUser();
                    Integer duration = Integer.parseInt(event.getTagValue("ban-duration").get());
                    String banReason = event.getTags().get("ban-reason") != null ? event.getTags().get("ban-reason").toString() : "";
                    banReason = banReason.replaceAll("\\\\s", " ");
                    UserTimeoutEvent timeoutEvent = new UserTimeoutEvent(channel, user, duration, banReason);
                    this.eventManager.publish((Object)timeoutEvent);
                } else {
                    EventUser user = event.getTargetUser();
                    String banReason = event.getTagValue("ban-reason").orElse("");
                    banReason = banReason.replaceAll("\\\\s", " ");
                    UserBanEvent banEvent = new UserBanEvent(channel, user, banReason);
                    this.eventManager.publish((Object)banEvent);
                }
            } else {
                this.eventManager.publish((Object)new ClearChatEvent(channel));
            }
        }
    }

    public void onClearMsg(IRCMessageEvent event) {
        if ("CLEARMSG".equals(event.getCommandType())) {
            EventChannel channel = event.getChannel();
            String userName = event.getUserName();
            String msgId = event.getTagValue("target-msg-id").orElse(null);
            String message = event.getMessage().orElse("");
            boolean wasActionMessage = message.startsWith("\u0001ACTION ") && message.endsWith("\u0001");
            String trimmedMsg = wasActionMessage ? message.substring("\u0001ACTION ".length(), message.length() - "\u0001".length()) : message;
            this.eventManager.publish((Object)new DeleteMessageEvent(channel, userName, msgId, trimmedMsg, wasActionMessage));
        }
    }

    public void onChannnelClientJoinEvent(IRCMessageEvent event) {
        if (event.getCommandType().equals("JOIN") && event.getChannelName().isPresent() && event.getClientName().isPresent()) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            if (channel != null && user != null) {
                this.eventManager.publish((Object)new ChannelJoinEvent(channel, user));
            }
        }
    }

    public void onChannnelClientLeaveEvent(IRCMessageEvent event) {
        if (event.getCommandType().equals("PART") && event.getChannelName().isPresent() && event.getClientName().isPresent()) {
            EventChannel channel = event.getChannel();
            EventUser user = event.getUser();
            if (channel != null && user != null) {
                this.eventManager.publish((Object)new ChannelLeaveEvent(channel, user));
            }
        }
    }

    public void onChannelModChange(IRCMessageEvent event) {
        if (event.getCommandType().equals("MODE") && event.getPayload().isPresent() && event.getPayload().get().substring(1).startsWith("o")) {
            EventChannel channel = event.getChannel();
            EventUser user = new EventUser(null, event.getPayload().get().substring(3));
            this.eventManager.publish((Object)new ChannelModEvent(channel, user, event.getPayload().get().startsWith("+")));
        }
    }

    public void onNoticeEvent(IRCMessageEvent event) {
        if (event.getCommandType().equals("NOTICE")) {
            EventChannel channel = event.getChannel();
            String messageId = event.getTagValue("msg-id").get();
            String message = event.getMessage().orElse(null);
            this.eventManager.publish((Object)new ChannelNoticeEvent(channel, messageId, message));
        }
    }

    @Deprecated
    public void onHostOnEvent(IRCMessageEvent event) {
        if (event.getCommandType().equals("NOTICE")) {
            EventChannel channel = event.getChannel();
            String messageId = event.getTagValue("msg-id").get();
            if (messageId.equals(NoticeTag.HOST_ON.toString())) {
                String message = event.getMessage().get();
                String targetChannelName = message.substring(12, message.length() - 1);
                EventChannel targetChannel = new EventChannel(null, targetChannelName);
                this.eventManager.publish((Object)new HostOnEvent(channel, targetChannel));
            }
        }
    }

    @Deprecated
    public void onHostOffEvent(IRCMessageEvent event) {
        if (event.getCommandType().equals("NOTICE")) {
            EventChannel channel = event.getChannel();
            String messageId = event.getTagValue("msg-id").get();
            if (messageId.equals(NoticeTag.HOST_OFF.toString())) {
                this.eventManager.publish((Object)new HostOffEvent(channel));
            }
        }
    }

    @Deprecated
    public void onInboundHostEvent(IRCMessageEvent event) {
        if ("PRIVMSG".equals(event.getCommandType()) && "jtv".equals(event.getClientName().orElse(null)) && event.getChannelName().isPresent() && event.getRawTags().isEmpty()) {
            String hostMessage = " is now hosting you";
            event.getMessage().map(msg -> msg.indexOf(" is now hosting you")).filter(index -> index > 0).map(index -> event.getMessage().get().substring(0, (int)index)).map(String::trim).ifPresent(hostName -> this.eventManager.publish((Object)new InboundHostEvent(event.getChannelName().get(), (String)hostName)));
        }
    }

    @Deprecated
    public void onListModsEvent(IRCMessageEvent event) {
        if ("NOTICE".equals(event.getCommandType()) && event.getTagValue("msg-id").filter(s -> s.equals(NoticeTag.ROOM_MODS.toString()) || s.equals(NoticeTag.NO_MODS.toString())).isPresent()) {
            List<String> names = IRCEventHandler.extractItemsFromDelimitedList(event.getMessage(), "The moderators of this channel are: ", ", ");
            this.eventManager.publish((Object)new ListModsEvent(event.getChannel(), names));
        }
    }

    @Deprecated
    public void onListVipsEvent(IRCMessageEvent event) {
        if ("NOTICE".equals(event.getCommandType()) && event.getTagValue("msg-id").filter(s -> s.equals(NoticeTag.VIPS_SUCCESS.toString()) || s.equals(NoticeTag.NO_VIPS.toString())).isPresent()) {
            List<String> names = IRCEventHandler.extractItemsFromDelimitedList(event.getMessage(), "The VIPs of this channel are: ", ", ");
            this.eventManager.publish((Object)new ListVipsEvent(event.getChannel(), names));
        }
    }

    public void onChannelState(IRCMessageEvent event) {
        if (event.getCommandType().equals("ROOMSTATE")) {
            EventChannel channel = event.getChannel();
            HashMap<ChannelStateEvent.ChannelState, Object> states = new HashMap<ChannelStateEvent.ChannelState, Object>();
            if (event.getTags().size() > 2) {
                event.getTags().forEach((k, v) -> {
                    switch (k) {
                        case "broadcaster-lang": {
                            Locale locale = v != null ? Locale.forLanguageTag(v) : null;
                            states.put(ChannelStateEvent.ChannelState.BROADCAST_LANG, locale);
                            this.eventManager.publish((Object)new BroadcasterLanguageEvent(channel, locale));
                            break;
                        }
                        case "emote-only": {
                            boolean eoActive = "1".equals(v);
                            states.put(ChannelStateEvent.ChannelState.EMOTE, eoActive);
                            this.eventManager.publish((Object)new EmoteOnlyEvent(channel, eoActive));
                            break;
                        }
                        case "followers-only": {
                            long followDelay = Long.parseLong(v);
                            states.put(ChannelStateEvent.ChannelState.FOLLOWERS, followDelay);
                            this.eventManager.publish((Object)new FollowersOnlyEvent(channel, followDelay));
                            break;
                        }
                        case "r9k": {
                            boolean uniqActive = "1".equals(v);
                            states.put(ChannelStateEvent.ChannelState.R9K, uniqActive);
                            this.eventManager.publish((Object)new Robot9000Event(channel, uniqActive));
                            break;
                        }
                        case "rituals": {
                            boolean ritualsActive = "1".equals(v);
                            states.put(ChannelStateEvent.ChannelState.RITUALS, ritualsActive);
                            break;
                        }
                        case "slow": {
                            long slowDelay = Long.parseLong(v);
                            states.put(ChannelStateEvent.ChannelState.SLOW, slowDelay);
                            this.eventManager.publish((Object)new SlowModeEvent(channel, slowDelay));
                            break;
                        }
                        case "subs-only": {
                            boolean subActive = "1".equals(v);
                            states.put(ChannelStateEvent.ChannelState.SUBSCRIBERS, subActive);
                            this.eventManager.publish((Object)new SubscribersOnlyEvent(channel, subActive));
                            break;
                        }
                    }
                });
            }
            this.eventManager.publish((Object)new ChannelStateEvent(channel, states));
        }
    }

    public void onMessageDeleteResponse(IRCMessageEvent event) {
        if (event.getCommandType().equals("NOTICE")) {
            EventChannel channel = event.getChannel();
            String messageId = event.getTagValue("msg-id").orElse(null);
            NoticeTag tag = NoticeTag.parse(messageId);
            if (tag == NoticeTag.DELETE_MESSAGE_SUCCESS) {
                this.eventManager.publish((Object)new MessageDeleteSuccess(channel));
            } else if (tag == NoticeTag.BAD_DELETE_MESSAGE_ERROR || tag == NoticeTag.BAD_DELETE_MESSAGE_BROADCASTER || tag == NoticeTag.BAD_DELETE_MESSAGE_MOD) {
                this.eventManager.publish((Object)new MessageDeleteError(channel));
                log.warn("Failed to delete a message in {}!", (Object)channel.getName());
            }
        }
    }

    public void onUserState(IRCMessageEvent event) {
        if (event.getCommandType().equals("USERSTATE")) {
            this.eventManager.publish((Object)new UserStateEvent(event));
        }
    }

    public void onGlobalUserState(IRCMessageEvent event) {
        if ("GLOBALUSERSTATE".equals(event.getCommandType())) {
            this.eventManager.publish((Object)new GlobalUserStateEvent(event));
        }
    }

    @NonNull
    private static List<String> extractItemsFromDelimitedList(@NonNull Optional<String> message, @NonNull String prefix, @NonNull String delim) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (delim == null) {
            throw new NullPointerException("delim is marked non-null but is null");
        }
        return message.filter(s -> s.startsWith(prefix)).map(s -> s.substring(prefix.length())).map(s -> s.charAt(s.length() - 1) == '.' ? s.substring(0, s.length() - 1) : s).map(s -> StringUtils.split((String)s, (String)delim)).map(Arrays::asList).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    public TwitchChat getTwitchChat() {
        return this.twitchChat;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }
}

