package de.tr7zw.changeme.nbtapi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import de.tr7zw.changeme.nbtapi.utils.nmsmappings.ClassWrapper;
import de.tr7zw.changeme.nbtapi.utils.nmsmappings.ReflectionMethod;

/**
 * Integer implementation for NBTLists
 * 
 * @author tr7zw
 *
 */
public class NBTIntegerList extends NBTList<Integer> {

    protected NBTIntegerList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    @Override
    protected Object asTag(Integer object) {
        try {
            Constructor<?> con = ClassWrapper.NMS_NBTTAGINT.getClazz().getDeclaredConstructor(int.class);
            con.setAccessible(true);
            return con.newInstance(object);
        } catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException
                | NoSuchMethodException | SecurityException e) {
            throw new NbtApiException("Error while wrapping the Object " + object + " to it's NMS object!", e);
        }
    }

    @Override
    public Integer get(int index) {
        try {
            Object obj = ReflectionMethod.LIST_GET.run(listObject, index);
            return Integer.valueOf(obj.toString());
        } catch (NumberFormatException nf) {
            return 0;
        } catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

}
