/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.notmatched;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.diff.Diff;
import com.github.tomakehurst.wiremock.verification.diff.PlainTextDiffRenderer;
import com.github.tomakehurst.wiremock.verification.notmatched.NotMatchedRenderer;
import java.util.List;
import java.util.Map;

public class PlainTextStubNotMatchedRenderer
extends NotMatchedRenderer {
    public static final String CONSOLE_WIDTH_HEADER_KEY = "X-WireMock-Console-Width";

    @Override
    public ResponseDefinition render(Admin admin, Request request) {
        String body;
        PlainTextDiffRenderer diffRenderer;
        LoggedRequest loggedRequest = LoggedRequest.createFrom(request.getOriginalRequest().or(request));
        List<NearMiss> nearMisses = admin.findTopNearMissesFor(loggedRequest).getNearMisses();
        Map<String, RequestMatcherExtension> customMatcherExtensions = admin.getOptions().extensionsOfType(RequestMatcherExtension.class);
        PlainTextDiffRenderer plainTextDiffRenderer = diffRenderer = loggedRequest.containsHeader(CONSOLE_WIDTH_HEADER_KEY) ? new PlainTextDiffRenderer(customMatcherExtensions, Integer.parseInt(loggedRequest.getHeader(CONSOLE_WIDTH_HEADER_KEY))) : new PlainTextDiffRenderer(customMatcherExtensions);
        if (nearMisses.isEmpty()) {
            body = "No response could be served as there are no stub mappings in this WireMock instance.";
        } else {
            Diff firstDiff = nearMisses.get(0).getDiff();
            body = diffRenderer.render(firstDiff);
        }
        LocalNotifier.notifier().error(body);
        return ResponseDefinitionBuilder.responseDefinition().withStatus(404).withHeader("Content-Type", "text/plain").withBody(body).build();
    }
}

