/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.common.DateTimeParser;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.RenderableDate;
import java.io.IOException;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import wiremock.com.github.jknack.handlebars.Options;

public class ParseDateHelper
extends HandlebarsHelper<String> {
    @Override
    public Object apply(String dateTimeString, Options options) throws IOException {
        String format = (String)options.hash("format", null);
        return format == null ? ParseDateHelper.parseOrNull(dateTimeString) : ParseDateHelper.parseOrNull(dateTimeString, DateTimeParser.forFormat(format));
    }

    private static RenderableDate parseOrNull(String dateTimeString) {
        return ParseDateHelper.parseOrNull(dateTimeString, (DateTimeParser)null);
    }

    private static RenderableDate parseOrNull(String dateTimeString, DateTimeParser parser) {
        List<DateTimeParser> parsers = parser != null ? Collections.singletonList(parser) : DateTimeParser.ZONED_PARSERS;
        return ParseDateHelper.parseOrNull(dateTimeString, parsers);
    }

    private static RenderableDate parseOrNull(String dateTimeString, List<DateTimeParser> parsers) {
        if (parsers.isEmpty()) {
            return null;
        }
        try {
            DateTimeParser headParser = parsers.get(0);
            return headParser.parseDate(dateTimeString);
        }
        catch (DateTimeParseException e) {
            return ParseDateHelper.parseOrNull(dateTimeString, parsers.subList(1, parsers.size()));
        }
    }
}

