/*
 * Decompiled with CFR 0.152.
 */
package com.github.shynixn.petblocks.api;

import com.github.shynixn.petblocks.api.business.controller.PetBlockController;
import com.github.shynixn.petblocks.api.business.service.GUIService;
import com.github.shynixn.petblocks.api.persistence.controller.PetMetaController;
import java.util.Optional;

public class PetBlocksApi {
    private static PetMetaController metaController;
    private static PetBlockController petBlockController;
    private static GUIService guiService;
    public static final PetBlocksApi INSTANCE;

    private static void initialize(PetMetaController petMetaController, PetBlockController petBlockController, GUIService guiService) {
        metaController = petMetaController;
        PetBlocksApi.petBlockController = petBlockController;
        PetBlocksApi.guiService = guiService;
    }

    public <S> Optional<S> resolve(Class<S> service) {
        if (service == GUIService.class) {
            return Optional.of(guiService);
        }
        return Optional.empty();
    }

    public static <T> PetMetaController<T> getDefaultPetMetaController() {
        return metaController;
    }

    public static <T> PetBlockController<T> getDefaultPetBlockController() {
        return petBlockController;
    }

    static {
        INSTANCE = new PetBlocksApi();
    }
}

