package io.github.retrooper.packetevents.manager.player;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.netty.buffer.ByteBufAbstract;
import com.github.retrooper.packetevents.netty.channel.ChannelAbstract;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerManagerImpl implements PlayerManager {
    @Override
    public abstract int getPing(@NotNull Object player);

    @Override
    public abstract ChannelAbstract getChannel(@NotNull Object player);

    @Override
    public @NotNull ClientVersion getClientVersion(@NotNull Object player) {
        return getUser(player).getClientVersion();
    }

    @Override
    public ClientVersion getClientVersion(ChannelAbstract channel) {
        User user = getUser(channel);
        ClientVersion version = user.getClientVersion();
        if (version == null || !version.isResolved()) {
            int protocolVersion = PacketEvents.getAPI().getServerManager().getVersion().getProtocolVersion();
            version = ClientVersion.getClientVersionByProtocolVersion(protocolVersion);
            user.setClientVersion(version);
        }
        return version;
    }

    @Override
    public void sendPacket(ChannelAbstract channel, ByteBufAbstract byteBuf) {
        if (channel.isOpen()) {
            channel.writeAndFlush(byteBuf);
        }
    }

    @Override
    public void sendPacketSilently(ChannelAbstract channel, ByteBufAbstract byteBuf) {
        if (channel.isOpen()) {
            channel.pipeline().context(PacketEvents.ENCODER_NAME).writeAndFlush(byteBuf);
        }
    }

    @Override
    public User getUser(@NotNull Object player) {
        ChannelAbstract channel = getChannel(player);
        return getUser(channel);
    }
}