/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.events4j.simple;

import com.github.philippheuer.events4j.api.domain.IDisposable;
import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.simple.domain.EventSubscriber;
import com.github.philippheuer.events4j.simple.domain.SimpleEventHandlerSubscription;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEventHandler
implements IEventHandler {
    private static final Logger log = LoggerFactory.getLogger(SimpleEventHandler.class);
    private final ConcurrentMap<Class<? extends Object>, List<Consumer>> consumerBasedHandlers = new ConcurrentHashMap<Class<? extends Object>, List<Consumer>>();
    private final ConcurrentMap<Class<? extends Object>, ConcurrentMap<Method, List<Object>>> methodListeners = new ConcurrentHashMap<Class<? extends Object>, ConcurrentMap<Method, List<Object>>>();

    public void registerListener(Object eventListener) {
        this.registerListener(eventListener.getClass(), eventListener);
    }

    public <E> IDisposable onEvent(Class<E> eventClass, Consumer<E> consumer) {
        List eventHandlers = this.consumerBasedHandlers.computeIfAbsent(eventClass, s -> new CopyOnWriteArrayList());
        eventHandlers.add(consumer);
        return new SimpleEventHandlerSubscription<E>(this, eventClass, consumer);
    }

    private void registerListener(Class<?> eventListenerClass, Object eventListener) {
        for (Method method : eventListenerClass.getMethods()) {
            if (method.getParameterCount() != 1 || !method.isAnnotationPresent(EventSubscriber.class)) continue;
            method.setAccessible(true);
            Class<?> eventClass = method.getParameterTypes()[0];
            if (!Object.class.isAssignableFrom(eventClass)) continue;
            this.methodListeners.computeIfAbsent(eventClass, c -> new ConcurrentHashMap()).computeIfAbsent(method, m -> new CopyOnWriteArrayList()).add(eventListener);
            log.info("Registered method listener {}#{}", (Object)eventListenerClass.getSimpleName(), (Object)method.getName());
        }
    }

    public void publish(Object event) {
        List eventConsumers = (List)this.consumerBasedHandlers.get(event.getClass());
        if (eventConsumers != null) {
            eventConsumers.forEach(consumer -> consumer.accept(event));
        }
        if (this.methodListeners.size() > 0) {
            for (Map.Entry e : this.methodListeners.entrySet()) {
                if (!((Class)e.getKey()).isAssignableFrom(event.getClass())) continue;
                ConcurrentMap eventClass = (ConcurrentMap)e.getValue();
                eventClass.forEach((k, v) -> v.forEach(object -> {
                    try {
                        k.invoke(object, event);
                    }
                    catch (IllegalAccessException ex) {
                        log.error("Error dispatching event {}.", (Object)event.getClass().getSimpleName());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        log.error("Unhandled exception caught dispatching event {}.", (Object)event.getClass().getSimpleName());
                    }
                }));
            }
        }
    }

    public void close() {
    }

    public ConcurrentMap<Class<? extends Object>, List<Consumer>> getConsumerBasedHandlers() {
        return this.consumerBasedHandlers;
    }
}

