/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.events4j.reactor.util;

import com.github.philippheuer.events4j.api.domain.IDisposable;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;

public class Events4JSubscriber<E>
implements Subscriber<E>,
Disposable,
IDisposable {
    private Subscription subscription;
    private Consumer<E> consumer;
    private boolean isDisposed = false;

    public Events4JSubscriber(Consumer<E> consumer) {
        this.consumer = consumer;
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(E event) {
        this.consumer.accept(event);
        this.subscription.request(1L);
    }

    public void onError(Throwable t) {
    }

    public void onComplete() {
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.subscription.cancel();
            this.isDisposed = true;
            this.subscription = null;
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

