/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers.ast;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.ListBuffer;
import java.util.List;
import lombok.ast.AbstractMethodDecl;
import lombok.ast.ClassDecl;
import lombok.ast.ConstructorDecl;
import lombok.ast.EnumConstant;
import lombok.ast.FieldDecl;
import lombok.ast.ITypeEditor;
import lombok.ast.Initializer;
import lombok.ast.MethodDecl;
import lombok.ast.Node;
import lombok.ast.WrappedMethodDecl;
import lombok.javac.JavacNode;
import lombok.javac.handlers.Javac;
import lombok.javac.handlers.JavacHandlerUtil;
import lombok.javac.handlers.ast.JavacASTMaker;
import lombok.javac.handlers.ast.JavacMethod;
import lombok.javac.handlers.ast.JavacType;

public final class JavacTypeEditor
implements ITypeEditor<JavacMethod, JCTree, JCTree.JCClassDecl, JCTree.JCMethodDecl> {
    private final JavacType type;
    private final JavacASTMaker builder;

    JavacTypeEditor(JavacType type, JCTree source) {
        this.type = type;
        this.builder = new JavacASTMaker(type.node(), source);
    }

    JCTree.JCClassDecl get() {
        return this.type.get();
    }

    JavacNode node() {
        return this.type.node();
    }

    @Override
    public <T extends JCTree> T build(Node<?> node) {
        return this.builder.build(node);
    }

    @Override
    public <T extends JCTree> T build(Node<?> node, Class<T> extectedType) {
        return this.builder.build(node, extectedType);
    }

    @Override
    public <T extends JCTree> List<T> build(List<? extends Node<?>> nodes) {
        return this.builder.build(nodes);
    }

    @Override
    public <T extends JCTree> List<T> build(List<? extends Node<?>> nodes, Class<T> extectedType) {
        return this.builder.build(nodes, extectedType);
    }

    @Override
    public void injectInitializer(Initializer initializer) {
        JCTree.JCBlock initializerBlock = (JCTree.JCBlock)this.builder.build(initializer);
        Javac.injectInitializer(this.node(), initializerBlock);
    }

    @Override
    public void injectField(FieldDecl fieldDecl) {
        JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)this.builder.build(fieldDecl);
        JavacHandlerUtil.injectField(this.node(), field);
    }

    @Override
    public void injectField(EnumConstant enumConstant) {
        JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)this.builder.build(enumConstant);
        JavacHandlerUtil.injectField(this.node(), field);
    }

    @Override
    public JCTree.JCMethodDecl injectMethod(MethodDecl methodDecl) {
        return this.injectMethodImpl(methodDecl);
    }

    @Override
    public JCTree.JCMethodDecl injectConstructor(ConstructorDecl constructorDecl) {
        return this.injectMethodImpl(constructorDecl);
    }

    private JCTree.JCMethodDecl injectMethodImpl(AbstractMethodDecl<?> methodDecl) {
        JCTree.JCMethodDecl method = this.builder.build(methodDecl, JCTree.JCMethodDecl.class);
        JavacHandlerUtil.injectMethod(this.node(), method);
        if (methodDecl instanceof WrappedMethodDecl) {
            WrappedMethodDecl node = (WrappedMethodDecl)methodDecl;
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)node.getWrappedObject();
            JCTree.JCClassDecl tree = this.get();
            Symbol.ClassSymbol c = tree.sym;
            c.members_field.enter(methodSymbol, c.members_field, methodSymbol.enclClass().members_field);
            method.sym = methodSymbol;
        }
        return method;
    }

    @Override
    public void injectType(ClassDecl typeDecl) {
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)this.builder.build(typeDecl);
        Javac.injectType(this.node(), type);
    }

    @Override
    public void removeMethod(JavacMethod method) {
        JCTree.JCClassDecl type = this.get();
        ListBuffer defs = ListBuffer.lb();
        for (JCTree def : type.defs) {
            if (def.equals(method.get())) continue;
            defs.append(def);
        }
        type.defs = defs.toList();
        this.node().removeChild(method.node());
    }

    @Override
    public void makeEnum() {
        this.get().mods.flags |= 0x4000L;
    }

    @Override
    public void makePrivate() {
        this.makePackagePrivate();
        this.get().mods.flags |= 2L;
    }

    @Override
    public void makePackagePrivate() {
        this.get().mods.flags &= 0xFFFFFFFFFFFFFFF8L;
    }

    @Override
    public void makeProtected() {
        this.makePackagePrivate();
        this.get().mods.flags |= 4L;
    }

    @Override
    public void makePublic() {
        this.makePackagePrivate();
        this.get().mods.flags |= 1L;
    }

    @Override
    public void makeStatic() {
        this.get().mods.flags |= 8L;
    }

    @Override
    public void rebuild() {
        this.node().rebuild();
    }

    public String toString() {
        return this.get().toString();
    }
}

