/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import lombok.AutoGenMethodStub;
import lombok.ast.AST;
import lombok.ast.MethodDecl;
import lombok.ast.Statement;
import lombok.core.AnnotationValues;
import lombok.core.util.ErrorMessages;
import lombok.javac.JavacAST;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.ResolutionBased;
import lombok.javac.handlers.Javac;
import lombok.javac.handlers.JavacHandlerUtil;
import lombok.javac.handlers.ast.JavacType;

@ResolutionBased
public class HandleAutoGenMethodStub
extends JavacAnnotationHandler<AutoGenMethodStub> {
    @Override
    public void handle(AnnotationValues<AutoGenMethodStub> annotation, JCTree.JCAnnotation source, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, AutoGenMethodStub.class);
        JavacType type = JavacType.typeOf(annotationNode, source);
        if (type.isInterface() || type.isAnnotation()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(AutoGenMethodStub.class));
            return;
        }
        AutoGenMethodStub autoGenMethodStub = annotation.getInstance();
        Statement statement = autoGenMethodStub.throwException() ? AST.Throw(AST.New(AST.Type(UnsupportedOperationException.class)).withArgument(AST.String("This method is not implemented yet."))) : AST.ReturnDefault();
        for (Symbol.MethodSymbol methodSymbol : UndefiniedMethods.of(type.node())) {
            type.editor().injectMethod((MethodDecl)AST.MethodDecl(methodSymbol).implementing().withStatement(statement));
        }
        type.editor().rebuild();
    }

    private static class UndefiniedMethods
    implements Iterator<Symbol.MethodSymbol>,
    Iterable<Symbol.MethodSymbol> {
        private final Set<String> handledMethods = new HashSet<String>();
        private final JavacNode typeNode;
        private final Symbol.ClassSymbol classSymbol;
        private final Types types;
        private boolean hasNext;
        private boolean nextDefined;
        private Symbol.MethodSymbol next;

        @Override
        public Iterator<Symbol.MethodSymbol> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (!this.nextDefined) {
                this.hasNext = this.getNext();
                this.nextDefined = true;
            }
            return this.hasNext;
        }

        @Override
        public Symbol.MethodSymbol next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextDefined = false;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean getNext() {
            Symbol.MethodSymbol firstUndefinedMethod = this.getFirstUndefinedMethod(this.classSymbol);
            if (firstUndefinedMethod != null) {
                this.next = this.createMethodStubFor(firstUndefinedMethod);
                this.handledMethods.add(firstUndefinedMethod.toString());
                return true;
            }
            return false;
        }

        public static UndefiniedMethods of(JavacNode node) {
            JavacNode typeNode = Javac.typeNodeOf(node);
            return new UndefiniedMethods(typeNode, ((JCTree.JCClassDecl)typeNode.get()).sym, Types.instance(((JavacAST)typeNode.getAst()).getContext()));
        }

        private Symbol.MethodSymbol createMethodStubFor(Symbol.MethodSymbol methodSym) {
            Type.MethodType type = (Type.MethodType)methodSym.type;
            Name name = methodSym.name;
            Symbol.MethodSymbol methodStubSym = new Symbol.MethodSymbol(methodSym.flags() & 0xFFFFFFFFFFFFFBFFL, name, this.types.memberType(this.classSymbol.type, methodSym), this.classSymbol);
            ListBuffer<Symbol.VarSymbol> paramSyms = new ListBuffer<Symbol.VarSymbol>();
            int i = 1;
            if (type.argtypes != null) {
                for (Type argType : type.argtypes) {
                    paramSyms.append(new Symbol.VarSymbol(0x200000000L, this.typeNode.toName("arg" + i++), argType, methodStubSym));
                }
            }
            methodStubSym.params = paramSyms.toList();
            return methodStubSym;
        }

        private Symbol.MethodSymbol getFirstUndefinedMethod(Symbol.ClassSymbol c) {
            Symbol.MethodSymbol undef = null;
            if (c == this.classSymbol || (c.flags() & 0x600L) != 0L) {
                Scope s = c.members();
                Scope.Entry e = s.elems;
                while (undef == null && e != null) {
                    Symbol.MethodSymbol absmeth;
                    Symbol.MethodSymbol implmeth;
                    if (!(e.sym.kind != 16 || (e.sym.flags() & 0x200400L) != 1024L || (implmeth = (absmeth = (Symbol.MethodSymbol)e.sym).implementation(this.classSymbol, this.types, true)) != null && implmeth != absmeth || this.handledMethods.contains(absmeth.toString()))) {
                        undef = absmeth;
                    }
                    e = e.sibling;
                }
                if (undef == null) {
                    Type st = this.types.supertype(c.type);
                    if (st.tag == 10) {
                        undef = this.getFirstUndefinedMethod((Symbol.ClassSymbol)st.tsym);
                    }
                }
                List<Type> l = this.types.interfaces(c.type);
                while (undef == null && l.nonEmpty()) {
                    undef = this.getFirstUndefinedMethod((Symbol.ClassSymbol)((Type)l.head).tsym);
                    l = l.tail;
                }
            }
            return undef;
        }

        private UndefiniedMethods(JavacNode typeNode, Symbol.ClassSymbol classSymbol, Types types) {
            this.typeNode = typeNode;
            this.classSymbol = classSymbol;
            this.types = types;
        }
    }
}

