package com.github.niupengyu.schedule.statistics.service;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.init.BaseSysinitBean;
import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.schedule.common2.bean.Primary;
import com.github.niupengyu.schedule.common2.bean.PrimaryKey;
import com.github.niupengyu.schedule.common2.bean.TaskTimer;
import com.github.niupengyu.schedule.common2.face.reader.base.Compare;
import com.github.niupengyu.schedule.common2.face.reader.base.DataReader;
import com.github.niupengyu.schedule.common2.face.reader.compare.AllCompareDataReader;
import com.github.niupengyu.schedule.common2.face.reader.compare.AllTimeCompareDataReader;
import com.github.niupengyu.schedule.common2.face.reader.compare.PageCompareDataReader;
import com.github.niupengyu.schedule.common2.face.reader.compare.PageTimeCompareDataReader;
import com.github.niupengyu.schedule.common2.face.reader.impl.AllDataReader;
import com.github.niupengyu.schedule.common2.face.reader.impl.AllTimeDataReader;
import com.github.niupengyu.schedule.common2.face.reader.impl.PageDataReader;
import com.github.niupengyu.schedule.common2.face.reader.impl.PageTimeDataReader;
import com.github.niupengyu.schedule.common2.face.writer.base.SaveWriter;
import com.github.niupengyu.schedule.common2.factory.TaskFlowFactory;
import com.github.niupengyu.schedule.common2.model.impl.AllDataModel;
import com.github.niupengyu.schedule.common2.model.impl.AllTimeDataModel;
import com.github.niupengyu.schedule.common2.model.impl.PageDataModel;
import com.github.niupengyu.schedule.common2.model.impl.PageTimeDataModel;
import com.github.niupengyu.schedule.common2.service.TaskBean;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.alibaba.druid.pool.xa.DruidXADataSource;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.schedule.statistics.dao.StatisticsMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.TextStyle;
import java.util.*;

@Service("statisticsService")
public class StatisticsService {

    @Autowired
    private StatisticsMapper statisticsMapper;

    @Resource(name = "mainService")
    private MainService mainService;

    public JSONObject sevenDay() {
        LocalDate startDate = LocalDate.now();
        LocalDateTime start = LocalDateTime.of(startDate, LocalTime.of(00, 00, 00));
        //System.out.println(start);
        start = start.minusDays(6);
        //System.out.println(start);
        Map<String, JSONObject> dateMap = new HashMap<>();
        startDate = start.toLocalDate();
        List<String> localDates = new ArrayList<>();
        JSONArray timeData = new JSONArray();
        for (int i = 0; i < 7; i++) {
            JSONObject obj = new JSONObject();
            LocalDate next = startDate.minusDays(-i);
            String day = DateUtil.dateFormat(next);
            String week = next.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.CHINESE);
            obj.put("day", day);
            obj.put("week", week);
            obj.put("index", i);
            dateMap.put(day, obj);
            localDates.add(day);
            timeData.add(week);
        }
        DruidXADataSource druidXADataSource = new DruidXADataSource();
        List<JSONObject> list = statisticsMapper.selectData(DateUtil.dateFormat(start), "TIMER");
        JSONObject res = new JSONObject();
        for (JSONObject map : list) {
            int num = map.getIntValue("num");
            String startTime = map.getString("startTime");
            String task = map.getString("task");
            if (res.containsKey(task)) {
                int[] nums = res.getObject(task, int[].class);
                if (dateMap.containsKey(startTime)) {
                    int index = dateMap.get(startTime).getIntValue("index");
                    nums[index] = num;
                }
            } else {
                int[] nums = new int[localDates.size()];
                if (dateMap.containsKey(startTime)) {
                    int index = dateMap.get(startTime).getIntValue("index");
                    nums[index] = num;
                }
                res.put(task, nums);
            }
        }
        JSONArray datas = new JSONArray();
        JSONArray names = new JSONArray();
        for (String task : res.keySet()) {
            JSONObject data = new JSONObject();
            data.put("name", task);
            data.put("type", "line");
            data.put("stack", "总量");
            data.put("data", res.getObject(task, int[].class));
            data.put("itemStyle", style(true));
            datas.add(data);
            names.add(task);
        }
        JSONObject line = new JSONObject();
        line.put("time", timeData);
        line.put("datas", datas);
        line.put("names", names);
        return line;
    }

    public static void main(String[] args) {

    }

    public JSONObject barinfo(String name, int index) {
        LocalDate localDate = LocalDate.now().minusDays(6 - index);
        String time = DateUtil.dateFormat(localDate);

        return taskInfo(name, time);
    }

    public JSONObject taskInfo(String name, String time) {

        JSONArray times = new JSONArray();
        JSONObject count = new JSONObject();
        List<JSONObject> list = statisticsMapper.selectInfo(name, time + "%");
        int size = list.size();
        int i = 0;
        for (JSONObject obj : list) {
            times.add(obj.getString("startTime"));
            if (count.containsKey("新增")) {
                int[] arr = count.getObject("新增", int[].class);
                arr[i] += obj.getIntValue("task_insert");
            } else {
                int[] arr = new int[size];
                arr[i] += obj.getIntValue("task_insert");
                count.put("新增", arr);
            }

            if (count.containsKey("修改")) {
                int[] arr = count.getObject("修改", int[].class);
                arr[i] += obj.getIntValue("task_update");
            } else {
                int[] arr = new int[size];
                arr[i] += obj.getIntValue("task_update");
                count.put("修改", arr);
            }

            if (count.containsKey("失败")) {
                int[] arr = count.getObject("失败", int[].class);
                arr[i] += obj.getIntValue("task_error");
            } else {
                int[] arr = new int[size];
                arr[i] += obj.getIntValue("task_error");
                count.put("失败", arr);
            }

            if (count.containsKey("成功")) {
                int[] arr = count.getObject("成功", int[].class);
                arr[i] += obj.getIntValue("task_success");
            } else {
                int[] arr = new int[size];
                arr[i] += obj.getIntValue("task_success");
                count.put("成功", arr);
            }
            i++;
        }
        JSONArray datas = new JSONArray();
        JSONObject success = new JSONObject();
        success.put("name", "成功");
        success.put("type", "bar");
        success.put("stack", "总数");
        success.put("barWidth", 20);
        success.put("data", count.getObject("成功", int[].class));
        success.put("itemStyle", style());
        datas.add(success);

        JSONObject insert = new JSONObject();
        insert.put("name", "新增");
        insert.put("type", "bar");
        insert.put("stack", "其他");
        insert.put("barWidth", 20);
        insert.put("color", "green");
        insert.put("data", count.getObject("新增", int[].class));
        insert.put("itemStyle", style());
        datas.add(insert);

        JSONObject update = new JSONObject();
        update.put("name", "修改");
        update.put("type", "bar");
        update.put("stack", "其他");
        update.put("barWidth", 20);
        update.put("color", "yellow");
        update.put("data", count.getObject("修改", int[].class));
        update.put("itemStyle", style());
        datas.add(update);

        JSONObject error = new JSONObject();
        error.put("name", "失败");
        error.put("type", "bar");
        error.put("stack", "其他");
        error.put("barWidth", 20);
        error.put("color", "red");
        error.put("data", count.getObject("失败", int[].class));
        error.put("itemStyle", style());
        datas.add(error);
        JSONObject obj = new JSONObject();
        obj.put("times", times);
        obj.put("datas", datas);
        obj.put("taskname", name);
        obj.put("tasktime", time);
        return obj;
    }

    public JSONObject style() {
        return style(false);
    }

    public JSONObject style(boolean flag) {
        JSONObject textStyle = new JSONObject();
        textStyle.put("color", "black");
        textStyle.put("fontSize", 16);
        JSONObject label = new JSONObject();
        label.put("show", flag);
        label.put("position", "top");
        label.put("textStyle", textStyle);
        JSONObject normal = new JSONObject();
        normal.put("label", label);
        JSONObject itemStyle = new JSONObject();
        itemStyle.put("normal", normal);
        return itemStyle;
    }

    public JSONObject barinfocompare(String[] taskname, String starttime, String endtime) throws Exception {

        if (StringUtil.isNull(endtime)) {
            endtime = starttime + DateUtil.LAST_TIME;
        } else {
            endtime = endtime + DateUtil.LAST_TIME;
        }
        starttime = starttime + DateUtil.FIRST_TIME;

        JSONArray array =
                dataArray(starttime, endtime, taskname);
        //dataArrayTest(starttime,endtime,taskname);
        JSONObject data1 = new JSONObject();
        data1.put("name", "源库");
        data1.put("barWidth", 20);
        data1.put("color", "red");
        data1.put("type", "bar");
        data1.put("data", array.getObject(0, int[].class));
        data1.put("itemStyle", style());

        JSONObject data2 = new JSONObject();
        data2.put("name", "目标库");
        data2.put("barWidth", 20);
        data2.put("type", "bar");
        data2.put("color", "yellow");
        data2.put("data", array.getObject(1, int[].class));
        data2.put("itemStyle", style());
        JSONArray datas = new JSONArray();
        datas.add(data1);
        datas.add(data2);
        JSONObject obj = new JSONObject();
        obj.put("times", array.getObject(2, String[].class));
        obj.put("datas", datas);
        obj.put("taskname", taskname);
        obj.put("tasktimes", "[" + starttime + "-" + endtime + "]");
        obj.put("starttime", starttime);
        obj.put("endtime", endtime);
        return obj;

    }

    public JSONArray dataArray(String starttime, String endtime, String... taskNames) throws Exception {
        int length = taskNames.length;
        int[] arr1 = new int[length];
        int[] arr2 = new int[length];
        String[] arr3 = new String[length];
        //JSONArray array=new JSONArray();
        int i = 0;
        //try {
        for (String taskName : taskNames) {
            TaskTimer timerTask = mainService.getTimer(taskName);
            TaskBean taskBean= TaskFlowFactory.taskBean(timerTask);
            taskBean.init();
            DataReader dataReader=taskBean.getDataReader();
            if(dataReader instanceof Compare){

                int total;
                int goal;
                if(dataReader instanceof AllDataReader){
                    AllCompareDataReader reader=taskBean.convertReader();
                    total = reader.readCompareDataTotal();
                    goal = reader.readTargetDataTotal();
                }else if(dataReader instanceof AllTimeDataReader){
                    AllTimeCompareDataReader reader=taskBean.convertReader();
                    total = reader.readCompareDataTotal(starttime,endtime);
                    goal = reader.readTargetDataTotal(starttime,endtime);
                }else if(dataReader instanceof PageDataReader){
                    PageCompareDataReader reader=taskBean.convertReader();
                    total = reader.readCompareDataTotal();
                    goal = reader.readTargetDataTotal();
                }else if(dataReader instanceof PageTimeDataReader){
                    PageTimeCompareDataReader reader=taskBean.convertReader();
                    total = reader.readCompareDataTotal(starttime,endtime);
                    goal = reader.readTargetDataTotal(starttime,endtime);
                }else{
                    throw new SysException("不支持的 reader "+dataReader.getClass());
                }

                arr1[i] = total;

                /*if(dataReader instanceof AllDataReader){
                    AllCompareDataReader reader=taskBean.convertReader();

                }else if(dataReader instanceof AllTimeDataReader){
                    AllTimeCompareDataReader reader=taskBean.convertReader();

                }else if(dataReader instanceof PageDataReader){
                    PageCompareDataReader reader=taskBean.convertReader();

                }else if(dataReader instanceof PageTimeDataReader){
                    PageTimeCompareDataReader reader=taskBean.convertReader();

                }else{
                    throw new SysException("不支持的 reader "+dataReader.getClass());
                }*/
                arr2[i] = goal;
                taskBean.end();
            } else {
                throw new SysException(timerTask.getJobDesc() + "() 该任务不支持比对！");
            }
            /*String bean = timerTask.getBean();
            if ("CommonTask".equals(bean)) {
                int[] r = new int[2];

                r = commonService.compare(timerTask, starttime, endtime);

                arr1[i] = r[0];
                arr2[i] = r[1];
            } else {
                Object object = BaseSysinitBean.getBean(bean);
                CompareFace compareFace = CompareFace.class.cast(object);
                if (object instanceof CompareFace) {
                    int total = res(compareFace, starttime, endtime);
                    arr1[i] = total;
                    int goal = goal(compareFace, starttime, endtime);
                    arr2[i] = goal;
                } else {
                    throw new SysException(timerTask.getJobDesc() + "(" + bean + ") 该任务不支持比对！");
                }
            }*/
            arr3[i] = timerTask.getJobDesc();
            i++;
        }
        /*} catch (Exception e) {
            e.printStackTrace();
            throw new SysException(e.getMessage());
        } finally {
            ConnectionHolder.closeAll();
        }*/
        JSONArray array = new JSONArray();
        array.add(arr1);
        array.add(arr2);
        array.add(arr3);
        return array;
    }


    public JSONArray repeatinfos(String... taskNames) throws Exception {
        JSONArray array=new JSONArray();
        for (String taskName : taskNames) {
            JSONObject object=new JSONObject();
            TaskTimer timerTask = mainService.getTimer(taskName);
            TaskBean taskBean= TaskFlowFactory.taskBean(timerTask);
            taskBean.init();
            SaveWriter saveWriter=taskBean.getDataWriter();
            PrimaryKey tpk=saveWriter.goalId();
            PrimaryKey pk=saveWriter.sourceId();
            
            taskBean.end();
        }
        return array;
    }


    public JSONArray dataArrayTest(String starttime, String endtime, String... taskNames) throws Exception {
        int length = taskNames.length;
        int[] arr1 = new int[length];
        int[] arr2 = new int[length];
        String[] arr3 = new String[length];
        int i = 0;
        for (String taskName : taskNames) {
            TaskTimer timerTask = mainService.getTimer(taskName);
            String bean = timerTask.getBean();
            Object object = BaseSysinitBean.getBean(bean);
            if (object instanceof Compare) {
                int total = new Random().nextInt(100);
                arr1[i] = total;
                int goal = new Random().nextInt(100);
                arr2[i] = goal;
                arr3[i] = timerTask.getJobDesc();
            } else {
                throw new SysException(timerTask.getJobDesc() + "(" + bean + ") 该任务不支持比对！");
            }
            i++;
        }
        JSONArray array = new JSONArray();
        array.add(arr1);
        array.add(arr2);
        array.add(arr3);
        return array;
    }

    /*public int res(TaskBean compareFace, String starttime, String endtime) throws Exception {
        return compareFace.compareTotal(starttime, endtime);
    }

    public int goal(TaskBean compareFace, String starttime, String endtime) throws Exception {
        return compareFace.goalDataTotal(starttime, endtime);
    }*/
}
