package com.github.niupengyu.schedule.statistics.dao;

import com.alibaba.fastjson.JSONObject;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

public interface StatisticsMapper {

    @Select("select sum(task_success) as num," +
            "DATE_FORMAT(task_start,'%Y-%m-%d') as startTime," +
            "task_schedule as task " +
            "from guiyjz_schedule_task where task_type=#{type} " +
            "and task_start>=#{start} " +
            "group by startTime,task_schedule")
    public List<JSONObject> selectData(@Param("start") String start,@Param("type") String type);

    @Select("select CONCAT(DATE_FORMAT(task_next,'%T'),'-',DATE_FORMAT(task_previous,'%T'))  as startTime " +
            ",task_success,task_insert,task_update,task_error " +
            "from guiyjz_schedule_task " +
            "where task_start like #{time} " +
            " and task_schedule = #{name} ORDER BY task_start")
    public List<JSONObject> selectInfo(@Param("name") String name,@Param("time") String time);

}
