package com.github.niupengyu.schedule.statistics.controller;

import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.schedule.statistics.service.StatisticsService;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@RequestMapping("statisticsrest")
public class StatisticsApi extends ClientContent {

    @Resource(name = "statisticsService")
    private StatisticsService statisticsService;

    @RequestMapping("sevenday")
    public ResponseData sevenDay(){
        JSONObject obj=statisticsService.sevenDay();
        return this.rdSuccess(obj);
    }

    @RequestMapping("taskinfo")
    public ResponseData taskinfo(int index,String name){
        JSONObject data=statisticsService.barinfo(name,index);
        return rdSuccess(data);
    }

    @RequestMapping("barinfo")
    public ResponseData barinfo(String time,String name){
        JSONObject data=statisticsService.taskInfo(name,time);
        return rdSuccess(data);
    }

    @RequestMapping("barinfocompare")
    public ResponseData barinfocompare(String[] taskname,String starttime,String endtime) throws Exception {
        /*String [] str=new String[50];
        for(int i=0;i<50;i++){
            str[i]=taskname[0];
        }*/
        JSONObject data=statisticsService.barinfocompare(taskname,starttime,endtime);
        return rdSuccess(data);
    }

    @RequestMapping("repeatinfos")
    public ResponseData repeatinfos(String[] taskname) throws Exception {
        /*String [] str=new String[50];
        for(int i=0;i<50;i++){
            str[i]=taskname[0];
        }*/
        JSONArray data=statisticsService.repeatinfos(taskname);
        return rdSuccess(data);
    }

}
