/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.modules.test.proxy;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class StandardExecutorClassLoader
extends URLClassLoader {
    public StandardExecutorClassLoader(String baseDir, URL[] urls, ClassLoader classLoader) {
        super(urls, classLoader);
        this.loadResource(baseDir);
    }

    public void init() {
        try {
            this.addThisToParentClassLoader(StandardExecutorClassLoader.class.getClassLoader().getParent());
        }
        catch (Exception e) {
            System.err.println("\u8bbe\u7f6eclassloader\u5230\u5bb9\u5668\u4e2d\u65f6\u51fa\u73b0\u9519\u8bef\uff01");
        }
    }

    private void addThisToParentClassLoader(ClassLoader classLoader) throws Exception {
        Field field = ClassLoader.class.getDeclaredField("parent");
        field.setAccessible(true);
        field.set(classLoader, this);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return StandardExecutorClassLoader.class.getClassLoader().loadClass(name);
        }
    }

    private void loadResource(String baseDir) {
        String jarPath = baseDir;
        System.out.println("jarpath " + jarPath);
        this.tryLoadJarInDir(jarPath);
        this.tryLoadJarInDir(jarPath + File.separator + "lib");
    }

    private void tryLoadJarInDir(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        if (dir.exists() && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                System.out.println("jar file path " + file.getPath());
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                System.out.println("add jar " + file.getPath());
                this.addURL(file);
            }
        }
    }

    private void addURL(File file) {
        try {
            super.addURL(new URL("file", null, file.getCanonicalPath()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

