/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.modules.service;

import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.core.init.BaseSysinitBean;
import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.core.util.PageUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.schedule.beans.Module;
import com.github.niupengyu.schedule.common2.service.ModuleService;
import com.github.niupengyu.schedule.distributed.data.DistributeInfo;
import com.github.niupengyu.schedule.modules.context.ModuleBeanFactory;
import com.github.niupengyu.schedule.modules.context.ModuleContext;
import com.github.niupengyu.schedule.modules.mapper.ModulesMapper;
import com.github.niupengyu.schedule.modules.test.proxy.StandardExecutorClassLoader;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.context.support.StandardServletEnvironment;

@Service(value="moduleService")
public class ModuleServiceImpl
implements ApplicationContextAware,
ModuleService {
    private ApplicationContext act;
    private Map<String, ModuleContext> contextMap = new HashMap<String, ModuleContext>();
    @Autowired
    private Environment environment;
    @Autowired
    private ModulesMapper modulesMapper;

    public void loadModule(String id) {
        this.loadModule(this.modulesMapper.getModule(id));
    }

    public void loadModule(Module module) {
        ModuleBeanFactory beanFactory = new ModuleBeanFactory(((AnnotationConfigServletWebServerApplicationContext)this.act).getDefaultListableBeanFactory());
        GenericBeanDefinition definition = new GenericBeanDefinition();
        definition.setBeanClass(ConfigurationPropertiesBindingPostProcessor.class);
        definition.setRole(2);
        beanFactory.registerBeanDefinition(ConfigurationPropertiesBindingPostProcessor.BEAN_NAME, (BeanDefinition)definition);
        ModuleContext applicationContext = new ModuleContext(beanFactory);
        System.out.println(((Object)((Object)applicationContext)).getClass());
        URLClassLoader ucl = (URLClassLoader)this.act.getClassLoader();
        URL[] urls = ucl.getURLs();
        String baseDir = module.getPath();
        String dir = module.getModule();
        String version = module.getVersion();
        String packages = module.getPackages();
        StandardExecutorClassLoader classLoader = new StandardExecutorClassLoader(baseDir, urls, ucl);
        applicationContext.setClassLoader(classLoader);
        applicationContext.scan(new String[]{packages});
        applicationContext.setEnvironment((ConfigurableEnvironment)((StandardServletEnvironment)this.environment));
        applicationContext.refresh();
        applicationContext.start();
        this.contextMap.put(module.getId(), applicationContext);
        this.modulesMapper.update(module.getId(), 2);
    }

    public Object getBean(String id, String name) {
        if (this.contextMap.containsKey(id)) {
            ModuleContext moduleContext = this.contextMap.get(id);
            return moduleContext.getBean(name);
        }
        return this.act.getBean(name);
    }

    public JSONObject modules(String module, String state, int page, int size) {
        int start = PageUtil.start((int)page, (int)size);
        List<Module> data = this.modulesMapper.modules(module, state, start, size);
        int count = this.modulesMapper.modulesCount(module, state);
        for (Module obj : data) {
            String id = obj.getId();
            if (this.contextMap.containsKey(id)) {
                obj.setActive(this.contextMap.get(id).isActive());
            }
            obj.setActives(DistributeInfo.modulesActives((String)id));
        }
        JSONObject res = new JSONObject();
        res.put("data", data);
        res.put("total", (Object)count);
        return res;
    }

    public void saveModule(String name, String module, String version, String packages, File newFile) {
        this.modulesMapper.save(name, IdGeneratorUtil.uuid32(), module, version, packages, newFile.getPath());
    }

    public void initModules() {
        List<Module> modules = this.selectLoad();
        for (Module module : modules) {
            this.loadModule(module);
        }
    }

    public List<Module> selectLoad() {
        return this.modulesMapper.selectLoad();
    }

    public void uninstallModule(String id) {
        if (this.contextMap.containsKey(id)) {
            this.contextMap.remove(id);
        }
        this.modulesMapper.update(id, 1);
    }

    public String[] beans(String id) {
        if (StringUtil.isNull((Object)id) || !this.contextMap.containsKey(id)) {
            return BaseSysinitBean.getAc1().getBeanNamesForAnnotation(Service.class);
        }
        ModuleContext applicationContext = this.contextMap.get(id);
        String[] strings = applicationContext.getBeanNamesForAnnotation(Service.class);
        return strings;
    }

    public List modulesGroup() {
        return this.modulesMapper.selectGroup();
    }

    public boolean active(String tableId, String name) {
        if (this.contextMap.containsKey(tableId)) {
            ModuleContext moduleContext = this.contextMap.get(tableId);
            return moduleContext.containsBean(name);
        }
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.act = applicationContext;
    }

    public void loadModule() {
    }
}

