/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.util;

import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzManager {
    private static final Logger logger = LoggerFactory.getLogger(QuartzManager.class);

    private QuartzManager() {
    }

    public static void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class jobClass, String cron, Scheduler sched) throws SchedulerException {
        JobDetail job = JobBuilder.newJob((Class)jobClass).withIdentity(jobName, jobGroupName).build();
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.withIdentity(triggerName, triggerGroupName);
        triggerBuilder.startNow();
        triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
        CronTrigger trigger = (CronTrigger)triggerBuilder.build();
        sched.scheduleJob(job, (Trigger)trigger);
        if (!sched.isShutdown()) {
            sched.start();
        }
    }

    public static void addJobNow(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class jobClass, Scheduler sched) throws SchedulerException {
        JobDetail job = JobBuilder.newJob((Class)jobClass).withIdentity(jobName, jobGroupName).build();
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.withIdentity(triggerName, triggerGroupName);
        triggerBuilder.startNow();
        SimpleTriggerImpl trigger = (SimpleTriggerImpl)triggerBuilder.build();
        sched.scheduleJob(job, (Trigger)trigger);
        if (!sched.isShutdown()) {
            sched.start();
        }
    }

    public static void modifyJobTime(String triggerName, String triggerGroupName, String cron, Scheduler sched) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
        CronTrigger trigger = (CronTrigger)sched.getTrigger(triggerKey);
        if (trigger == null) {
            return;
        }
        String oldTime = trigger.getCronExpression();
        if (!oldTime.equalsIgnoreCase(cron)) {
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.withIdentity(triggerName, triggerGroupName);
            triggerBuilder.startNow();
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
            trigger = (CronTrigger)triggerBuilder.build();
            sched.rescheduleJob(triggerKey, (Trigger)trigger);
        }
    }

    public static boolean removeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Scheduler sched) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
        sched.pauseTrigger(triggerKey);
        boolean flag1 = sched.unscheduleJob(triggerKey);
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
        boolean flag = sched.deleteJob(jobKey);
        return flag;
    }

    public static void pauseJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Scheduler sched) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
        sched.pauseTrigger(triggerKey);
        sched.pauseJob(JobKey.jobKey((String)jobName, (String)jobGroupName));
    }

    public static void resumeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Scheduler sched) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
        sched.resumeTrigger(triggerKey);
        sched.resumeJob(JobKey.jobKey((String)jobName, (String)jobGroupName));
    }

    public static boolean unscheduleJob(String triggerName, String triggerGroupName, Scheduler sched) throws SchedulerException {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
        return sched.unscheduleJob(triggerKey);
    }

    public static void startJobs(Scheduler sched) {
        try {
            sched.start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void shutdownJobs(Scheduler sched) throws SchedulerException {
        if (!sched.isShutdown()) {
            sched.shutdown();
        }
    }

    public static void interrupt(Scheduler sched, String jobName, String jobGroupName) throws UnableToInterruptJobException {
        sched.interrupt(JobKey.jobKey((String)jobName, (String)jobGroupName));
    }
}

