/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.service;

import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.core.util.PageUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.bean.TaskTimer;
import com.github.niupengyu.schedule.common2.bean.common.Column;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.bean.common.Sql;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.exception.StopException;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.listener.service.ScheduleInfoService;
import com.github.niupengyu.schedule.mains.dao.ScheduleDao;
import com.github.niupengyu.schedule.mains.dao.TableMapperDao;
import com.github.niupengyu.schedule.mains.dao.TaskInfoDao;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taskInfoService")
class TaskInfoServiceImpl
implements TaskInfoService {
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TableMapperDao tableMapperDao;
    @Autowired
    private ScheduleDao scheduleDao;
    @Resource(name="scheduleInfoService")
    private ScheduleInfoService scheduleInfoService;
    private static final Logger logger = LoggerFactory.getLogger(TaskInfoServiceImpl.class);

    TaskInfoServiceImpl() {
    }

    public void exceptionInfos(List<Map<String, Object>> datas, String task, String message, int num) {
        JSONObject obj = new JSONObject();
        obj.put("method", (Object)"exceptionErrorInfos");
        obj.put("datas", datas);
        obj.put("task", (Object)task);
        obj.put("message", (Object)message);
        obj.put("num", (Object)num);
        try {
            logger.info("exceptionInfos ");
            this.scheduleInfoService.addInfo(obj);
        }
        catch (SysException e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    public void exceptionInfo(Map<String, Object> map, String task, String message, int num) {
        JSONObject obj = new JSONObject();
        obj.put("method", (Object)"exceptionErrorInfo");
        obj.put("data", map);
        obj.put("task", (Object)task);
        obj.put("message", (Object)message);
        obj.put("num", (Object)num);
        try {
            this.scheduleInfoService.addInfo(obj);
        }
        catch (SysException e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    public void exceptionInfo(String data, String task, String message, int num) {
        JSONObject obj = new JSONObject();
        obj.put("method", (Object)"exceptionStrErrorInfo");
        obj.put("data", (Object)data);
        obj.put("task", (Object)task);
        obj.put("message", (Object)message);
        obj.put("num", (Object)num);
        try {
            this.scheduleInfoService.addInfo(obj);
        }
        catch (SysException e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    public void updateTime(String name, String date) {
        this.scheduleDao.updateTime(name, date);
    }

    public TaskTimer getTimer(String name) {
        return this.scheduleDao.getByName(name);
    }

    public void exceptionInfo(String data, String task, String message) {
        JSONObject obj = new JSONObject();
        obj.put("method", (Object)"exceptionInfo");
        obj.put("data", (Object)data);
        obj.put("task", (Object)task);
        obj.put("message", (Object)message);
        try {
            this.scheduleInfoService.addInfo(obj);
        }
        catch (SysException e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    public void stopException() throws StopException {
        throw new StopException("\u4efb\u52a1\u88ab\u624b\u52a8\u505c\u6b62");
    }

    public void saveTaskInfo(TaskInfo taskInfo) {
        this.taskInfoDao.insertTask(taskInfo);
    }

    public void success(String id, int num) {
        this.taskInfoDao.success(id, num);
    }

    public void total(String id, int num) {
        this.taskInfoDao.total(id, num);
    }

    public void addTotal(String id, int num) {
        this.taskInfoDao.addTotal(id, num);
    }

    public void state(String id, int state) {
        Date date = new Date();
        this.taskInfoDao.state(id, state, date);
    }

    public void taskPageTotal(String id, int num) {
        this.taskInfoDao.taskPageTotal(id, num);
    }

    public void updatePage(String id, int page) {
        this.taskInfoDao.updatePage(id, page);
    }

    public List<TaskInfo> dayList(String name, String time) {
        String start = "";
        String end = "";
        if (StringUtil.notNull((Object)time)) {
            start = time + " 00:00:00";
            end = time + " 23:59:59";
        }
        return this.taskInfoDao.dayList(name, start, end);
    }

    public List<TaskInfo> dayNowList(String app, String name) {
        return this.taskInfoDao.dayNowList(app, name, "", "now", "", "", "");
    }

    public List<TaskInfo> allNowList(String app, String name, String timeFrame, String taskstate, String tasktype, String time) {
        String start = "";
        String end = "";
        if (StringUtil.notNull((Object)time)) {
            start = time + " 00:00:00";
            end = time + " 23:59:59";
        }
        return this.taskInfoDao.dayNowList(app, name, timeFrame, taskstate, tasktype, start, end);
    }

    public JSONObject allNowList(String app, String name, String timeFrame, String taskstate, String tasktype, String time, int page, int size) {
        String start = "";
        String end = "";
        if (StringUtil.isNull((Object)time)) {
            time = DateUtil.dateFormatDate();
        }
        start = time + " 00:00:00";
        end = time + " 23:59:59";
        int startPage = PageUtil.start((int)page, (int)size);
        List<TaskInfo> data = this.taskInfoDao.dayNowPageList(app, name, timeFrame, taskstate, tasktype, start, end, startPage, size);
        int count = this.taskInfoDao.dayNowPageCount(app, name, timeFrame, taskstate, tasktype, start, end);
        JSONObject res = new JSONObject();
        res.put("data", data);
        res.put("total", (Object)count);
        return res;
    }

    public List<TaskInfo> dayErrorList(String name) {
        return this.taskInfoDao.dayErrorList(name);
    }

    public void updateBatch(long day, int batchTotal, String id, int target) {
        this.taskInfoDao.updateBatch(day, batchTotal, id, target);
    }

    public void updateCurrentBatch(long day, String id) {
        this.taskInfoDao.updateCurrentBatch(day, id);
    }

    public void updateAddCurrentBatch(long day, String id) {
        this.taskInfoDao.updateAddCurrentBatch(day, id);
    }

    public void deleteInfo(String id) {
        this.taskInfoDao.deleteInfo(id);
    }

    public void update(String id, int i) {
        this.taskInfoDao.update(id, i);
    }

    public void insert(String id, int i) {
        this.taskInfoDao.insert(id, i);
    }

    public void updateSuccess(String id, int i, int success) {
        this.taskInfoDao.updateSuccess(id, i, success);
    }

    public void insertSuccess(String id, int i, int success) {
        this.taskInfoDao.insertSuccess(id, i, success);
    }

    public void insertUpdateSuccess(String id, int i, int u, int success) {
        this.taskInfoDao.insertUpdateSuccess(id, i, u, success);
    }

    public void insertUpdateDeleteSuccess(String id, int i, int u, int d, int success) {
        this.taskInfoDao.insertUpdateDeleteSuccess(id, i, u, d, success);
    }

    public List<TaskInfo> list(String id, String time) {
        return this.taskInfoDao.list(id, time);
    }

    public void updateDelete(String id, int i) {
        this.taskInfoDao.updateDelete(id, i);
    }

    public DbInfo selectDbInfo(String id) {
        return this.tableMapperDao.selectDbInfo(id);
    }

    public Table tableInfo(String id) {
        return this.tableMapperDao.tableInfo(id);
    }

    public List<Column> column(String id) {
        return this.tableMapperDao.column(id);
    }

    public Sql sql(String id) {
        return this.tableMapperDao.sql(id);
    }

    public void exceptionInfo(String data1, String id, String message, int num, int batch, int startPage, String taskStart, String taskEnd, boolean isDay, int size) {
        JSONObject obj = new JSONObject();
        obj.put("method", (Object)"exceptionPageErrorInfos");
        JSONObject data = new JSONObject();
        data.put("batch", (Object)batch);
        data.put("startPage", (Object)startPage);
        data.put("taskStart", (Object)taskStart);
        data.put("taskEnd", (Object)taskEnd);
        data.put("isDay", (Object)isDay);
        data.put("size", (Object)size);
        data.put("errorMessage", (Object)message);
        obj.put("data", (Object)data.toJSONString());
        obj.put("task", (Object)id);
        obj.put("message", (Object)data1);
        try {
            logger.info("exceptionPageErrorInfos ");
            this.scheduleInfoService.addInfo(obj);
        }
        catch (SysException e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    public void addRealTotal(String id, int size) {
        this.taskInfoDao.updateTealTotal(id, size);
    }
}

