/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.schedule.common2.job.QuartzJob;
import com.github.niupengyu.schedule.mains.bean.Plan;
import com.github.niupengyu.schedule.mains.dao.PlanDao;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.github.niupengyu.schedule.mains.util.QuartzManager;
import java.util.List;
import javax.annotation.Resource;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planService")
public class PlanService {
    @Autowired
    private PlanDao planDao;
    @Resource(name="mainService")
    private MainService mainService;
    private static final String PLAN = "_PLAN";
    @Resource(name="scheduler")
    private Scheduler scheduler;

    public void add(Plan plan) {
        plan.setName(plan.getTask() + PLAN);
        plan.setId(IdGeneratorUtil.uuid32());
        this.planDao.insert(plan);
    }

    public Plan selectOne(String id) {
        return this.planDao.selectPlan(id);
    }

    public List<Plan> selectList() {
        List<Plan> plans = this.planDao.selectPlans();
        for (Plan plan : plans) {
            plan.init(this.scheduler);
            System.out.println("tk " + plan);
        }
        return plans;
    }

    public void active(String id) throws Exception {
        Plan plan = this.selectOne(id);
        String cron = plan.getCron();
        QuartzManager.addJob(id, "planJobGroup", id + "trigger", "planTriggerGroup", QuartzJob.class, cron, this.scheduler);
        this.planDao.updateState(id, 1);
    }

    public void close(String id) throws Exception {
        QuartzManager.removeJob(id, "planJobGroup", id + "trigger", "planTriggerGroup", this.scheduler);
        this.planDao.updateState(id, 0);
    }

    public void updateStart(String id, String start) {
        this.planDao.updateStart(id, start);
    }
}

