/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.jdbc.dao.ConnectionFactory;
import com.github.niupengyu.jdbc.dao.JdbcDao;
import com.github.niupengyu.jdbc.dao.JdbcUtil;
import com.github.niupengyu.schedule.common2.bean.common.CodeInfo;
import com.github.niupengyu.schedule.common2.bean.common.Column;
import com.github.niupengyu.schedule.common2.bean.common.CreateInfo;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.bean.common.Sql;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.factory.LocalContext;
import com.github.niupengyu.schedule.common2.factory.SqlFactory;
import com.github.niupengyu.schedule.common2.factory.db.DBMetadata;
import com.github.niupengyu.schedule.common2.factory.dialect.GenSqlDialect;
import com.github.niupengyu.schedule.common2.factory.dialect.TargetGenSqlDialect;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.mains.dao.TableMapperDao;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.github.niupengyu.schedule.mains.util.TableSql;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mapperService")
public class MapperService {
    private static final Logger logger = LoggerFactory.getLogger(MapperService.class);
    @Resource(name="connectionFactory")
    private ConnectionFactory connectionFactory;
    @Autowired
    private TableMapperDao tableMapperDao;
    @Resource(name="mainService")
    private MainService mainService;
    @Resource(name="taskInfoService")
    private TaskInfoService taskInfoService;

    public List<String> tables(CreateInfo createInfo) throws Exception {
        DBMetadata sql = SqlFactory.getType((CreateInfo)createInfo, (TaskInfoService)this.taskInfoService);
        return sql.tables(createInfo);
    }

    public List<String> views(CreateInfo createInfo) throws Exception {
        DBMetadata sql = SqlFactory.getType((CreateInfo)createInfo, (TaskInfoService)this.taskInfoService);
        return sql.views(createInfo);
    }

    public Map<String, Object> pk(CreateInfo createInfo, String tableName) throws Exception {
        DBMetadata sql = SqlFactory.getType((CreateInfo)createInfo, (TaskInfoService)this.taskInfoService);
        return sql.pk(tableName);
    }

    public List<Map<String, Object>> columns(CreateInfo createInfo, String tableName) throws Exception {
        DBMetadata sql = SqlFactory.getType((CreateInfo)createInfo, (TaskInfoService)this.taskInfoService);
        return sql.tableColumns(createInfo.getOwner(), tableName);
    }

    public StringBuilder createTable(CreateInfo createInfo, String part) throws Exception {
        String[] tableNames = createInfo.getTableNames();
        StringBuilder stringBuilder = new StringBuilder();
        for (String tableName : tableNames) {
            List<Map<String, Object>> list = this.columns(createInfo, tableName);
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TABLE ").append(tableName).append(" ( \n");
            int length = list.size();
            int i = 0;
            for (Map<String, Object> map : list) {
                String scale;
                String columnName = StringUtil.valueOf((Object)map.get("COLUMN_NAME"));
                String comments = StringUtil.valueOf((Object)map.get("COMMENTS"));
                String type = StringUtil.valueOf((Object)map.get("DATA_TYPE")).toUpperCase();
                String typeStr = " String DEFAULT '' COMMENT '";
                if (type.indexOf("NUMBER") > -1 && !"".equals(scale = StringUtil.valueOf((Object)map.get("DATA_SCALE")))) {
                    int f = Integer.parseInt(scale);
                    typeStr = f > 0 ? " Float32 DEFAULT 0.0 COMMENT '" : " Int32 DEFAULT 0 COMMENT '";
                }
                if (type.indexOf("TIMESTAMP") > -1 || type.indexOf("DATE") > -1) {
                    typeStr = " DateTime DEFAULT now() COMMENT '";
                }
                sb.append(columnName).append(typeStr).append(comments).append("'");
                if (++i >= length) continue;
                sb.append(",\n ");
            }
            Map<String, Object> pk = this.pk(createInfo, tableName);
            sb.append("\n )  ENGINE = ReplacingMergeTree() PARTITION BY " + part + " ").append(" ORDER BY ").append(StringUtil.valueOf((Object)pk.get("COLUMN_NAME"), (String)"$ID")).append(" SETTINGS index_granularity = 8192");
            stringBuilder.append(sb.toString()).append("\n");
            stringBuilder.append("\n");
        }
        return stringBuilder;
    }

    public List<Map<String, Object>> exeSql(CreateInfo createInfo, String sqlselect, String sqlfrom, String sqlwhere) throws Exception {
        DBMetadata sql1 = SqlFactory.getType((CreateInfo)createInfo, (TaskInfoService)this.taskInfoService);
        return sql1.sqlColumn(sqlselect, sqlfrom, sqlwhere);
    }

    public void genCode(CodeInfo createInfo, List<Column> columns) throws Exception {
        DBMetadata sql = SqlFactory.getType((CreateInfo)createInfo, (TaskInfoService)this.taskInfoService);
        CreateInfo target = createInfo.getTarget();
        DBMetadata targetSql = SqlFactory.getType((CreateInfo)target, (TaskInfoService)this.taskInfoService);
        DbInfo dbInfo = sql.getDbInfo();
        DbInfo targetDbInfo = targetSql.getDbInfo();
        Table table = new Table(target, createInfo);
        this.checkTableName(table.getName());
        GenSqlDialect genSql = SqlFactory.gen((CodeInfo)createInfo, (DbInfo)dbInfo, columns);
        TargetGenSqlDialect targetGenSql = SqlFactory.targetGen((CodeInfo)createInfo, (DbInfo)targetDbInfo, columns);
        String count = genSql.total();
        String pagec = null;
        String listc = null;
        String countc = null;
        if (table.isComparesj()) {
            pagec = genSql.compareList();
            countc = genSql.compareTotal();
            listc = genSql.compareList();
        }
        String page = genSql.list();
        String list = genSql.list();
        String one = genSql.one();
        String max = genSql.max();
        String has = targetGenSql.has();
        String update = targetGenSql.update();
        String delete = targetGenSql.delete();
        String insert = targetGenSql.insert();
        String total = targetGenSql.total();
        String deletes = targetGenSql.deleteIn();
        String allList = targetGenSql.allList();
        Connection conn = null;
        PreparedStatement tableStmt = null;
        PreparedStatement sqlStmt = null;
        PreparedStatement columnStmt = null;
        try {
            conn = this.connectionFactory.createConn("scheduleDB");
            conn.setAutoCommit(false);
            tableStmt = conn.prepareStatement(TableSql.insertTable);
            sqlStmt = conn.prepareStatement(TableSql.insertSql);
            columnStmt = conn.prepareStatement(TableSql.insertColumn);
            tableStmt.setString(1, table.getId());
            tableStmt.setString(2, table.getTargetDb());
            tableStmt.setString(3, table.getDb());
            tableStmt.setString(4, table.getTn());
            tableStmt.setString(5, table.getModel());
            tableStmt.setBoolean(6, table.isPage());
            tableStmt.setBoolean(7, table.isBatch());
            tableStmt.setBoolean(8, table.isGxsjc());
            tableStmt.setBoolean(9, table.isComparesj());
            tableStmt.setString(10, table.getComparesjValue());
            tableStmt.setString(11, table.getTtn());
            tableStmt.setString(12, genSql.getBaseSql());
            tableStmt.setString(13, table.getName());
            tableStmt.setInt(14, 1);
            tableStmt.setString(15, createInfo.getExemodel());
            tableStmt.setString(16, table.getPk());
            tableStmt.setString(17, table.getTargetpk());
            tableStmt.setBoolean(18, table.isMin());
            tableStmt.setString(19, table.getMinsj());
            tableStmt.setBoolean(20, table.isPkReplace());
            tableStmt.setString(21, target.getDbType());
            tableStmt.setString(22, createInfo.getDbType());
            tableStmt.setString(23, createInfo.getGxsjcValue());
            tableStmt.setString(24, createInfo.getTargetComparesjValue());
            tableStmt.setString(25, createInfo.getSyncMode());
            tableStmt.setBoolean(26, createInfo.getTimeOrder());
            tableStmt.setString(27, createInfo.getTarget().getOwner());
            tableStmt.setString(28, createInfo.getOwner());
            tableStmt.execute();
            sqlStmt.setString(1, IdGeneratorUtil.uuid32());
            sqlStmt.setString(2, table.getId());
            sqlStmt.setString(3, count);
            sqlStmt.setString(4, page);
            sqlStmt.setString(5, countc);
            sqlStmt.setString(6, pagec);
            sqlStmt.setString(7, one);
            sqlStmt.setString(8, max);
            sqlStmt.setString(9, has);
            sqlStmt.setString(10, update);
            sqlStmt.setString(11, delete);
            sqlStmt.setString(12, insert);
            sqlStmt.setString(13, total);
            sqlStmt.setString(14, deletes);
            sqlStmt.setString(15, createInfo.getMinsj());
            sqlStmt.setString(16, list);
            sqlStmt.setString(17, listc);
            sqlStmt.setString(18, allList);
            sqlStmt.execute();
            int i = 1;
            for (Column column : columns) {
                columnStmt.setString(1, IdGeneratorUtil.uuid32());
                columnStmt.setString(2, table.getId());
                columnStmt.setString(3, column.getName1());
                columnStmt.setString(4, column.getDataType());
                columnStmt.setString(5, column.getKey1());
                columnStmt.setString(6, column.getDefaultValue());
                columnStmt.setBoolean(7, column.isPk());
                columnStmt.setInt(8, column.getState());
                columnStmt.setInt(9, i);
                columnStmt.setBoolean(10, column.isUpdate1());
                columnStmt.setBoolean(11, column.isSelect1());
                columnStmt.setBoolean(12, column.isGxsjc());
                columnStmt.setBoolean(13, column.isCompare());
                columnStmt.setBoolean(14, column.isConvertData());
                columnStmt.setString(15, column.getSourceType());
                columnStmt.setString(16, column.getFormat());
                ++i;
                columnStmt.addBatch();
            }
            columnStmt.executeBatch();
            conn.commit();
        }
        catch (Exception e) {
            try {
                JdbcDao.rollback((Connection)conn);
                e.printStackTrace();
                throw new SysException(e.getMessage());
            }
            catch (Throwable throwable) {
                JdbcDao.closeStmt((Statement[])new Statement[]{tableStmt, sqlStmt, columnStmt});
                JdbcDao.closeConn((Connection)conn);
                tableStmt = null;
                sqlStmt = null;
                columnStmt = null;
                conn = null;
                throw throwable;
            }
        }
        JdbcDao.closeStmt((Statement[])new Statement[]{tableStmt, sqlStmt, columnStmt});
        JdbcDao.closeConn((Connection)conn);
        tableStmt = null;
        sqlStmt = null;
        columnStmt = null;
        conn = null;
    }

    private void checkTableName(String name) throws SysException {
        Map<String, Object> map = this.tableMapperDao.tableName(name);
        if (StringUtil.mapNotNull(map)) {
            throw new SysException("\u6570\u636e\u5e93\u540d\u79f0\u5df2\u5b58\u5728 [" + name + "]");
        }
    }

    public Table tableinfo(String id) {
        return this.tableMapperDao.tableInfo(id);
    }

    public List<Column> columnList(String id) {
        return this.tableMapperDao.column(id);
    }

    public List<Column> columnList(Table table) throws Exception {
        List list;
        String id = table.getId();
        List<Column> columns = this.tableMapperDao.column(id);
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        for (Column column : columns) {
            String name = column.getName1();
            columnMap.put(name, column);
        }
        String model = table.getSyncMode();
        DBMetadata dbMetadata = SqlFactory.getType((Table)table, (TaskInfoService)this.taskInfoService);
        if ("sql".equals(model)) {
            JSONObject selectBean = JSONObject.parseObject((String)table.getTableSql());
            list = dbMetadata.sqlColumn(selectBean.getString("select"), selectBean.getString("from"), selectBean.getString("where"));
        } else {
            list = dbMetadata.tableColumns(table.getOwner(), table.getTn());
        }
        for (Map map : list) {
            Column column;
            String columnName = StringUtil.valueOf(map.get("COLUMN_NAME"));
            String dataType = StringUtil.valueOf(map.get("DATA_TYPE"));
            String dataLength = StringUtil.valueOf(map.get("DATA_LENGTH"));
            String commons = StringUtil.valueOf(map.get("COMMENTS"));
            if (columnMap.containsKey(columnName)) {
                column = (Column)columnMap.get(columnName);
                column.setSourceDataType(dataType);
                continue;
            }
            column = new Column();
            column.setId(IdGeneratorUtil.uuid32());
            column.setName1(columnName);
            column.setKey1(columnName);
            column.setSourceDataType(dataType);
            column.setDataLength(dataLength);
            column.setCommon(commons);
            column.setChecked(false);
            column.setDefaultValue("<\u65e0>");
            columns.add(column);
        }
        return columns;
    }

    public Sql sqlInfo(String id) {
        return this.tableMapperDao.sql(id);
    }

    public void initConnectionHolder(String dbId, String targetDbId) throws Exception {
        DbInfo dbInfo = this.selectDbInfo(dbId);
        DbInfo targetDbInfo = this.selectDbInfo(targetDbId);
        LocalContext.setJdbcDao((DbInfo)dbInfo, (DbInfo)targetDbInfo);
    }

    public DbInfo selectDbInfo(String id) {
        DbInfo dbInfo = this.tableMapperDao.selectDbInfo(id);
        return dbInfo;
    }

    public DbInfo selectDbInfoName(String name) {
        DbInfo dbInfo = this.tableMapperDao.selectDbInfoName(name);
        return dbInfo;
    }

    public void initdb() {
        logger.info("\u521d\u59cb\u5316\u6570\u636e\u5e93\u7c7b\u578b");
        List<JSONObject> db = this.mainService.supportDb();
        SqlFactory.initDb(db);
        logger.info("\u521d\u59cb\u5316\u65b9\u8a00");
        List<JSONObject> dialect = this.mainService.supportDialect("source");
        List<JSONObject> targetDialect = this.mainService.supportDialect("target");
        SqlFactory.initDialect(dialect);
        SqlFactory.initTargetDialect(targetDialect);
        logger.info("\u5b8c\u6210\u521d\u59cb\u5316");
    }

    public void genCodes(CodeInfo codeInfo) throws Exception {
        String[] targetPks = codeInfo.getTargetpk().split(",");
        List<String> set = Arrays.asList(targetPks);
        for (String table : codeInfo.getTableNames()) {
            List<Map<String, Object>> columnList = this.columns((CreateInfo)codeInfo, table);
            ArrayList<Column> columns = new ArrayList<Column>();
            for (Map<String, Object> map : columnList) {
                String key = StringUtil.valueOf((Object)map.get("COLUMN_NAME"));
                String defaultValue = "<\u65e0>";
                String defaultType = this.setType(map);
                Column column = new Column();
                column.setName1(key);
                column.setKey1(key);
                column.setDefaultValue(StringUtil.valueOf((String)defaultValue));
                column.setDataType(defaultType);
                if (set.contains(column.getKey1())) {
                    column.setUpdate1(false);
                    column.setPk(true);
                } else {
                    column.setUpdate1(true);
                    column.setPk(false);
                }
                column.setState(1);
                column.setCompare(codeInfo.isComparesj() && key.equals(codeInfo.getComparesjValue()));
                column.setGxsjc(codeInfo.isGxsjc() && key.equals(codeInfo.getGxsjcValue()));
                columns.add(column);
            }
            boolean rksj = codeInfo.isRksj();
            if (rksj) {
                Column insert = new Column();
                insert.setPk(false);
                insert.setDataType("Timestamp");
                insert.setName1(codeInfo.getInsertTime());
                insert.setKey1(codeInfo.getInsertTime());
                insert.setUpdate1(false);
                insert.setDefaultValue("now");
                insert.setSelect1(false);
                insert.setState(1);
                Column update = new Column();
                update.setPk(false);
                update.setDataType("Timestamp");
                update.setKey1(codeInfo.getUpdateTime());
                update.setName1(codeInfo.getUpdateTime());
                update.setUpdate1(true);
                update.setDefaultValue("now");
                update.setSelect1(false);
                update.setState(1);
                columns.add(insert);
                columns.add(update);
            }
            codeInfo.setTargetTable(table);
            codeInfo.setSyncName(table);
            codeInfo.setTableName(table);
            this.genCode(codeInfo, columns);
        }
    }

    private String setType(Map<String, Object> map) {
        String scale;
        String type = StringUtil.valueOf((Object)map.get("DATA_TYPE")).toUpperCase();
        String typeStr = "String";
        if (type.indexOf("NUMBER") > -1 && !"".equals(scale = StringUtil.valueOf((Object)map.get("DATA_SCALE")))) {
            int f = Integer.parseInt(scale);
            typeStr = f > 0 ? "Double" : "Int";
        }
        if (type.indexOf("TIMESTAMP") > -1 || type.indexOf("DATE") > -1) {
            typeStr = "Timestamp";
        }
        return typeStr;
    }

    public void deleteTable(String[] ids) {
        for (String id : ids) {
            this.tableMapperDao.deleteTable(id);
            this.tableMapperDao.deleteColumns(id);
            this.tableMapperDao.deleteSql(id);
        }
    }

    public void updateTable(Table table) throws Exception {
    }

    private Sql createSql(Table table, List<Column> columns) throws Exception {
        DbInfo dbInfo = this.tableMapperDao.selectDbInfo(table.getDb());
        DbInfo targetDbInfo = this.tableMapperDao.selectDbInfo(table.getTargetDb());
        GenSqlDialect genSql = SqlFactory.gen((Table)table, (DbInfo)dbInfo);
        TargetGenSqlDialect targetGenSql = SqlFactory.targetGen((Table)table, (DbInfo)targetDbInfo, columns);
        String count = genSql.total();
        String pagec = null;
        String listc = null;
        String countc = null;
        String page = genSql.list();
        String list = genSql.list();
        String one = genSql.one();
        String max = genSql.max();
        String has = targetGenSql.has();
        String update = targetGenSql.update();
        String delete = targetGenSql.delete();
        String insert = targetGenSql.insert();
        String total = targetGenSql.total();
        String deletes = targetGenSql.deleteIn();
        String allList = targetGenSql.allList();
        Sql sql = new Sql();
        sql.setId(IdGeneratorUtil.uuid32());
        sql.setTotalSql(count);
        sql.setPageListSql(page);
        sql.setListSql(list);
        sql.setSelectOneSql(one);
        sql.setMaxSql(max);
        sql.setHasOneSql(has);
        sql.setUpdateSql(update);
        sql.setDeleteSql(delete);
        sql.setInsertSql(insert);
        sql.setUpdateSql(update);
        sql.setDeleteInSql(deletes);
        sql.setTable1(table.getId());
        if (table.isComparesj()) {
            pagec = genSql.compareList();
            countc = genSql.compareTotal();
            listc = genSql.compareList();
            sql.setComparePageListSql(pagec);
            sql.setCompareListSql(listc);
            sql.setCompareTotalSql(countc);
            sql.setTargetCompareTotalSql(total);
        }
        sql.setTargetCompareAllListSql(allList);
        return sql;
    }

    public void updateColumn(String id, List<Column> list, String pkColumn, String targetPkColumn, String compareColumn, boolean compare, String targetCompareColumn, boolean gxsjc, String gxsjcColumn, boolean pkReplace, boolean page) throws SysException {
        if (StringUtil.isNull((Object)pkColumn)) {
            throw new SysException("\u4e3b\u952e\u6ca1\u6709\u8bbe\u7f6e");
        }
        try (JdbcUtil jdbcUtil = null;){
            String pk = pkColumn.substring(1);
            String tpk = targetPkColumn.substring(1);
            jdbcUtil = new JdbcUtil();
            jdbcUtil.setConnection(this.connectionFactory.createConn("scheduleDB"));
            String updateTable = "update guiyjz_schedule_table set table_pk=?,table_tpk=?,table_isgxsjc=?,table_iscomparesj=?,table_comparesj=?,table_target_comparesj=?,table_gxsjc=?,table_pk_replace=?,table_ispage=? where table_id=?";
            jdbcUtil.executeUpdate(updateTable, new Object[]{pk, tpk, gxsjc, compare, compareColumn, targetCompareColumn, gxsjcColumn, pkReplace, page, id});
            String deleteColumns = "delete from guiyjz_schedule_table_column where column_table=?";
            jdbcUtil.executeUpdate(deleteColumns, new Object[]{id});
            ArrayList<Object[]> objectList = new ArrayList<Object[]>();
            for (Column column : list) {
                Object[] objects = new Object[]{column.getId(), id, column.getName1(), column.getDataType(), column.getKey1(), column.getDefaultValue(), column.isPk(), column.getState(), column.getIndex1(), column.isUpdate1(), column.isSelect1(), column.isGxsjc(), column.isCompare(), column.isConvertData(), column.getSourceType(), column.getFormat()};
                objectList.add(objects);
            }
            jdbcUtil.executeBatch(TableSql.insertColumn, objectList);
            Table table = this.tableMapperDao.tableInfo(id);
            table.setComparesj(compare);
            table.setPk(pk);
            table.setTargetpk(tpk);
            table.setComparesjValue(compareColumn);
            table.setTargetComparesjValue(targetCompareColumn);
            table.setGxsjc(gxsjc);
            table.setGxsjcValue(gxsjcColumn);
            table.setPkReplace(pkReplace);
            table.setPage(page);
            Sql sql = this.createSql(table, list);
            String insertSql = "update guiyjz_schedule_table_sql set sql_count=?,sql_page=?,sql_countc=?,sql_pagec=?,sql_one=?,sql_max=?,sql_g_has=?,sql_g_update=?,sql_g_delete=?,sql_g_insert=?,sql_g_totalc=?,sql_g_deletes=?,sql_listc=?,sql_list=?,sql_minsj=?,sql_all_list=? where sql_table=? ";
            jdbcUtil.executeUpdate(insertSql, new Object[]{sql.getTotalSql(), sql.getPageListSql(), sql.getCompareTotalSql(), sql.getComparePageListSql(), sql.getSelectOneSql(), sql.getMaxSql(), sql.getHasOneSql(), sql.getUpdateSql(), sql.getDeleteSql(), sql.getInsertSql(), sql.getTargetCompareTotalSql(), sql.getDeleteInSql(), sql.getCompareListSql(), sql.getListSql(), sql.getMinSql(), sql.getTargetCompareAllListSql(), id});
            jdbcUtil.commit();
        }
    }

    public static void main(String[] args) {
    }

    public JSONArray datatotal(String[] taskNames) throws Exception {
        JSONArray jsonArray = new JSONArray();
        for (String taskName : taskNames) {
            Table table = this.tableMapperDao.tableInfo(taskName);
            DbInfo dbInfo = this.tableMapperDao.selectDbInfo(table.getDb());
            String pk = table.getPk();
            String tableName = table.getTn();
            String model = table.getSyncMode();
            Map<String, Object> d = this.setData(taskName, pk, tableName, model, dbInfo);
            jsonArray.add(d);
        }
        return jsonArray;
    }

    private Map<String, Object> setData(String taskName, String pk, String tableName, String model, DbInfo dbInfo) throws Exception {
        if ("sql".equals(model) || pk.split(",").length > 1) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total", -1);
            map.put("distotal", -1);
            map.put("name", taskName);
            return map;
        }
        String owner = dbInfo.getOwner();
        String sql = "select count(" + pk + ") as total,count(distinct " + pk + ") as distotal from " + (StringUtil.isNull((Object)owner) ? "" : owner + ".") + tableName;
        JdbcDao jdbcDao = new JdbcDao(SqlFactory.dataSourceConnection((DbInfo)dbInfo));
        Map map = jdbcDao.getOne(sql);
        map.put("name", taskName);
        return map;
    }

    public JSONArray datattotal(String[] taskNames) throws Exception {
        JSONArray jsonArray = new JSONArray();
        for (String taskName : taskNames) {
            Table table = this.tableMapperDao.tableInfo(taskName);
            DbInfo tdbInfo = this.tableMapperDao.selectDbInfo(table.getTargetDb());
            String tpk = table.getTargetpk();
            String targetTableName = table.getTtn();
            String model = table.getSyncMode();
            jsonArray.add(this.setData(taskName, tpk, targetTableName, model, tdbInfo));
        }
        return jsonArray;
    }
}

