/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.core.util.PageUtil;
import com.github.niupengyu.core.util.PinYin2Abbreviation;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.jdbc.bean.DataSourceBean;
import com.github.niupengyu.jdbc.dao.ConnectionFactory;
import com.github.niupengyu.schedule.beans.LocalTaskInfo;
import com.github.niupengyu.schedule.common2.bean.PrimaryKey;
import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.bean.TaskTimer;
import com.github.niupengyu.schedule.common2.bean.TimerParam;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.exception.StopException;
import com.github.niupengyu.schedule.common2.face.reader.base.DataReader;
import com.github.niupengyu.schedule.common2.face.writer.base.SaveWriter;
import com.github.niupengyu.schedule.common2.factory.TaskFlowFactory;
import com.github.niupengyu.schedule.common2.job.QuartzJob;
import com.github.niupengyu.schedule.common2.job.ThreadJob;
import com.github.niupengyu.schedule.common2.job.ThreadModel;
import com.github.niupengyu.schedule.common2.log.LoggerManager;
import com.github.niupengyu.schedule.common2.model.TaskFlow;
import com.github.niupengyu.schedule.common2.service.ModuleService;
import com.github.niupengyu.schedule.common2.service.TaskBean;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.common2.util.ServiceUtil;
import com.github.niupengyu.schedule.distributed.client.service.LocalTaskService;
import com.github.niupengyu.schedule.mains.dao.ScheduleDao;
import com.github.niupengyu.schedule.mains.dao.TableMapperDao;
import com.github.niupengyu.schedule.mains.service.ExceptionService;
import com.github.niupengyu.schedule.mains.util.QuartzManager;
import com.github.niupengyu.schedule.mains.util.ThreadPool;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mainService")
public class MainService
implements LocalTaskService {
    private static final Logger logger = LoggerFactory.getLogger(MainService.class);
    private boolean independentRunningMode = true;
    @Resource(name="scheduler")
    private Scheduler scheduler;
    public static Map<String, ThreadModel> map = new HashMap<String, ThreadModel>();
    @Resource(name="exceptionService")
    private ExceptionService exceptionService;
    @Resource(name="taskInfoService")
    private TaskInfoService taskInfoService;
    @Resource(name="connectionFactory")
    private ConnectionFactory connectionFactory;
    @Autowired
    private ScheduleDao scheduleDao;
    @Autowired
    private TableMapperDao tableMapperDao;
    @Resource(name="moduleService")
    private ModuleService moduleService;

    private void startTimerNow(TimerParam param) throws Exception {
        ThreadModel threadJob;
        String name = param.getName();
        if (map.containsKey(name) && (threadJob = map.get(name)).isRunning()) {
            throw new Exception("\u6b63\u5728\u8fd0\u884c");
        }
        TaskTimer taskTimer = this.getTimer(name);
        ThreadJob runnable = null;
        runnable = new ThreadJob(param, taskTimer);
        map.put(name, (ThreadModel)runnable);
        ThreadPool.pools.execute((Runnable)runnable);
    }

    private void startTimer(Object message) throws Exception {
        TaskTimer taskTimer = this.getTimer(String.valueOf(message));
        Class<?> jobClass = Class.forName(taskTimer.getTimerpackage());
        QuartzManager.addJob(taskTimer.getName(), taskTimer.getJobGroup(), taskTimer.getTigger(), taskTimer.getTiggerGroup(), jobClass, taskTimer.getTime(), this.scheduler);
    }

    private void stopTimer(Object message) throws ClassNotFoundException, SchedulerException {
        TaskTimer taskTimer = this.getTimer(String.valueOf(message));
        QuartzManager.removeJob(taskTimer.getName(), taskTimer.getJobGroup(), taskTimer.getTigger(), taskTimer.getTiggerGroup(), this.scheduler);
        taskTimer.stop();
    }

    public boolean isIndependentRunningMode() {
        return this.independentRunningMode;
    }

    public void setIndependentRunningMode(boolean independentRunningMode) {
        this.independentRunningMode = independentRunningMode;
    }

    public void startNow(TimerParam param) throws Exception {
        if (!this.isIndependentRunningMode()) {
            throw new SysException("\u4e0d\u662f\u72ec\u7acb\u8fd0\u884c\u6a21\u5f0f");
        }
        this.startTimerNow(param);
    }

    public void startAll() throws Exception {
        List<TaskTimer> list = this.getTimerList("", "", "", "", 0, 0);
        for (TaskTimer taskTimer : list) {
            Class<?> jobClass = null;
            jobClass = Class.forName(taskTimer.getTimerpackage());
            QuartzManager.addJob(taskTimer.getName(), taskTimer.getJobGroup(), taskTimer.getTigger(), taskTimer.getTiggerGroup(), jobClass, taskTimer.getTime(), this.scheduler);
        }
    }

    public TaskTimer getTimerInfo(String key) {
        TaskTimer taskTimer = this.getTimer(key);
        return taskTimer;
    }

    public JSONObject getTimerInfos(String type, String jobName, String app, String bindTask, int page, int size) {
        int start = PageUtil.start((int)page, (int)size);
        int total = this.scheduleDao.total(type, jobName, app, bindTask);
        List<TaskTimer> list = this.getTimerList(type, jobName, app, bindTask, start, size);
        JSONObject obj = new JSONObject();
        obj.put("total", (Object)total);
        obj.put("list", list);
        return obj;
    }

    public List<TaskTimer> getAllTimerInfos(String name, String app, String bindTask) {
        List<TaskTimer> list = this.scheduleDao.list("", name, app, bindTask, 0, 0);
        return list;
    }

    public void stop(String key) throws Exception {
        if (!this.isIndependentRunningMode()) {
            throw new SysException("\u4e0d\u662f\u72ec\u7acb\u8fd0\u884c\u6a21\u5f0f");
        }
        this.stopTimer(key);
    }

    public void restart(String id) {
    }

    public void add(TaskTimer taskTimer, String cron) throws Exception {
        if (StringUtil.isNull((Object)taskTimer)) {
            throw new Exception("\u672a\u627e\u5230\u4efb\u52a1");
        }
        if (StringUtil.isNull((Object)taskTimer.getTime())) {
            throw new Exception("\u6ca1\u6709\u586b\u5199\u4efb\u52a1\u65f6\u95f4");
        }
        Object saveWriter = null;
        String bean = taskTimer.getBean();
        if (StringUtil.isNull((Object)bean)) {
            throw new Exception("\u6ca1\u6709\u586b\u5199bean\u5bf9\u8c61");
        }
        Class<QuartzJob> jobClass = QuartzJob.class;
        QuartzManager.addJob(taskTimer.getName(), taskTimer.getJobGroup(), taskTimer.getTigger(), taskTimer.getTiggerGroup(), jobClass, StringUtil.isNull((Object)cron) ? taskTimer.getTime() : cron, this.scheduler);
    }

    public void add(String key, String cron) throws Exception {
        TaskTimer taskTimer = this.getTimer(key);
        this.add(taskTimer, cron);
    }

    public void remove(String key) throws SchedulerException {
        TaskTimer taskTimer = this.getTimer(key);
        QuartzManager.removeJob(taskTimer.getName(), taskTimer.getJobGroup(), taskTimer.getTigger(), taskTimer.getTiggerGroup(), this.scheduler);
    }

    public void removeall() throws SchedulerException {
        List<TaskTimer> list = this.getTimerList("", "", "", "", 0, 0);
        for (TaskTimer taskTimer : list) {
            Object jobClass = null;
            boolean flag = QuartzManager.removeJob(taskTimer.getName(), taskTimer.getJobGroup(), taskTimer.getTigger(), taskTimer.getTiggerGroup(), this.scheduler);
            logger.info("flag " + flag);
        }
    }

    public String uppercase(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public List<TaskTimer> getTimerList(String type, String jobName, String app, String bindTask, int start, int size) {
        List<TaskTimer> list = this.scheduleDao.list(type, jobName, app, bindTask, start, size);
        for (int i = 0; i < list.size(); ++i) {
            TaskTimer timer = list.get(i);
            String name = timer.getName();
            String jobType = timer.getJobType();
            if (map.containsKey(name)) {
                boolean run = map.get(name).isRunning();
                timer.setStatus(run);
            }
            if (StringUtil.notNull((Object)timer.getTableId()) && !timer.getJobType().equals("CommonTask")) {
                timer.setActive(this.moduleService.active(timer.getTableId(), timer.getBean()));
            }
            timer.init(this.scheduler);
        }
        return list;
    }

    public List<JSONObject> timer() {
        return this.scheduleDao.timer("TIMER");
    }

    public TaskTimer getTimer(String name) {
        return this.scheduleDao.getByName(name);
    }

    public TaskTimer getTimerById(String id) {
        return this.scheduleDao.getById(id);
    }

    public void stopNow(TimerParam param) {
        ThreadModel threadJob;
        String name = param.getName();
        if (map.containsKey(name) && (threadJob = map.get(name)).isRunning()) {
            threadJob.setRunning(false);
        }
    }

    public void resynchronization(String id) throws Exception {
        JSONObject errorData = this.exceptionService.selectBean(id);
        String bean = StringUtil.valueOf((Object)errorData.get((Object)"bean"));
        if (StringUtil.isNull((Object)bean)) {
            throw new Exception("\u6ca1\u6709\u914d\u7f6e\u5bf9\u5e94\u5b9e\u4f8b" + bean);
        }
        String type = errorData.getString("jobType");
        String tid = errorData.getString("tableId");
        String beanName = errorData.getString("bean");
        String name = errorData.getString("name");
        TimerParam param = TaskTimer.paramJson((String)errorData.getString("param"));
        TaskBean taskBean = TaskFlowFactory.taskBean((String)type, (String)tid, (String)beanName, (String)name, (int)0, (TimerParam)param);
        taskBean.createModel();
        taskBean.init();
        LoggerManager.createLogger((String)name);
        JSONObject data = errorData.getJSONObject("data");
        SaveWriter dataWriter = taskBean.getDataWriter();
        try {
            PrimaryKey primaryKey = dataWriter.selectId((Map)data);
            taskBean.syncData(primaryKey);
            this.exceptionService.updateState(id, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SysException(e.getMessage());
        }
        finally {
            taskBean.end();
        }
    }

    public void resynchronizationPage(String id) throws Exception {
        JSONObject errorData = this.exceptionService.selectBean(id);
        String bean = StringUtil.valueOf((Object)errorData.get((Object)"bean"));
        if (StringUtil.isNull((Object)bean)) {
            throw new Exception("\u6ca1\u6709\u914d\u7f6e\u5bf9\u5e94\u5b9e\u4f8b" + bean);
        }
        String type = errorData.getString("jobType");
        String tid = errorData.getString("tableId");
        String beanName = errorData.getString("bean");
        String name = errorData.getString("name");
        JSONObject pageData = errorData.getJSONObject("data");
        final int batch = pageData.getIntValue("batch");
        final int page = pageData.getIntValue("startPage");
        final String startTime = pageData.getString("taskStart");
        final String endTime = pageData.getString("taskEnd");
        boolean isDay = pageData.getBooleanValue("isDay");
        final int size = pageData.getIntValue("size");
        int exeBatch = errorData.getIntValue("batch");
        TimerParam param = new TimerParam();
        param.setName(name);
        param.setPreviousFireTime(startTime);
        param.setNextFireTime(endTime);
        param.setDay(Boolean.valueOf(isDay));
        param.setBatch(Integer.valueOf(batch));
        param.setStartPage(Integer.valueOf(page));
        param.setSize(Integer.valueOf(size));
        TaskInfo taskInfo = new TaskInfo(new Date(), name, startTime, endTime, "REPAGE");
        final String taskId = taskInfo.getId();
        final TaskFlow taskFlow = TaskFlowFactory.taskFlow((String)type, (String)tid, (String)beanName, (String)name, (int)exeBatch, (TimerParam)param);
        LoggerManager.createLogger((String)name);
        this.taskInfoService.saveTaskInfo(taskInfo);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    taskFlow.getTaskBean().init();
                    taskFlow.runSyncOne(startTime, endTime, taskId, size, page, batch);
                    MainService.this.taskInfoService.state(taskId, 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (StopException e) {
                    e.printStackTrace();
                }
                finally {
                    if (taskFlow != null) {
                        taskFlow.getTaskBean().end(taskId);
                    }
                }
            }
        });
        thread.start();
        this.exceptionService.updateState(id, 1);
    }

    public void resynchronizationall(String id) throws Exception, StopException {
        List<JSONObject> errorDatas = this.exceptionService.listJson(id);
        this.resynchronizations(errorDatas);
    }

    public void resynchronizations(String[] ids) throws Exception, StopException {
        List<JSONObject> errorDatas = this.exceptionService.selectBeans(ids);
        this.resynchronizations(errorDatas);
    }

    public void resynchronizations(final List<JSONObject> errorDatas) throws Exception {
        if (StringUtil.listIsNull(errorDatas)) {
            return;
        }
        JSONObject ed = errorDatas.get(0);
        String bean = StringUtil.valueOf((String)ed.getString("bean"));
        String name = ed.getString("name");
        int batch = ed.getIntValue("batch");
        String tid = ed.getString("tableID");
        String type = ed.getString("jobType");
        TimerParam param = TaskTimer.paramJson((String)ed.getString("param"));
        if (StringUtil.isNull((Object)bean)) {
            throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u5b9e\u4f8b" + bean);
        }
        String date = DateUtil.dateFormat();
        TaskInfo taskInfo = new TaskInfo(new Date(), name, date, date, "RESYNC");
        final String taskId = taskInfo.getId();
        final TaskBean taskBean = TaskFlowFactory.taskBean((String)type, (String)tid, (String)bean, (String)name, (int)batch, (TimerParam)param);
        taskBean.createModel();
        LoggerManager.createLogger((String)name);
        this.taskInfoService.saveTaskInfo(taskInfo);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    taskBean.init();
                    for (JSONObject obj : errorDatas) {
                        JSONObject data = obj.getJSONObject("data");
                        DataReader dataReader = taskBean.getDataReader();
                        Map newData = dataReader.selectOne((Map)data);
                        taskBean.syncData(newData, taskId);
                    }
                    MainService.this.taskInfoService.state(taskId, 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (taskBean != null) {
                        taskBean.end(taskId);
                    }
                }
            }
        });
        thread.start();
        this.exceptionService.updateStates(errorDatas, 1);
    }

    private Map<String, Object> stringToMap(String str) {
        str = str.substring(1, str.lastIndexOf("}"));
        String[] strs = str.split(",");
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        for (String s : strs) {
            String[] s1 = s.split("=");
            String key = s1[0].trim();
            String value = s1[1].trim();
            objectMap.put(key, value);
        }
        return objectMap;
    }

    public void deleteInfo(String id) {
        this.taskInfoService.deleteInfo(id);
    }

    public List<TaskInfo> searchdata(String id, String time) {
        return this.taskInfoService.list(id, time + " 00:00:00");
    }

    public void one(String id, PrimaryKey pk) throws Exception {
        TaskTimer taskTimer = this.getTimerById(id);
        String bean = taskTimer.getBean();
        if (StringUtil.isNull((Object)bean)) {
            throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u5b9e\u4f8b" + bean);
        }
        taskTimer.setBatch(0);
        TaskBean taskBean = TaskFlowFactory.taskBean((TaskTimer)taskTimer, (TimerParam)taskTimer.getParamJson());
        taskBean.createModel();
        taskBean.init();
        LoggerManager.createLogger((String)taskTimer.getName());
        taskBean.syncData(pk);
        taskBean.end();
    }

    public void interrupt(String name) throws UnableToInterruptJobException {
        TaskTimer taskTimer = this.getTimer(name);
        String name1 = taskTimer.getName();
        String group = taskTimer.getJobGroup();
        QuartzManager.interrupt(this.scheduler, name1, group);
    }

    public JSONArray local() throws SchedulerException {
        List list = this.scheduler.getCurrentlyExecutingJobs();
        JSONArray jsonArray = new JSONArray();
        for (JobExecutionContext job : list) {
            JSONObject jsonObjec = new JSONObject();
            jsonObjec.put("fireTime", (Object)job.getFireTime());
            jsonObjec.put("previousFireTime", (Object)job.getPreviousFireTime());
            jsonObjec.put("nextFireTime", (Object)job.getNextFireTime());
            jsonArray.add((Object)jsonObjec);
        }
        return jsonArray;
    }

    public Map<String, DataSourceBean> getDb() {
        return this.connectionFactory.dbMap();
    }

    public List<DbInfo> getDbs() {
        return this.tableMapperDao.selectDB();
    }

    public void bindTask(String name) throws SysException {
        String id = ServiceUtil.serialNumber();
        System.out.println(name + " " + id);
        TaskTimer taskTimer = this.getTimer(name);
        String binding = taskTimer.getBinding();
        if (!StringUtil.isNull((Object)binding)) {
            throw new SysException("\u5df2\u7ed1\u5b9a [" + binding + "]");
        }
        this.scheduleDao.updateBinding(name, id);
    }

    public void disbindTask(String name) throws SysException {
        String id = ServiceUtil.serialNumber();
        TaskTimer taskTimer = this.getTimer(name);
        String binding = taskTimer.getBinding();
        if (binding == null || !binding.equals(id)) {
            throw new SysException("\u89e3\u7ed1\u6570\u636e\u5931\u8d25 [" + binding + "]");
        }
        this.scheduleDao.updateBinding(name, "");
    }

    public List<Table> tableInfo(String type) {
        if ("not".equals(type)) {
            return this.tableMapperDao.tableInfosNot();
        }
        if ("has".equals(type)) {
            return this.tableMapperDao.tableInfosHas();
        }
        return this.tableMapperDao.tableInfos();
    }

    public void savesch(TaskTimer taskTimer, String tableInfo) throws SysException {
        String name = taskTimer.getName();
        if (StringUtil.isNull((Object)name)) {
            throw new SysException("\u4efb\u52a1\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TaskTimer tt = this.scheduleDao.getByName(name);
        if (tt != null) {
            throw new SysException("\u4efb\u52a1\u540d\u5df2\u5b58\u5728");
        }
        taskTimer.setId(IdGeneratorUtil.uuid32());
        taskTimer.setBean("CommonTask");
        taskTimer.setTableId(taskTimer.getTableId());
        this.scheduleDao.saveTaskTimer(taskTimer);
        Table table = this.tableMapperDao.tableInfo(tableInfo);
        System.out.println("table" + table.isComparesj());
        if (table.isComparesj() && !"COMPARE".equals(taskTimer.getJobType())) {
            TaskTimer taskTimer1 = new TaskTimer();
            taskTimer1.setId(IdGeneratorUtil.uuid32());
            taskTimer1.setApp(taskTimer.getApp());
            taskTimer1.setName(name + "C");
            taskTimer1.setBean("CommonTask");
            taskTimer1.setTableId(taskTimer.getTableId());
            taskTimer1.setSize(taskTimer.getSize());
            taskTimer1.setTime(taskTimer.getTime());
            taskTimer1.setTigger(taskTimer.getTigger() + "C");
            taskTimer1.setTiggerGroup(taskTimer.getTiggerGroup() + "C");
            taskTimer1.setJobType("COMPARE");
            taskTimer1.setJobDesc(taskTimer.getJobDesc() + "\u5bf9\u8d26");
            taskTimer1.setTiggerGroup(taskTimer.getTiggerGroup() + "C");
            taskTimer1.setJobGroup(taskTimer.getTiggerGroup() + "C");
            taskTimer1.setBatch(taskTimer.getBatch());
            this.scheduleDao.saveTaskTimer(taskTimer1);
        }
    }

    public void saveschedule(TaskTimer taskTimer, String moduleid, String compare) throws SysException {
        String name = taskTimer.getName();
        if (StringUtil.isNull((Object)name)) {
            throw new SysException("\u4efb\u52a1\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNull((Object)taskTimer.getBean())) {
            throw new SysException("\u672a\u9009\u62e9Bean");
        }
        TaskTimer tt = this.scheduleDao.getByName(name);
        if (tt != null) {
            throw new SysException("\u4efb\u52a1\u540d\u5df2\u5b58\u5728");
        }
        taskTimer.setId(IdGeneratorUtil.uuid32());
        taskTimer.setTableId(moduleid);
        this.scheduleDao.saveTaskTimer(taskTimer);
        if ("COMPARE".equals(compare) && !"COMPARE".equals(taskTimer.getJobType())) {
            TaskTimer taskTimer1 = new TaskTimer();
            taskTimer1.setId(IdGeneratorUtil.uuid32());
            taskTimer1.setApp(taskTimer.getApp());
            taskTimer1.setName(name + "C");
            taskTimer1.setBean(taskTimer.getBean());
            taskTimer1.setTableId(taskTimer.getTableId());
            taskTimer1.setSize(taskTimer.getSize());
            taskTimer1.setTime(taskTimer.getTime());
            taskTimer1.setTigger(taskTimer.getTigger() + "C");
            taskTimer1.setTiggerGroup(taskTimer.getTiggerGroup() + "C");
            taskTimer1.setJobType(compare);
            taskTimer1.setJobDesc(taskTimer.getJobDesc() + "\u5bf9\u8d26");
            taskTimer1.setTiggerGroup(taskTimer.getTiggerGroup() + "C");
            taskTimer1.setJobGroup(taskTimer.getTiggerGroup() + "C");
            taskTimer1.setBatch(taskTimer.getBatch());
            taskTimer1.setBeforeHour(0);
            this.scheduleDao.saveTaskTimer(taskTimer1);
        }
    }

    private String randomName(TaskTimer taskTimer) {
        String desc = taskTimer.getJobDesc();
        String name = taskTimer.getName();
        String py = PinYin2Abbreviation.cn2py((String)desc);
        if (py.length() > 20) {
            py = py.substring(20);
        }
        return py + "_" + DateUtil.dateFormat((String)"yyyyMMdd");
    }

    public void genCode(String id, String type) throws SysException {
        Table table = this.tableMapperDao.tableInfo(id);
        if (table != null) {
            throw new SysException("\u522b\u5077\u61d2\uff0c\u591a\u52a8\u624b\u3002");
        }
    }

    public Map<String, String> one(String task) throws Exception {
        TaskTimer taskTimer = this.getTimerById(task);
        TaskBean taskBean = TaskFlowFactory.taskBean((TaskTimer)taskTimer, (TimerParam)taskTimer.getParamJson());
        return taskBean.getDataWriter().goalId().primaryMap();
    }

    public List<TaskTimer> bindingList(String id) {
        return this.scheduleDao.bindingList(id);
    }

    public List<TaskTimer> bindingList(String id, boolean start) {
        return this.scheduleDao.bindingStartList(id, start);
    }

    public List<JSONObject> supportDb() {
        return this.scheduleDao.supportDb();
    }

    public List<JSONObject> supportDialect(String type) {
        return this.scheduleDao.supportDialect(type);
    }

    public List<String> getApps() {
        return this.scheduleDao.getApps();
    }

    public List<LocalTaskInfo> taskInfos() throws Exception {
        ArrayList<LocalTaskInfo> list = new ArrayList<LocalTaskInfo>();
        Set jobKeySet = this.scheduler.getJobKeys(GroupMatcher.anyJobGroup());
        for (JobKey jobKey : jobKeySet) {
            String job = jobKey.getName();
            LocalTaskInfo localTaskInfo = new LocalTaskInfo();
            localTaskInfo.setScheduleName(job);
            list.add(localTaskInfo);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!((ThreadModel)entry.getValue()).isRunning()) continue;
            LocalTaskInfo localTaskInfo = new LocalTaskInfo();
            localTaskInfo.setScheduleName((String)entry.getKey());
            list.add(localTaskInfo);
        }
        return list;
    }

    public void setOpen(boolean open, String name) {
        this.scheduleDao.updateOpen(open, name);
    }

    public void updateSch(TaskTimer taskTimer) {
        System.out.println(taskTimer);
        this.scheduleDao.updateTimer(taskTimer);
    }
}

