/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.FileUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.core.util.ZipCompressor;
import com.github.niupengyu.schedule.common2.bean.common.Sql;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.util.ModelType;
import com.github.niupengyu.schedule.mains.dao.TableMapperDao;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="genProService")
public class GenProService {
    @Autowired
    private TableMapperDao tableMapperDao;

    public File gen(String packageName, String[] ids) throws Exception {
        long time = System.currentTimeMillis();
        String path = "outFile/" + time + "/";
        for (String id : ids) {
            this.gen(packageName, path, id);
        }
        ZipCompressor zip = new ZipCompressor();
        File file = new File(path);
        File out = new File("outFile/", time + ".zip");
        zip.compressExe(file, out);
        return out;
    }

    public void gen(String packageName, String path, String id) throws Exception {
        Table table = this.tableMapperDao.tableInfo(id);
        Sql sql = this.tableMapperDao.sql(id);
        HashMap map = new HashMap();
        Configuration cfg = null;
        cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setDirectoryForTemplateLoading(new File(FileUtil.getResourcesPath(GenProService.class) + "/config/temp"));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        Template template = cfg.getTemplate("TaskDemo.ftl");
        HashMap<String, String> taskMap = new HashMap<String, String>();
        String exeModel = table.getModel();
        String dataReader = "";
        String dataWriter = "";
        dataWriter = table.isBatch() ? "," + ModelType.batchTypeMap((String)exeModel).getSimpleName() : ModelType.oneTypeMap((String)exeModel).getSimpleName();
        String compare = "";
        if (table.isComparesj()) {
            if (!table.isGxsjc() && !table.isPage()) {
                dataReader = "AllCompareDataReader";
            } else if (!table.isGxsjc() && table.isPage()) {
                dataReader = "PageCompareDataReader";
            } else if (table.isGxsjc() && !table.isPage()) {
                dataReader = "AllTimeCompareDataReader";
            } else if (table.isGxsjc() && table.isPage()) {
                dataReader = "PageTimeCompareDataReader";
            } else {
                throw new SysException("\u627e\u4e0d\u5230\u5408\u9002\u7684 READER ");
            }
            compare = table.isBatch() ? ",BatchCompareWriter" : ",CompareWriter";
        } else if (!table.isGxsjc() && !table.isPage()) {
            dataReader = "AllDataReader";
        } else if (!table.isGxsjc() && table.isPage()) {
            dataReader = "PageDataReader";
        } else if (table.isGxsjc() && !table.isPage()) {
            dataReader = "AllTimeDataReader";
        } else if (table.isGxsjc() && table.isPage()) {
            dataReader = "PageTimeDataReader";
        } else {
            throw new SysException("\u627e\u4e0d\u5230\u5408\u9002\u7684 READER ");
        }
        String max = "";
        if (table.isGxsjc()) {
            max = ",MaxDate";
        }
        String min = "";
        if (table.isMin()) {
            max = ",MinDate";
        }
        String pack = packageName;
        String name = table.getName();
        String className = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        taskMap.put("model", dataReader + dataWriter + compare + max + min);
        taskMap.put("exeModel", exeModel);
        taskMap.put("id", id);
        taskMap.put("compare", compare);
        taskMap.put("max", max);
        taskMap.put("pack", pack);
        taskMap.put("name", name);
        taskMap.put("className", className);
        taskMap.put("ispage", table.isPage() + "");
        taskMap.put("isbatch", table.isBatch() + "");
        taskMap.put("iscomparesj", table.isComparesj() + "");
        taskMap.put("isgxsjc", table.isGxsjc() + "");
        taskMap.put("isPkReplace", table.isPkReplace() + "");
        String sourceClass = className + "Source";
        String targetClass = className + "Target";
        taskMap.put("sourceClass", sourceClass);
        taskMap.put("targetClass", targetClass);
        taskMap.put("sourceValue", Character.toLowerCase(sourceClass.charAt(0)) + sourceClass.substring(1));
        taskMap.put("targetValue", Character.toLowerCase(targetClass.charAt(0)) + targetClass.substring(1));
        Template dao = cfg.getTemplate("SourceDao.ftl");
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        sourceMap.put("count", StringUtil.valueOf((String)sql.getTotalSql()));
        sourceMap.put("selectData", StringUtil.valueOf((String)sql.getPageListSql()));
        sourceMap.put("selectOne", StringUtil.valueOf((String)sql.getSelectOneSql()));
        sourceMap.put("max", StringUtil.valueOf((String)sql.getMaxSql()));
        sourceMap.put("selectCompareData", StringUtil.valueOf((String)sql.getCompareListSql()));
        sourceMap.put("compareTotal", StringUtil.valueOf((String)sql.getCompareTotalSql()));
        sourceMap.put("sourceClass", sourceClass);
        Template targetDao = cfg.getTemplate("TargetDao.ftl");
        HashMap<String, String> targetMap = new HashMap<String, String>();
        targetMap.put("update", StringUtil.valueOf((String)sql.getUpdateSql()));
        targetMap.put("save", StringUtil.valueOf((String)sql.getInsertSql()));
        targetMap.put("compareTotal", StringUtil.valueOf((String)sql.getTargetCompareTotalSql()));
        targetMap.put("deletes", StringUtil.valueOf((String)sql.getDeleteInSql()));
        targetMap.put("delete", StringUtil.valueOf((String)sql.getDeleteSql()));
        targetMap.put("hasOne", StringUtil.valueOf((String)sql.getHasOneSql()));
        targetMap.put("targetClass", targetClass);
        path = path + name + "/";
        FileUtil.mkdirs1((String)path);
        this.outFile(path, className, taskMap, template);
        this.outFile(path, sourceClass, sourceMap, dao);
        this.outFile(path, targetClass, targetMap, targetDao);
    }

    private void outFile(String path, String className, Map<String, String> map, Template template) throws SysException {
        String file1 = path + className + ".java";
        File docFile = new File(file1);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(docFile)));
            template.process(map, (Writer)out);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new SysException("\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
            }
            catch (Throwable throwable) {
                FileUtil.close(out);
                out = null;
                throw throwable;
            }
        }
        FileUtil.close((Writer)out);
        out = null;
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^" + file1 + " \u6587\u4ef6\u521b\u5efa\u6210\u529f !");
    }
}

