/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.commons.poi.ExcelReadCallBack;
import com.github.niupengyu.commons.poi.ReadExcelTools;
import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.core.util.PageUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.jdbc.dao.JdbcUtil;
import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.bean.TimerParam;
import com.github.niupengyu.schedule.common2.bean.common.CodeInfo;
import com.github.niupengyu.schedule.common2.bean.common.Column;
import com.github.niupengyu.schedule.common2.bean.common.CreateInfo;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.bean.common.Sql;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.factory.SqlFactory;
import com.github.niupengyu.schedule.common2.factory.db.DBMetadata;
import com.github.niupengyu.schedule.common2.factory.dialect.TargetGenSqlDialect;
import com.github.niupengyu.schedule.common2.log.LoggerManager;
import com.github.niupengyu.schedule.common2.service.FileTaskBeanService;
import com.github.niupengyu.schedule.common2.service.TaskBean;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.mains.dao.ExcelDao;
import com.github.niupengyu.schedule.mains.util.TableSql;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="excelService")
public class ExcelService {
    @Resource(name="scheduleDBDataSource")
    private DataSource dataSource;
    @Resource(name="taskInfoService")
    private TaskInfoService taskInfoService;
    @Autowired
    private ExcelDao excelDao;

    public JSONArray upload(MultipartFile multipartFile, int sheetNum, int rowNum) throws SysException {
        final JSONArray jsonArray = new JSONArray();
        try (InputStream inputStream = multipartFile.getInputStream();){
            ReadExcelTools readExcelTools = new ReadExcelTools(inputStream, multipartFile.getOriginalFilename(), sheetNum, rowNum, rowNum + 1);
            readExcelTools.readExcel(new ExcelReadCallBack(){

                public void read(String fileName, int sheetNum, int rowNum, String[] list) {
                    jsonArray.add((Object)list);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SysException("\u7cfb\u7edf\u5f02\u5e38");
        }
        return jsonArray;
    }

    public JSONObject upload(File file, String oriFileName, int sheetNum, int rowNum) throws SysException {
        final JSONArray jsonArray = new JSONArray();
        try (FileInputStream inputStream = new FileInputStream(file);){
            ReadExcelTools readExcelTools = new ReadExcelTools((InputStream)inputStream, oriFileName, sheetNum, rowNum, rowNum + 1);
            readExcelTools.readExcel(new ExcelReadCallBack(){

                public void read(String fileName, int sheetNum, int rowNum, String[] list) {
                    jsonArray.add((Object)list);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SysException("\u7cfb\u7edf\u5f02\u5e38");
        }
        JSONObject data = new JSONObject();
        data.put("list", (Object)jsonArray);
        data.put("file", (Object)file.getName());
        data.put("fileName", (Object)oriFileName);
        return data;
    }

    public void genCode(CodeInfo createInfo, List<Column> columns, String exenow, String savenow, String basePath, String filePath, int rowNum, int sheetNum, int batch, String fileName) throws Exception {
        CreateInfo target = createInfo.getTarget();
        DBMetadata targetSql = SqlFactory.getType((CreateInfo)target, (TaskInfoService)this.taskInfoService);
        DbInfo targetDbInfo = targetSql.getDbInfo();
        createInfo.setSyncName("excel-" + createInfo.getSyncName());
        createInfo.setSyncMode("excel");
        Table table = new Table(target, createInfo);
        table.setDbComponent("excel");
        TargetGenSqlDialect targetGenSql = SqlFactory.targetGen((CodeInfo)createInfo, (DbInfo)targetDbInfo, columns);
        if (StringUtil.booleanValueOf((String)savenow, (boolean)false).booleanValue()) {
            JdbcUtil jdbcUtil = null;
            Object pagec = null;
            Object listc = null;
            Object countc = null;
            String has = targetGenSql.has();
            String update = targetGenSql.update();
            String delete = targetGenSql.delete();
            String insert = targetGenSql.insert();
            String total = targetGenSql.total();
            String deletes = targetGenSql.deleteIn();
            String allList = targetGenSql.allList();
            try {
                jdbcUtil = new JdbcUtil(this.dataSource.getConnection());
                Object[] vars = new Object[]{table.getId(), table.getTargetDb(), table.getDb(), table.getTn(), table.getModel(), table.isPage(), table.isBatch(), table.isGxsjc(), table.isComparesj(), table.getComparesjValue(), table.getTtn(), "", table.getName(), 1, table.getSyncMode(), table.getPk(), table.getTargetpk(), table.isMin(), table.getMinsj(), table.isPkReplace(), table.getTdbComponent(), table.getDbComponent(), table.getGxsjcValue(), table.getTargetComparesjValue(), table.getModel(), table.isTimeOrder(), table.getOwner(), table.getTargetOwner()};
                jdbcUtil.execute(TableSql.insertExcel, vars);
                vars = new Object[]{IdGeneratorUtil.uuid32(), table.getId(), "", "", countc, pagec, "", "", has, update, delete, insert, total, deletes, createInfo.getMinsj(), "", listc, allList};
                jdbcUtil.execute(TableSql.insertSql, vars);
                boolean i = true;
                ArrayList<Object[]> var = new ArrayList<Object[]>();
                for (Column column : columns) {
                    Object[] v = new Object[]{IdGeneratorUtil.uuid32(), table.getId(), column.getName1(), column.getDataType(), column.getKey1(), column.getDefaultValue(), column.isPk(), column.getState(), column.getIndex1(), column.isUpdate1(), column.isSelect1(), column.isGxsjc(), column.isCompare(), column.isConvertData(), column.getSourceType(), column.getFormat()};
                    var.add(v);
                }
                jdbcUtil.executeBatch(TableSql.insertColumn, var);
                jdbcUtil.commit();
            }
            catch (Exception e) {
                try {
                    JdbcUtil.rollBack(jdbcUtil);
                    e.printStackTrace();
                    throw new SysException(e.getMessage());
                }
                catch (Throwable throwable) {
                    JdbcUtil.close(jdbcUtil);
                    throw throwable;
                }
            }
            JdbcUtil.close((JdbcUtil)jdbcUtil);
        }
        if (StringUtil.booleanValueOf((String)exenow, (boolean)false).booleanValue()) {
            Sql sql = new Sql(table, targetGenSql);
            this.exe(table, columns, sql, basePath, filePath, rowNum, sheetNum, fileName, batch);
        }
    }

    private void exe(final Table table, final List<Column> columns, final Sql sql, String basePath, String filePath, final int rowNum, final int sheetNum, final String fileName, final int batch) throws Exception {
        String date = DateUtil.dateFormat();
        TaskInfo taskInfo = new TaskInfo(new Date(), fileName, date, date, "FILE-EXCEL");
        final String taskId = taskInfo.getId();
        LoggerManager.createLogger((String)fileName);
        this.taskInfoService.saveTaskInfo(taskInfo);
        System.out.println(table.getPk());
        final File file = new File(basePath + filePath);
        System.out.println(file.getPath());
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (FileInputStream input = new FileInputStream(file);){
                    ReadExcelTools readExcelTools = new ReadExcelTools((InputStream)input, fileName, sheetNum, rowNum + 1);
                    TimerParam timerParam = new TimerParam();
                    timerParam.setBatch(Integer.valueOf(batch));
                    FileTaskBeanService taskBean = new FileTaskBeanService("file", table, columns, sql, fileName, batch, timerParam, ExcelService.this.taskInfoService);
                    taskBean.init();
                    readExcelTools.readExcel(new ExcelReadCallBack((TaskBean)taskBean){
                        final /* synthetic */ TaskBean val$taskBean;
                        {
                            this.val$taskBean = taskBean;
                        }

                        public void read(String fileName, int sheetNum, int rowNum, String[] list) {
                            int length = list.length;
                            HashMap<String, String> map = new HashMap<String, String>();
                            for (Column column : columns) {
                                int i;
                                String name = column.getName1();
                                int index = StringUtil.integerValueOf((String)name.substring((i = name.lastIndexOf("-")) + 1), (Integer)0);
                                if (index < length) {
                                    map.put(column.getName1(), list[index]);
                                    continue;
                                }
                                map.put(column.getName1(), null);
                            }
                            try {
                                this.val$taskBean.syncData(map, taskId);
                            }
                            catch (Exception e) {
                                LoggerManager.error((String)fileName, (String)("\u4ec0\u4e48\u60c5\u51b5 \u540c\u6b65\u5931\u8d25" + map), (Throwable)e);
                                ExcelService.this.taskInfoService.exceptionInfo(map, taskId, e.getMessage(), 1);
                            }
                        }
                    });
                    taskBean.end(taskId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LoggerManager.info((String)fileName, (String)"\u5f02\u5e38");
                    ExcelService.this.taskInfoService.exceptionInfo("", taskId, e.getMessage());
                }
                finally {
                    LoggerManager.info((String)fileName, (String)"\u7ed3\u675f");
                    ExcelService.this.taskInfoService.state(taskId, 1);
                }
            }
        });
        thread.start();
    }

    public JSONObject excelInfo(int page, int size) {
        int start = PageUtil.start((int)page, (int)size);
        int total = this.excelDao.total();
        List<Map<String, Object>> list = this.excelDao.excelInfos(start, size);
        JSONObject obj = new JSONObject();
        obj.put("total", (Object)total);
        obj.put("list", list);
        return obj;
    }

    public static void main(String[] args) {
        String str = "ssdfsf-sdfsdf-sdf";
        int index = str.lastIndexOf("-");
        System.out.println(str.substring(0, index));
        System.out.println(str.substring(index + 1));
    }
}

