/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.service;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSONArray;
import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.jdbc.dao.JdbcDao;
import com.github.niupengyu.jdbc.datasource.BasicDataSource;
import com.github.niupengyu.schedule.common2.bean.DataSourceInfo;
import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.factory.LocalContext;
import com.github.niupengyu.schedule.common2.factory.SqlFactory;
import com.github.niupengyu.schedule.mains.dao.DataSourceDao;
import com.github.niupengyu.schedule.mains.service.MapperService;
import com.github.niupengyu.schedule.mains.service.TaskService;
import com.github.niupengyu.schedule.mains.util.ThreadPool;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dbService")
public class DbService {
    @Resource(name="mapperService")
    private MapperService mapperService;
    @Resource(name="taskService")
    private TaskService taskService;
    @Autowired
    private DataSourceDao dataSourceDao;

    public JSONArray poolInfo() {
        Map map = SqlFactory.dataSourceInfo();
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            DataSource value = (DataSource)entry.getValue();
            DataSourceInfo obj = this.setDataSourceInfo(value, key);
            obj.setDb(this.mapperService.selectDbInfoName(key));
            jsonArray.add((Object)obj);
        }
        return jsonArray;
    }

    private DataSourceInfo setDataSourceInfo(DataSource value, String key) {
        DataSourceInfo dataSourceInfo;
        if (value instanceof DruidDataSource) {
            DruidDataSource ds = (DruidDataSource)DruidDataSource.class.cast(value);
            dataSourceInfo = new DataSourceInfo(ds);
        } else if (value instanceof BasicDataSource) {
            BasicDataSource ds = (BasicDataSource)BasicDataSource.class.cast(value);
            dataSourceInfo = new DataSourceInfo(ds);
        } else {
            dataSourceInfo = new DataSourceInfo();
        }
        return dataSourceInfo;
    }

    public List<TaskInfo> taskinfo(String name) {
        return this.taskService.taskInfo(name);
    }

    public List<DbInfo> list() {
        List<DbInfo> dbInfos = this.dataSourceDao.list();
        for (DbInfo dbInfo : dbInfos) {
            String key = dbInfo.getDbName();
            Map map = SqlFactory.dataSourceInfo();
            DataSource value = (DataSource)map.get(key);
            DataSourceInfo obj = this.setDataSourceInfo(value, key);
            dbInfo.setDataSourceInfo(obj);
        }
        return dbInfos;
    }

    public long testConnection(String id) {
        DbInfo dbInfo = this.mapperService.selectDbInfo(id);
        return this.testConnection(dbInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long testConnection(DbInfo dbInfo) {
        long mi = -1L;
        Connection conn = null;
        long start = System.currentTimeMillis();
        try {
            conn = SqlFactory.getType((DbInfo)dbInfo).connection();
            if (conn != null && !conn.isClosed()) {
                mi = System.currentTimeMillis() - start;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            JdbcDao.closeConn((Connection)conn);
        }
        return mi;
    }

    public List<TaskInfo> test(String name) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    DbService.this.mapperService.initConnectionHolder(null, "3");
                    for (int i = 0; i < 1000; ++i) {
                        LocalContext.getTargetJdbcDao().conn().close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Runnable r1 = new Runnable(){

            @Override
            public void run() {
                try {
                    DbService.this.mapperService.initConnectionHolder(null, "3");
                    for (int i = 0; i < 1000; ++i) {
                        LocalContext.getTargetJdbcDao().conn().close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Runnable r2 = new Runnable(){

            @Override
            public void run() {
                try {
                    DbService.this.mapperService.initConnectionHolder(null, "3");
                    for (int i = 0; i < 1000; ++i) {
                        LocalContext.getTargetJdbcDao().conn().close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        ThreadPool.pools.execute(r);
        ThreadPool.pools.execute(r2);
        ThreadPool.pools.execute(r1);
        return new ArrayList<TaskInfo>();
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("data1", "1");
        map.put("data2", "2");
        map.put("data3", "3");
        String data = (String)map.get("data1");
        map.clear();
        System.out.println(data);
    }

    public void startDb(String id) {
        this.dataSourceDao.updateState(id, 1);
    }

    public void stopDb(String id) {
        this.dataSourceDao.updateState(id, 2);
    }

    public void refresh() {
        this.mapperService.initdb();
        SqlFactory.clear();
    }

    public void save(DbInfo dbInfo) {
        dbInfo.setId(IdGeneratorUtil.uuid32());
        dbInfo.setState(1);
        this.dataSourceDao.saveDb(dbInfo);
    }

    public List dialects() {
        return this.dataSourceDao.dialects();
    }

    public List database() {
        return this.dataSourceDao.database();
    }

    public DbInfo getById(String id) {
        return this.dataSourceDao.getById(id);
    }

    public void update(DbInfo dbInfo) {
        this.dataSourceDao.updateDb(dbInfo);
    }
}

