/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.init;

import com.github.niupengyu.core.init.InitService;
import com.github.niupengyu.schedule.common2.bean.TaskTimer;
import com.github.niupengyu.schedule.common2.service.ModuleService;
import com.github.niupengyu.schedule.common2.util.ServiceUtil;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.github.niupengyu.schedule.mains.service.MapperService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.stereotype.Service;

@Service(value="quartzInit")
public class QuartzInit
implements InitService {
    private static final Logger logger = LoggerFactory.getLogger(QuartzInit.class);
    @Resource(name="mainService")
    private MainService mainService;
    @Resource(name="mapperService")
    private MapperService mapperService;
    @Resource(name="moduleService")
    private ModuleService moduleService;

    public void run(ApplicationArguments applicationArguments) {
        try {
            List<TaskTimer> list = this.mainService.bindingList(ServiceUtil.serialNumber(), true);
            logger.info("\u83b7\u53d6\u7ed1\u5b9a\u5217\u8868[" + list.size() + "]");
            for (TaskTimer taskTimer : list) {
                if ("STOP".equals(taskTimer.getState())) continue;
                this.mainService.add(taskTimer, taskTimer.getTime());
                logger.info("\u542f\u52a8\u4efb\u52a1[" + taskTimer.getName() + "]");
            }
        }
        catch (Exception e) {
            logger.error("\u5f00\u673a\u542f\u52a8\u5931\u8d25", (Throwable)e);
        }
        try {
            this.mapperService.initdb();
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u5e93\u4fe1\u606f\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
        try {
            this.moduleService.initModules();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6a21\u5757\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }
}

