/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.core.util.Hello;
import com.github.niupengyu.core.util.HostUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.schedule.common2.bean.common.Column;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.bean.common.Sql;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.common2.util.ServiceUtil;
import com.github.niupengyu.schedule.mains.service.ExceptionService;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.github.niupengyu.schedule.mains.service.MapperService;
import com.github.niupengyu.schedule.mains.service.PlanService;
import com.github.niupengyu.web.content.ContentController;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"page"})
public class PageController
extends ContentController {
    @Resource(name="taskInfoService")
    private TaskInfoService taskInfoService;
    @Resource(name="exceptionService")
    private ExceptionService exceptionService;
    @Resource(name="planService")
    private PlanService planService;
    @Resource(name="mainService")
    private MainService mainService;
    @Resource(name="mapperService")
    private MapperService mapperService;

    @RequestMapping(value={"top"})
    public String top(HttpServletRequest request) throws Exception {
        request.setAttribute("hello", (Object)Hello.word());
        request.setAttribute("host", (Object)request.getLocalAddr());
        return "templates/main/top";
    }

    @RequestMapping(value={"left"})
    public String left(HttpServletRequest request) throws Exception {
        request.setAttribute("hello", (Object)Hello.word());
        request.setAttribute("host", (Object)request.getLocalAddr());
        return "templates/main/left";
    }

    @RequestMapping(value={"main"})
    public String main() throws Exception {
        this.setRequest(this.request(), "NOT-COMPARE");
        return "templates/main/main";
    }

    @RequestMapping(value={"index"})
    public String index(HttpServletRequest request) throws Exception {
        request.setAttribute("hello", (Object)Hello.word());
        request.setAttribute("host", (Object)request.getLocalAddr());
        return "templates/main/index";
    }

    @RequestMapping(value={"schedule_list"})
    public String schedule_list() throws Exception {
        this.setRequest(this.request(), "NOT-COMPARE");
        return "templates/main/schedule_list";
    }

    @RequestMapping(value={"compare"})
    public String compare() throws Exception {
        this.setRequest(this.request(), "COMPARE");
        return "templates/main/main";
    }

    private void setRequest(HttpServletRequest request, String type) {
        request.setAttribute("typeList", this.mainService.getApps());
        request.setAttribute("modelList", (Object)type);
        request.setAttribute("serverId", (Object)ServiceUtil.serialNumber());
    }

    @RequestMapping(value={"index1"})
    public String index1(HttpServletRequest request) throws Exception {
        return "templates/main/index1";
    }

    @RequestMapping(value={"home"})
    public String home(HttpServletRequest request) throws Exception {
        return "templates/main/home";
    }

    @RequestMapping(value={"datacreate"})
    public String dataCreate(HttpServletRequest request) throws Exception {
        List<DbInfo> map = this.mainService.getDbs();
        request.setAttribute("db", map);
        return "templates/main/datacreate";
    }

    @RequestMapping(value={"plan"})
    public String plan(HttpServletRequest request) throws Exception {
        request.setAttribute("hello", (Object)Hello.word());
        request.setAttribute("host", (Object)HostUtil.ipAddr());
        request.setAttribute("plans", this.planService.selectList());
        request.setAttribute("timers", this.mainService.getTimerList("", "", "", "", 0, 0));
        return "templates/plan";
    }

    @RequestMapping(value={"one"})
    public String one(HttpServletRequest request) throws Exception {
        request.setAttribute("hello", (Object)Hello.word());
        request.setAttribute("host", (Object)HostUtil.ipAddr());
        request.setAttribute("timers", this.mainService.timer());
        return "templates/one";
    }

    @RequestMapping(value={"history"})
    public String history(String name, String time, HttpServletRequest request) throws Exception {
        request.setAttribute("hello", (Object)Hello.word());
        request.setAttribute("host", (Object)HostUtil.ipAddr());
        if (StringUtil.isNull((Object)time)) {
            time = DateUtil.dateFormatDate();
        }
        List taskInfos = this.taskInfoService.dayList(name, time);
        request.setAttribute("taskInfos", (Object)taskInfos);
        request.setAttribute("time", (Object)time);
        request.setAttribute("name", (Object)name);
        return "templates/history";
    }

    @RequestMapping(value={"nowtask"})
    public String nowtask(String app, String name, HttpServletRequest request) throws Exception {
        List taskInfos = this.taskInfoService.dayNowList("", name);
        request.setAttribute("taskInfos", (Object)taskInfos);
        request.setAttribute("time", (Object)DateUtil.dateFormatDate());
        request.setAttribute("name", (Object)name);
        return "templates/history";
    }

    @RequestMapping(value={"allnowtask"})
    public String allnowtask(String bingTask, String app, String name, String timeFrame, String taskstate, String tasktype, String time, HttpServletRequest request) throws Exception {
        return "templates/allnow";
    }

    @RequestMapping(value={"errottask"})
    public String errottask(String name, HttpServletRequest request) throws Exception {
        List taskInfos = this.taskInfoService.dayErrorList(name);
        request.setAttribute("taskInfos", (Object)taskInfos);
        request.setAttribute("time", (Object)DateUtil.dateFormatDate());
        request.setAttribute("name", (Object)name);
        return "templates/history";
    }

    @RequestMapping(value={"exception"})
    public String exception(String id, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int size, @RequestParam(name="type", required=false, defaultValue="") String type) throws Exception {
        JSONObject list = this.exceptionService.list(id, page, size, type);
        this.request().setAttribute("obj", (Object)list);
        return "templates/exception";
    }

    @RequestMapping(value={"scheduleconfig"})
    public String scheduleConfig() throws Exception {
        List<Table> list = this.mainService.tableInfo("not");
        this.request().setAttribute("list", list);
        return "templates/main/scheduleconfig";
    }

    @RequestMapping(value={"tableinfo"})
    public String tableinfo(String type) throws Exception {
        List<Table> list = this.mainService.tableInfo(type);
        this.request().setAttribute("list", list);
        this.request().setAttribute("type", (Object)type);
        return "templates/mapper/tableinfo";
    }

    @RequestMapping(value={"mapperdetail"})
    public String mapperdetail(String id, HttpServletRequest request) throws Exception {
        Table table = this.mapperService.tableinfo(id);
        Sql sql = this.mapperService.sqlInfo(id);
        List<Column> columns = this.mapperService.columnList(table);
        List<DbInfo> dbs = this.mainService.getDbs();
        List<JSONObject> support = this.mainService.supportDialect("source");
        List<JSONObject> targetSupport = this.mainService.supportDialect("target");
        request.setAttribute("support", support);
        request.setAttribute("targetSupport", targetSupport);
        request.setAttribute("dbs", dbs);
        request.setAttribute("table", (Object)table);
        request.setAttribute("sql", (Object)sql);
        request.setAttribute("columns", columns);
        return "templates/mapper/mapperdetail";
    }

    @RequestMapping(value={"datamapper"})
    public String datamapper(HttpServletRequest request) throws Exception {
        List<DbInfo> dbs = this.mainService.getDbs();
        request.setAttribute("dbs", dbs);
        List<JSONObject> support = this.mainService.supportDialect("source");
        request.setAttribute("support", support);
        List<JSONObject> targetSupport = this.mainService.supportDialect("target");
        request.setAttribute("targetSupport", targetSupport);
        return "templates/mapper/datamapper";
    }

    @RequestMapping(value={"datamappers"})
    public String datamappers(HttpServletRequest request) throws Exception {
        List<DbInfo> dbs = this.mainService.getDbs();
        request.setAttribute("dbs", dbs);
        List<JSONObject> support = this.mainService.supportDialect("source");
        request.setAttribute("support", support);
        List<JSONObject> targetSupport = this.mainService.supportDialect("target");
        request.setAttribute("targetSupport", targetSupport);
        return "templates/mapper/datamappers";
    }

    @RequestMapping(value={"datasource"})
    public String datasource(HttpServletRequest request) throws Exception {
        return "templates/datasource/main";
    }

    @RequestMapping(value={"toAdd"})
    public String toAdd(HttpServletRequest request) throws Exception {
        return "templates/datasource/toAdd";
    }

    @RequestMapping(value={"toUpd"})
    public String toUpd(String id, HttpServletRequest request) throws Exception {
        request.setAttribute("id", (Object)id);
        return "templates/datasource/toUpd";
    }

    @RequestMapping(value={"excel"})
    public String excel(HttpServletRequest request) throws Exception {
        List<DbInfo> dbs = this.mainService.getDbs();
        request.setAttribute("dbs", dbs);
        List<JSONObject> support = this.mainService.supportDialect("source");
        request.setAttribute("support", support);
        List<JSONObject> targetSupport = this.mainService.supportDialect("target");
        request.setAttribute("targetSupport", targetSupport);
        return "templates/excel/excel";
    }

    @RequestMapping(value={"exceinfo"})
    public String exceinfo() throws Exception {
        return "templates/excel/excelinfo";
    }

    @RequestMapping(value={"updateTask"})
    public String updateTask(String id, HttpServletRequest request) throws Exception {
        request.setAttribute("id", (Object)id);
        return "templates/main/updateTask";
    }
}

