/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.FileUtil;
import com.github.niupengyu.core.util.ZipTools;
import com.github.niupengyu.schedule.common2.service.ModuleService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import com.github.niupengyu.web.util.TransferTo;
import java.io.File;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"module"})
public class ModuleController
extends ClientContent {
    @Resource(name="moduleService")
    private ModuleService moduleService;

    @RequestMapping(value={"load"})
    public ResponseData loadModule(String id) throws Exception {
        this.moduleService.loadModule(id);
        return this.rdSuccess();
    }

    @RequestMapping(value={"uninstallModule"})
    public ResponseData uninstallModule(String id) throws Exception {
        this.moduleService.uninstallModule(id);
        return this.rdSuccess();
    }

    @RequestMapping(value={"save"})
    public ResponseData saveModule(String name, String module, String version, String packages, @RequestParam(value="file") MultipartFile file) throws Exception {
        String fileName;
        String baseDir = FileUtil.root() + "modules/" + module;
        File dir = new File(baseDir, fileName = module + "-" + version);
        if (dir.isDirectory()) {
            throw new SysException("\u7248\u672c\u5df2\u5b58\u5728");
        }
        FileUtil.mkdirs1((String)baseDir);
        File newFile = TransferTo.file((MultipartFile)file, (String)baseDir, (String)fileName);
        ZipTools.unZipToFolder((String)newFile.getPath(), (String)baseDir);
        new File(baseDir, FileUtil.getFileName0((String)file.getOriginalFilename())).renameTo(dir);
        this.moduleService.saveModule(name, module, version, packages, dir);
        return this.rdSuccess();
    }

    @RequestMapping(value={"modules"})
    public ResponseData modules(String module, String state, int page, int size) {
        JSONObject map = this.moduleService.modules(module, state, page, size);
        return this.rdSuccess(map);
    }

    @RequestMapping(value={"activeModules"})
    public ResponseData modules() {
        List map = this.moduleService.selectLoad();
        return this.rdSuccess(map);
    }

    @RequestMapping(value={"modulesgroup"})
    public ResponseData modulesGroup() {
        List map = this.moduleService.modulesGroup();
        return this.rdSuccess(map);
    }

    @RequestMapping(value={"beanNames"})
    public ResponseData beanNames(String id) {
        String[] map = this.moduleService.beans(id);
        return this.rdSuccess(map);
    }
}

