/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.schedule.common2.bean.common.CodeInfo;
import com.github.niupengyu.schedule.common2.bean.common.Column;
import com.github.niupengyu.schedule.common2.bean.common.CreateInfo;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.mains.service.GenProService;
import com.github.niupengyu.schedule.mains.service.MapperService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"mapper"})
public class MapperController
extends ClientContent {
    @Resource(name="mapperService")
    private MapperService mapperService;
    @Resource(name="genProService")
    private GenProService genProService;

    @RequestMapping(value={"tables"})
    public ResponseData tables(CreateInfo createInfo) throws Exception {
        List<String> list = this.mapperService.tables(createInfo);
        return this.rdSuccess(list);
    }

    @RequestMapping(value={"views"})
    public ResponseData views(CreateInfo createInfo) throws Exception {
        List<String> list = this.mapperService.views(createInfo);
        return this.rdSuccess(list);
    }

    @RequestMapping(value={"initdb"})
    public ResponseData initdb() throws Exception {
        this.mapperService.initdb();
        return this.rdSuccess();
    }

    @RequestMapping(value={"columns"})
    public ResponseData columns(CreateInfo createInfo, String tableName) throws Exception {
        List<Map<String, Object>> list = this.mapperService.columns(createInfo, tableName);
        return this.rdSuccess(list);
    }

    @RequestMapping(value={"exesql"})
    public ResponseData exeSql(CreateInfo createInfo, String sqlselect, String sqlfrom, String sqlwhere) throws Exception {
        List<Map<String, Object>> list = this.mapperService.exeSql(createInfo, sqlselect, sqlfrom, sqlwhere);
        return this.rdSuccess(list);
    }

    @RequestMapping(value={"tableinfo"})
    public ResponseData tableInfo(String id) throws SysException {
        Table list = this.mapperService.tableinfo(id);
        return this.rdSuccess(list);
    }

    @RequestMapping(value={"gencode"})
    public ResponseData genCode(CodeInfo codeInfo, HttpServletRequest request) throws Exception {
        String targetPkValue;
        String pkValue;
        ArrayList<Column> columns = new ArrayList<Column>();
        if (StringUtil.arrNotNull((Object[])codeInfo.getColumnNames())) {
            pkValue = "";
            targetPkValue = "";
            int i = 1;
            for (String name : codeInfo.getColumnNames()) {
                String key = request.getParameter(name + "columnKey");
                String defaultValue = request.getParameter(name + "columnDefault");
                String defaultType = request.getParameter(name + "dataType");
                String convert = request.getParameter(name + "convertData");
                String sourceType = request.getParameter(name + "sourcedataType");
                String format = request.getParameter(name + "format");
                if (StringUtil.isNull((Object)key)) {
                    throw new SysException(name + " \u76ee\u6807\u5e93\u5b57\u6bb5\u540d\u79f0\u4e3a\u7a7a " + i);
                }
                ++i;
                Column column = new Column();
                column.setName1(name);
                column.setKey1(key);
                column.setDefaultValue(StringUtil.valueOf((String)defaultValue));
                column.setDataType(defaultType);
                column.setSourceType(StringUtil.isNull((Object)sourceType) ? defaultType : sourceType);
                column.setFormat(format);
                column.setState(1);
                if (name.equals(codeInfo.getComparesjValue())) {
                    column.setCompare(true);
                    codeInfo.setTargetComparesjValue(key);
                }
                if (name.equals(codeInfo.getGxsjcValue())) {
                    column.setGxsjc(true);
                }
                boolean pk = StringUtil.booleanValueOf((String)request.getParameter(name + "pk"), (boolean)false);
                column.setPk(pk);
                column.setUpdate1(!pk);
                if (pk) {
                    pkValue = pkValue + "," + name;
                    targetPkValue = targetPkValue + "," + key;
                }
                column.setConvertData(StringUtil.booleanValueOf((String)convert, (boolean)false).booleanValue());
                columns.add(column);
            }
            boolean rksj = codeInfo.isRksj();
            if (rksj) {
                Column insert = new Column();
                insert.setPk(false);
                insert.setDataType("Timestamp");
                insert.setKey1(codeInfo.getInsertTime());
                insert.setName1(codeInfo.getInsertTime());
                insert.setUpdate1(false);
                insert.setDefaultValue("now");
                insert.setSelect1(false);
                insert.setState(1);
                Column update = new Column();
                update.setPk(false);
                update.setDataType("Timestamp");
                update.setKey1(codeInfo.getUpdateTime());
                update.setName1(codeInfo.getUpdateTime());
                update.setUpdate1(true);
                update.setDefaultValue("now");
                update.setSelect1(false);
                update.setState(1);
                columns.add(insert);
                columns.add(update);
            }
            String[] customizeCols = codeInfo.getCustomizeCols();
            i = 1;
            for (String name : customizeCols) {
                String key;
                Column column = new Column();
                String columnName = request.getParameter(name + "name");
                if (StringUtil.isNull((Object)columnName)) {
                    column.setSelect1(false);
                }
                if (StringUtil.isNull((Object)(key = request.getParameter(name + "Key")))) {
                    throw new SysException(name + " \u76ee\u6807\u5e93\u5b57\u6bb5\u540d\u79f0\u4e3a\u7a7a " + i);
                }
                ++i;
                String defaultValue = request.getParameter(name + "columnDefault");
                String defaultType = request.getParameter(name + "dataType");
                String convert = request.getParameter(name + "convertData");
                String sourceType = request.getParameter(name + "sourcedataType");
                String format = request.getParameter(name + "format");
                column.setSourceType(StringUtil.isNull((Object)sourceType) ? defaultType : sourceType);
                column.setFormat(format);
                column.setName1(columnName);
                column.setKey1(key);
                column.setDefaultValue(StringUtil.valueOf((String)defaultValue));
                column.setDataType(defaultType);
                column.setConvertData(StringUtil.booleanValueOf((String)convert, (boolean)false).booleanValue());
                boolean pk = StringUtil.booleanValueOf((String)request.getParameter(name + "pk"), (boolean)false);
                column.setPk(pk);
                column.setUpdate1(!pk);
                column.setState(2);
                if (pk) {
                    pkValue = pkValue + "," + name;
                    targetPkValue = targetPkValue + "," + key;
                }
                if (name.equals(codeInfo.getComparesjValue())) {
                    column.setCompare(true);
                    codeInfo.setTargetComparesjValue(key);
                }
                if (name.equals(codeInfo.getGxsjcValue())) {
                    column.setGxsjc(true);
                }
                columns.add(column);
            }
            if (StringUtil.isNull((Object)pkValue) || StringUtil.isNull((Object)targetPkValue) || pkValue.length() == 1 || targetPkValue.length() == 1) {
                return this.rdError("\u6ca1\u6709\u9009\u62e9\u4e3b\u952e \u6216\u4e3b\u952e\u4e3a\u7a7a");
            }
        } else {
            return this.rdError("\u6ca1\u6709\u9009\u5b57\u6bb5\u5440");
        }
        codeInfo.setPk(pkValue.substring(1));
        codeInfo.setTargetpk(targetPkValue.substring(1));
        this.mapperService.genCode(codeInfo, columns);
        return this.rdSuccess();
    }

    @RequestMapping(value={"gencodes"})
    public ResponseData genCodes(CodeInfo codeInfo, HttpServletRequest request) throws Exception {
        this.mapperService.genCodes(codeInfo);
        return this.rdSuccess();
    }

    @RequestMapping(value={"createTable"})
    public ResponseData createTable(CreateInfo createInfo, String part, HttpSession session) throws Exception {
        StringBuilder stringBuilder = this.mapperService.createTable(createInfo, part);
        session.setAttribute("ddl", (Object)stringBuilder);
        return this.rdSuccess();
    }

    @RequestMapping(value={"updateTable"})
    public ResponseData updateTable(Table table) throws Exception {
        this.mapperService.updateTable(table);
        return this.rdSuccess();
    }

    @RequestMapping(value={"updateColumns"})
    public ResponseData updateColumns(String[] columnIds, String tableId, String columngxsjc, String columncompare, boolean comparesj, boolean pkReplace, boolean page, String[] customizeCols, String owner, HttpServletRequest request) throws Exception {
        boolean pk;
        String format;
        String sourceType;
        String convert;
        String key;
        Column column;
        ArrayList<Column> list = new ArrayList<Column>();
        String pkColumn = "";
        String targetPkColumn = "";
        String compareColumn = "";
        String targetCompareColumn = "";
        String gxsjcColumn = "";
        int i = 0;
        for (String id : columnIds) {
            column = new Column();
            String name = request.getParameter(id + "name1");
            key = request.getParameter(id + "key1");
            String dataType = request.getParameter(id + "dataType");
            String defaultValue = request.getParameter(id + "defaultValue");
            convert = request.getParameter(id + "convertData");
            sourceType = request.getParameter(id + "sourceType");
            format = request.getParameter(id + "format");
            column.setSourceType(StringUtil.isNull((Object)sourceType) ? dataType : sourceType);
            column.setFormat(format);
            column.setConvertData(StringUtil.booleanValueOf((String)convert, (boolean)false).booleanValue());
            pk = StringUtil.booleanValueOf((String)request.getParameter(id + "pk"), (boolean)false);
            boolean update = StringUtil.booleanValueOf((String)request.getParameter(id + "update1"), (boolean)false);
            boolean select = StringUtil.booleanValueOf((String)request.getParameter(id + "select1"), (boolean)false);
            column.setId(id);
            column.setName1(name);
            column.setKey1(key);
            column.setDefaultValue(StringUtil.valueOf((String)defaultValue));
            column.setDataType(dataType);
            column.setPk(pk);
            column.setUpdate1(update);
            column.setSelect1(select);
            boolean compare = name.equals(columncompare);
            boolean gxsjc = name.equals(columngxsjc);
            column.setCompare(compare);
            column.setGxsjc(gxsjc);
            column.setIndex1(++i);
            column.setState(1);
            if (pk) {
                pkColumn = pkColumn + "," + name;
                targetPkColumn = targetPkColumn + "," + key;
            }
            if (compare) {
                compareColumn = name;
                targetCompareColumn = key;
            }
            if (gxsjc) {
                gxsjcColumn = name;
            }
            list.add(column);
        }
        i = 1;
        if (customizeCols != null && customizeCols.length > 0) {
            for (String name : customizeCols) {
                column = new Column();
                String columnName = request.getParameter(name + "name");
                if (StringUtil.isNull((Object)columnName)) {
                    column.setSelect1(false);
                }
                if (StringUtil.isNull((Object)(key = request.getParameter(name + "Key")))) {
                    throw new SysException(name + " \u76ee\u6807\u5e93\u5b57\u6bb5\u540d\u79f0\u4e3a\u7a7a " + i);
                }
                ++i;
                String defaultValue = request.getParameter(name + "columnDefault");
                String defaultType = request.getParameter(name + "dataType");
                convert = request.getParameter(name + "convertData");
                sourceType = request.getParameter(name + "sourcedataType");
                format = request.getParameter(name + "format");
                column.setSourceType(StringUtil.isNull((Object)sourceType) ? defaultType : sourceType);
                column.setFormat(format);
                column.setName1(columnName);
                column.setKey1(key);
                column.setDefaultValue(StringUtil.valueOf((String)defaultValue));
                column.setDataType(defaultType);
                column.setConvertData(StringUtil.booleanValueOf((String)convert, (boolean)false).booleanValue());
                pk = StringUtil.booleanValueOf((String)request.getParameter(name + "pk"), (boolean)false);
                column.setPk(pk);
                column.setUpdate1(!pk);
                column.setState(2);
                if (pk) {
                    pkColumn = pkColumn + "," + name;
                    targetPkColumn = targetPkColumn + "," + key;
                }
                if (name.equals(columncompare)) {
                    column.setCompare(true);
                    compareColumn = name;
                    targetCompareColumn = key;
                }
                if (name.equals(columngxsjc)) {
                    column.setGxsjc(true);
                    gxsjcColumn = name;
                }
                column.setId(IdGeneratorUtil.uuid32());
                list.add(column);
            }
        }
        this.mapperService.updateColumn(tableId, list, pkColumn, targetPkColumn, compareColumn, comparesj, targetCompareColumn, StringUtil.notNull((Object)gxsjcColumn), gxsjcColumn, pkReplace, page);
        return this.rdSuccess();
    }

    @RequestMapping(value={"deleteTable"})
    public ResponseData deleteTable(String[] ids) throws Exception {
        this.mapperService.deleteTable(ids);
        return this.rdSuccess();
    }

    @RequestMapping(value={"download"})
    public void download(HttpServletResponse response, HttpSession session) {
        StringBuilder stringBuilder = (StringBuilder)session.getAttribute("ddl");
        response.setCharacterEncoding("utf-8");
        response.reset();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/octet-stream");
        try {
            response.addHeader("Content-Disposition", "attachment;filename=" + new String("create.txt".getBytes(), "utf-8"));
            ServletOutputStream out = response.getOutputStream();
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            out.write(stringBuilder.toString().getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"genfile"})
    public void genFile(String packageName, String[] ids) throws Exception {
        File file = this.genProService.gen(packageName, ids);
        this.download1(file, file.getName());
    }

    @RequestMapping(value={"datatotal"})
    public ResponseData datatotal(String[] ids) throws Exception {
        return this.rdSuccess(this.mapperService.datatotal(ids));
    }

    @RequestMapping(value={"datattotal"})
    public ResponseData datattotal(String[] ids) throws Exception {
        return this.rdSuccess(this.mapperService.datattotal(ids));
    }
}

