/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.schedule.common2.bean.PrimaryKey;
import com.github.niupengyu.schedule.common2.bean.TaskTimer;
import com.github.niupengyu.schedule.common2.bean.TimerParam;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.exception.StopException;
import com.github.niupengyu.schedule.common2.util.ServiceUtil;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.SchedulerException;
import org.quartz.UnableToInterruptJobException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"main"})
@RestController
public class MainController
extends ClientContent {
    @Resource(name="mainService")
    private MainService mainService;

    @RequestMapping(value={"startnow"})
    public ResponseData startNow(@RequestBody TimerParam param) throws Exception {
        this.mainService.startNow(param);
        return this.rdSuccess();
    }

    @RequestMapping(value={"stopnow"})
    public ResponseData stopnow(@RequestBody TimerParam param) throws Exception {
        this.mainService.stopNow(param);
        return this.rdSuccess();
    }

    @RequestMapping(value={"startall"})
    public ResponseData startAll() throws Exception {
        this.mainService.startAll();
        return this.rdSuccess();
    }

    @RequestMapping(value={"info"})
    public ResponseData info(String key, HttpServletResponse response) throws SysException {
        if (StringUtil.isNull((Object)key)) {
            throw new SysException("\u54c8\u54c8\u54c8");
        }
        TaskTimer taskTimer = this.mainService.getTimerInfo(key);
        return this.rdSuccess(taskTimer);
    }

    @RequestMapping(value={"infos"})
    public ResponseData infos(String type, String app, String bindTask, String jobName, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int size) {
        JSONObject map = this.mainService.getTimerInfos(type, jobName, app, bindTask, page, size);
        map.put("id", (Object)ServiceUtil.serialNumber());
        return this.rdSuccess(map);
    }

    @RequestMapping(value={"timerinfos"})
    public ResponseData timerinfos(String app) {
        List<TaskTimer> map = this.mainService.getAllTimerInfos("", app, "");
        return this.rdSuccess(map);
    }

    @RequestMapping(value={"stop"})
    public ResponseData stop(String key) throws Exception {
        this.mainService.stop(key);
        return this.rdSuccess();
    }

    @RequestMapping(value={"restart"})
    public ResponseData restart(String id) {
        this.mainService.restart(id);
        return this.rdSuccess();
    }

    @RequestMapping(value={"remove"})
    public ResponseData remove(String key) throws SchedulerException {
        String msg = "";
        this.mainService.remove(key);
        return this.rdSuccess();
    }

    @RequestMapping(value={"removeall"})
    public ResponseData removeall() throws SchedulerException {
        String msg = "";
        this.mainService.removeall();
        return this.rdSuccess();
    }

    @RequestMapping(value={"add"})
    public ResponseData add(String key, String cron) throws Exception {
        this.mainService.add(key, cron);
        return this.rdSuccess();
    }

    @RequestMapping(value={"one"})
    public ResponseData one(HttpServletRequest request) throws Exception {
        HashMap param = new HashMap();
        for (Map.Entry map : request.getParameterMap().entrySet()) {
            param.put(map.getKey(), ((String[])map.getValue())[0]);
        }
        String task = (String)param.get("task");
        param.remove("task");
        PrimaryKey pk = PrimaryKey.createPrimaryKey(param);
        this.mainService.one(task, pk);
        return this.rdSuccess();
    }

    @RequestMapping(value={"onecolumn"})
    public ResponseData oneColumn(String task) throws Exception {
        Map<String, String> map = this.mainService.one(task);
        return this.rdSuccess(map);
    }

    @RequestMapping(value={"resynchronization"})
    public ResponseData resynchronization(String id) throws Exception {
        this.mainService.resynchronization(id);
        return this.rdSuccess();
    }

    @RequestMapping(value={"resynchronizationpage"})
    public ResponseData resynchronizationPage(String id) throws Exception {
        this.mainService.resynchronizationPage(id);
        return this.rdSuccess();
    }

    @RequestMapping(value={"resynchronizationall"})
    public ResponseData resynchronizationall(String id) throws Exception, StopException {
        this.mainService.resynchronizationall(id);
        return this.rdSuccess();
    }

    @RequestMapping(value={"resynchronizations"})
    public ResponseData resynchronizations(String[] ids) throws Exception, StopException {
        this.mainService.resynchronizations(ids);
        return this.rdSuccess();
    }

    @RequestMapping(value={"delete"})
    public ResponseData deleteInfo(String id) {
        this.mainService.deleteInfo(id);
        return this.rdSuccess();
    }

    @RequestMapping(value={"interrupt"})
    public ResponseData interrupt(String name) throws UnableToInterruptJobException {
        this.mainService.interrupt(name);
        return this.rdSuccess();
    }

    @RequestMapping(value={"currentjob"})
    public ResponseData currentJob() throws Exception {
        return this.rdSuccess(this.mainService.local());
    }

    @RequestMapping(value={"bindTask"})
    public ResponseData bindTask(String name) throws Exception {
        this.mainService.bindTask(name);
        return this.rdSuccess();
    }

    @RequestMapping(value={"disbindTask"})
    public ResponseData disbindTask(String name) throws Exception {
        this.mainService.disbindTask(name);
        return this.rdSuccess();
    }

    @RequestMapping(value={"setOpen"})
    public ResponseData setOpen(boolean open, String name) throws Exception {
        this.mainService.setOpen(open, name);
        return this.rdSuccess();
    }

    @RequestMapping(value={"savesch"})
    public ResponseData saveSch(TaskTimer taskTimer, String tableInfo) throws Exception {
        this.mainService.savesch(taskTimer, tableInfo);
        return this.rdSuccess();
    }

    @RequestMapping(value={"saveschedule"})
    public ResponseData saveschedule(TaskTimer taskTimer, String moduleid, String compare) throws Exception {
        this.mainService.saveschedule(taskTimer, moduleid, compare);
        return this.rdSuccess();
    }

    @RequestMapping(value={"gencode"})
    public ResponseData genCode(String id, String type) throws Exception {
        this.mainService.genCode(id, type);
        return this.rdSuccess();
    }

    @RequestMapping(value={"getById"})
    public ResponseData getById(String id) throws Exception {
        TaskTimer taskTimer = this.mainService.getTimerById(id);
        return this.rdSuccess(taskTimer);
    }

    @RequestMapping(value={"tables"})
    public ResponseData tables() {
        List<Table> list = this.mainService.tableInfo("not");
        return this.rdSuccess(list);
    }

    @RequestMapping(value={"updatesch"})
    public ResponseData updateSch(TaskTimer taskTimer, String tableInfo) {
        this.mainService.updateSch(taskTimer);
        return this.rdSuccess();
    }
}

