/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.controller;

import com.alibaba.fastjson.JSONArray;
import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.factory.SqlFactory;
import com.github.niupengyu.schedule.mains.service.DbService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dbinfo"})
public class DbController
extends ClientContent {
    @Resource(name="dbService")
    private DbService dbService;

    @RequestMapping(value={"pool"})
    public ResponseData poolInfo() {
        JSONArray array = this.dbService.poolInfo();
        return this.rdSuccess(array);
    }

    @RequestMapping(value={"taskinfo"})
    public ResponseData taskinfo(@RequestBody String name) {
        List<TaskInfo> array = this.dbService.taskinfo(name);
        return this.rdSuccess(array);
    }

    @RequestMapping(value={"dbList"})
    public ResponseData dbList() {
        return this.rdSuccess(this.dbService.list());
    }

    @RequestMapping(value={"testConn"})
    public ResponseData testConn(String id) {
        return this.rdSuccess(this.dbService.testConnection(id));
    }

    @RequestMapping(value={"testConn1"})
    public ResponseData testConn1(DbInfo dbInfo) {
        return this.rdSuccess(this.dbService.testConnection(dbInfo));
    }

    @RequestMapping(value={"testDs"})
    public ResponseData testDs(String id) {
        return this.rdSuccess();
    }

    @RequestMapping(value={"stopDb"})
    public ResponseData stopDb(String id) {
        this.dbService.stopDb(id);
        return this.rdSuccess();
    }

    @RequestMapping(value={"startDb"})
    public ResponseData startDb(String id) {
        this.dbService.startDb(id);
        return this.rdSuccess();
    }

    @RequestMapping(value={"refresh"})
    public ResponseData refresh() {
        this.dbService.refresh();
        return this.rdSuccess();
    }

    @RequestMapping(value={"save"})
    public ResponseData save(DbInfo dbInfo) {
        this.dbService.save(dbInfo);
        return this.rdSuccess();
    }

    @RequestMapping(value={"update"})
    public ResponseData update(DbInfo dbInfo) {
        this.dbService.update(dbInfo);
        return this.rdSuccess();
    }

    @RequestMapping(value={"dbSupports"})
    public ResponseData dbSupports(DbInfo dbInfo) {
        return this.rdSuccess(SqlFactory.getDbMap().keySet());
    }

    @RequestMapping(value={"test"})
    public ResponseData test(String name) {
        List<TaskInfo> array = this.dbService.test(name);
        return this.rdSuccess(array);
    }

    @RequestMapping(value={"dialect"})
    public ResponseData dialect() {
        List array = this.dbService.dialects();
        return this.rdSuccess(array);
    }

    @RequestMapping(value={"database"})
    public ResponseData database() {
        List array = this.dbService.database();
        return this.rdSuccess(array);
    }

    @RequestMapping(value={"getById"})
    public ResponseData getById(String id) {
        DbInfo array = this.dbService.getById(id);
        return this.rdSuccess(array);
    }
}

