/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.schedule.mains.bean;

import com.github.niupengyu.core.util.ThreadLocalDateUtil;
import java.util.Date;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public class Plan {
    private String id;
    private String name;
    private String task;
    private String cron;
    private int hours;
    private String start;
    private int count;
    private Date exe;
    private String end;
    private String dataStart;
    private String dataEnd;
    private int success;
    private int error;
    private int state;
    private int total;
    private int currentBatch;
    private int batchTotal;
    private int localPage;
    private int totalPage;
    private int size;
    private String status = "NONE";
    private String bean;
    private String previousFireTime;
    private String nextFireTime;
    private String createDate;

    public void init(Scheduler scheduler) {
        TriggerKey tk = TriggerKey.triggerKey((String)(this.id + "trigger"), (String)"planTriggerGroup");
        try {
            Trigger t = scheduler.getTrigger(tk);
            if (t != null) {
                this.nextFireTime = this.value(t.getNextFireTime());
                this.previousFireTime = this.value(t.getPreviousFireTime());
                this.status = scheduler.getTriggerState(tk).name();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    private String value(Date date) {
        if (date != null) {
            return ThreadLocalDateUtil.formatDate((Date)date, (int)1);
        }
        return "0";
    }

    public String getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setPreviousFireTime(String previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public String getNextFireTime() {
        return this.nextFireTime;
    }

    public void setNextFireTime(String nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Date getExe() {
        return this.exe;
    }

    public void setExe(Date exe) {
        this.exe = exe;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getDataStart() {
        return this.dataStart;
    }

    public void setDataStart(String dataStart) {
        this.dataStart = dataStart;
    }

    public String getDataEnd() {
        return this.dataEnd;
    }

    public void setDataEnd(String dataEnd) {
        this.dataEnd = dataEnd;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getCurrentBatch() {
        return this.currentBatch;
    }

    public void setCurrentBatch(int currentBatch) {
        this.currentBatch = currentBatch;
    }

    public int getBatchTotal() {
        return this.batchTotal;
    }

    public void setBatchTotal(int batchTotal) {
        this.batchTotal = batchTotal;
    }

    public int getLocalPage() {
        return this.localPage;
    }

    public void setLocalPage(int localPage) {
        this.localPage = localPage;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getSuccess() {
        return this.success;
    }

    public void setSuccess(int success) {
        this.success = success;
    }

    public int getError() {
        return this.error;
    }

    public void setError(int error) {
        this.error = error;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String toString() {
        return "Plan{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", task='" + this.task + '\'' + ", cron='" + this.cron + '\'' + ", hours=" + this.hours + ", start='" + this.start + '\'' + ", count=" + this.count + ", exe=" + this.exe + ", end='" + this.end + '\'' + ", dataStart='" + this.dataStart + '\'' + ", dataEnd='" + this.dataEnd + '\'' + ", success=" + this.success + ", error=" + this.error + ", state=" + this.state + ", total=" + this.total + ", currentBatch=" + this.currentBatch + ", batchTotal=" + this.batchTotal + ", localPage=" + this.localPage + ", totalPage=" + this.totalPage + ", size=" + this.size + ", status='" + this.status + '\'' + ", bean='" + this.bean + '\'' + ", previousFireTime='" + this.previousFireTime + '\'' + ", nextFireTime='" + this.nextFireTime + '\'' + '}';
    }
}

