package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.core.util.PageUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.schedule.beans.Module;
import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.bean.TaskTimer;
import com.github.niupengyu.schedule.common2.bean.common.Column;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.bean.common.Sql;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.exception.StopException;
import com.github.niupengyu.schedule.common2.log.LoggerManager;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.distributed.data.DistributeInfo;
import com.github.niupengyu.schedule.mains.dao.ExceptionDao;
import com.github.niupengyu.schedule.mains.dao.ScheduleDao;
import com.github.niupengyu.schedule.mains.dao.TableMapperDao;
import com.github.niupengyu.schedule.mains.dao.TaskInfoDao;
import com.alibaba.fastjson.JSONObject;
import com.github.niupengyu.schedule.listener.service.ScheduleInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.json.JsonObject;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("taskInfoService")
class TaskInfoServiceImpl implements TaskInfoService{

    @Autowired
    private TaskInfoDao taskInfoDao;

    @Autowired
    private TableMapperDao tableMapperDao;

    @Autowired
    private ScheduleDao scheduleDao;

    @Resource(name = "scheduleInfoService")
    private ScheduleInfoService scheduleInfoService;

    private static final Logger logger= LoggerFactory.getLogger(TaskInfoServiceImpl.class);


    public void exceptionInfos(List<Map<String,Object>> datas, String task, String message,int num)  {
        JSONObject obj=new JSONObject();
        obj.put("method", "exceptionErrorInfos");
        obj.put("datas", datas);
        obj.put("task", task);
        obj.put("message", message);
        obj.put("num", num);
        try {
            logger.info("exceptionInfos ");
            scheduleInfoService.addInfo(obj);
        } catch (SysException e) {
            logger.error("消息发送失败",e);
        }
    }

    public void exceptionInfo(Map<String,Object> map, String task, String message,int num) {
        JSONObject obj=new JSONObject();
        obj.put("method", "exceptionErrorInfo");
        obj.put("data", map);
        obj.put("task", task);
        obj.put("message", message);
        obj.put("num", num);
        try {
            scheduleInfoService.addInfo(obj);
        } catch (SysException e) {
            logger.error("消息发送失败",e);
        }
    }

    public void exceptionInfo(String data, String task, String message,int num)  {
        JSONObject obj=new JSONObject();
        obj.put("method", "exceptionStrErrorInfo");
        obj.put("data", data);
        obj.put("task", task);
        obj.put("message", message);
        obj.put("num", num);
        try {
            scheduleInfoService.addInfo(obj);
        } catch (SysException e) {
            logger.error("消息发送失败",e);
        }
    }

    public void updateTime(String name,String date){

        scheduleDao.updateTime(name,date);
    }

    @Override
    public TaskTimer getTimer(String name) {
        return scheduleDao.getByName(name);
    }

    public void exceptionInfo(String data, String task, String message){
        JSONObject obj=new JSONObject();
        obj.put("method", "exceptionInfo");
        obj.put("data", data);
        obj.put("task", task);
        obj.put("message", message);
        try {
            scheduleInfoService.addInfo(obj);
        } catch (SysException e) {
            logger.error("消息发送失败",e);
        }
    }

    public void stopException() throws StopException {
        throw new StopException("任务被手动停止");
    }

    public void saveTaskInfo(TaskInfo taskInfo) {
        taskInfoDao.insertTask(taskInfo);
    }


    public void success(String id,int num){
        taskInfoDao.success(id,num);
    }



    public void total(String id,int num){
        taskInfoDao.total(id,num);
    }

    public void addTotal(String id,int num){
        taskInfoDao.addTotal(id,num);
    }

    public void state(String id, int state){
        Date date=new Date();
        this.taskInfoDao.state(id,state,date);
    }

    /*public void end(String id,int total){
        Date date=new Date();
        this.taskInfoDao.state(id,1,date,total);
    }*/

    public void taskPageTotal( String id, int num){
        this.taskInfoDao.taskPageTotal(id,num);
    }

    public void updatePage( String id, int page){
        this.taskInfoDao.updatePage(id,page);
    }

    public List<TaskInfo> dayList(String name,String time) {
        String start="";
        String end="";
        if(StringUtil.notNull(time)){
            start=time+ DateUtil.FIRST_TIME;
            end=time+ DateUtil.LAST_TIME;
        }
        /*String start=time+ DateUtil.FIRST_TIME;
        String end=time+ DateUtil.LAST_TIME;*/

        return this.taskInfoDao.dayList(name,start,end);
    }

    public List<TaskInfo> dayNowList(String app,String name) {
        return this.taskInfoDao.dayNowList(app,name,"","now","","","");
    }

    public List<TaskInfo> allNowList(String app,String name,String timeFrame,String taskstate,String tasktype,String time) {
        String start="";
        String end="";
        if(StringUtil.notNull(time)){
            start=time+ DateUtil.FIRST_TIME;
            end=time+ DateUtil.LAST_TIME;
        }
        return this.taskInfoDao.dayNowList(app,name,timeFrame,taskstate,tasktype,start,end);
    }

    public JSONObject allNowList(String app, String name, String timeFrame,
                                 String taskstate, String tasktype, String time, int page, int size) {
        String start="";
        String end="";
        if(StringUtil.isNull(time)){
            time=DateUtil.dateFormatDate();
        }
        start=time+ DateUtil.FIRST_TIME;
        end=time+ DateUtil.LAST_TIME;
        //return this.taskInfoDao.dayNowPageList(app,name,timeFrame,taskstate,tasktype,start,end,page,size);

        int startPage= PageUtil.start(page,size);
        List<TaskInfo> data=this.taskInfoDao.dayNowPageList(app,name,timeFrame,taskstate,tasktype,start,end,startPage,size);

        int count=this.taskInfoDao.dayNowPageCount(app,name,timeFrame,taskstate,tasktype,start,end);
        JSONObject res=new JSONObject();
        res.put("data",data);
        res.put("total",count);
        return res;
    }

    public List<TaskInfo> dayErrorList(String name) {
        return this.taskInfoDao.dayErrorList(name);
    }

    public void updateBatch(long day,int batchTotal,String id,int target) {
        this.taskInfoDao.updateBatch(day,batchTotal,id,target);
    }

    public void updateCurrentBatch(long day,String id) {
        this.taskInfoDao.updateCurrentBatch(day,id);
    }

    public void updateAddCurrentBatch(long day,String id) {
        this.taskInfoDao.updateAddCurrentBatch(day,id);
    }

    public void deleteInfo(String id) {
        this.taskInfoDao.deleteInfo(id);
    }

    public void update(String id, int i) {
        taskInfoDao.update(id,i);
    }

    public void insert(String id, int i) {
        taskInfoDao.insert(id,i);
    }

    public void updateSuccess(String id, int i,int success) {
        taskInfoDao.updateSuccess(id,i,success);
    }

    public void insertSuccess(String id, int i,int success) {
        taskInfoDao.insertSuccess(id,i,success);
    }

    public void insertUpdateSuccess(String id, int i,int u,int success) {
        taskInfoDao.insertUpdateSuccess(id,i,u,success);
    }

    public void insertUpdateDeleteSuccess(String id, int i,int u,int d,int success) {
        taskInfoDao.insertUpdateDeleteSuccess(id,i,u,d,success);
    }

    public List<TaskInfo> list(String id, String time) {

        return this.taskInfoDao.list(id,time);
    }


    public void updateDelete(String id, int i) {
        taskInfoDao.updateDelete(id,i);
    }

    @Override
    public DbInfo selectDbInfo(String id) {
        return tableMapperDao.selectDbInfo(id);
    }

    @Override
    public Table tableInfo(String id) {
        return tableMapperDao.tableInfo(id);
    }

    @Override
    public List<Column> column(String id) {
        return tableMapperDao.column(id);
    }

    @Override
    public Sql sql(String id) {
        return tableMapperDao.sql(id);
    }


    @Override
    public void exceptionInfo(String data1, String id, String message, int num,
                              int batch, int startPage, String taskStart, String taskEnd,boolean isDay,int size) {
        JSONObject obj=new JSONObject();
        obj.put("method", "exceptionPageErrorInfos");

        JSONObject data=new JSONObject();
        data.put("batch",batch);
        data.put("startPage",startPage);
        data.put("taskStart",taskStart);
        data.put("taskEnd",taskEnd);
        data.put("isDay",isDay);
        data.put("size",size);
        data.put("errorMessage",message);

        obj.put("data", data.toJSONString());
        obj.put("task", id);
        obj.put("message", data1);
        //obj.put("batch", batch);
        //obj.put("startPage", startPage);
        //obj.put("taskStart", taskStart);
        //obj.put("taskEnd", taskEnd);
        try {
            logger.info("exceptionPageErrorInfos ");
            scheduleInfoService.addInfo(obj);
        } catch (SysException e) {
            logger.error("消息发送失败",e);
        }
    }

    @Override
    public void addRealTotal(String id, int size) {
        this.taskInfoDao.updateTealTotal(id,size);
    }
}
